Scriptname _SC_mountSpeed_script extends activemagiceffect  

Actor theHorse
float baseSpeed
float adjustSpeed
float maxSpeed
float minSpeed
float maxSprintSpeed
float adjustSprintSpeed

Event OnEffectStart(Actor akTarget, Actor akCaster)
	theHorse = akTarget
	baseSpeed = theHorse.getAV("speedMult")
	adjustSpeed = baseSpeed*0.1
	maxSpeed = baseSpeed*1.5
	minSpeed = baseSpeed*0.7
	maxSprintSpeed = baseSpeed*2
	adjustSprintSpeed = baseSpeed*0.2
	theHorse.forceAV("speedMult", minSpeed)
	speedAdjustWork()
	if (theHorse.GetAnimationVariablebool("IsSprinting"))
		gotoState("Sprint")
	else
		gotoState("Run")
	endif
	RegisterForSingleUpdate(1)
EndEvent

Event OnUpdate()
	if !(theHorse.GetAnimationVariablebool("IsMoving"))
		theHorse.forceAV("speedMult", minSpeed)
		speedAdjustWork()
	endif
	RegisterForSingleUpdate(1)
EndEvent

Function speedAdjustWork()
	theHorse.ModActorValue("CarryWeight",0.1)
	theHorse.ModActorValue("CarryWeight",-0.1)
EndFunction

;========================
State Run
Event OnBeginState()
	RegisterForAnimationEvent(theHorse,"HorseSprint")
	RegisterForAnimationEvent(theHorse,"FootFront")
	RegisterForAnimationEvent(theHorse,"FootBack")
EndEvent
Event OnAnimationEvent(ObjectReference akSource, string asEventName)
	if (asEventName == "HorseSprint")
		gotoState("Sprint")
;		debug.notification("HorseSprint")
	elseif (asEventName == "FootFront") || (asEventName == "FootBack")
		float nowSpeed = theHorse.getAV("speedMult")
		if (nowSpeed < maxSpeed) ;speed up
			theHorse.modAV("speedMult", adjustSpeed+utility.randomint(-2,2))
			speedAdjustWork()
		elseif (nowSpeed > maxSpeed) ;slow down
			theHorse.modAV("speedMult", -0.2*adjustSpeed)
			speedAdjustWork()
		endif
	;	utility.wait(0.5)
	endif
EndEvent
Function speedAdjustWork()
	theHorse.ModActorValue("CarryWeight",0.1)
	theHorse.ModActorValue("CarryWeight",-0.1)
EndFunction
EndState
;========================

;========================
State Sprint
Event OnBeginState()
	float nowSpeed = theHorse.getAV("speedMult")
	if (nowSpeed < maxSpeed)
		theHorse.modAV("speedMult", adjustSprintSpeed+utility.randomint(-4,4))
		speedAdjustWork()
	elseif (nowSpeed < maxSprintSpeed)
		theHorse.modAV("speedMult", adjustSpeed+utility.randomint(-2,2))
	endif
	RegisterForAnimationEvent(theHorse,"FootFront")
	RegisterForAnimationEvent(theHorse,"FootBack")
EndEvent
Event OnAnimationEvent(ObjectReference akSource, string asEventName)
	if (asEventName == "FootFront") || (asEventName == "FootBack")
		float nowSpeed = theHorse.getAV("speedMult")
		if (nowSpeed < maxSpeed)
			theHorse.modAV("speedMult", adjustSprintSpeed+utility.randomint(-4,4))
			speedAdjustWork()
		elseif (nowSpeed < maxSprintSpeed)
			theHorse.modAV("speedMult", adjustSpeed+utility.randomint(-2,2))
		endif
	;	utility.wait(0.5)
		if (theHorse.getAV("Stamina") < 1)
			debug.sendAnimationEvent(theHorse, "SprintStop")
		endif
		if !(theHorse.GetAnimationVariablebool("IsSprinting"))
			gotoState("Run")
		endif
	endif
EndEvent
Function speedAdjustWork()
	theHorse.ModActorValue("CarryWeight",0.1)
	theHorse.ModActorValue("CarryWeight",-0.1)
EndFunction
EndState
;========================


