Scriptname _SC_player_mountCrash_script extends activemagiceffect  

Spell Property _SC_mountCrashSmall_spell auto
Spell Property _SC_mountCrashMedium_spell auto
Spell Property _SC_mountCrashLarge_spell auto
FormList property horseList auto

Actor playerRef
Actor theHorse
float HorseSpeed
bool OnMount = false

Event OnEffectStart(Actor akTarget, Actor akCaster)
	playerRef = Game.getPlayer()
	registerForSingleUpdate(1)
EndEvent

Event OnUpdate()
	if (OnMount == false) && (playerRef.isOnMount())
		OnMount = true
		theHorse = (Game.FindClosestReferenceOfAnyTypeInListFromRef(horseList,playerRef,150.0) as Form) as Actor	
	elseif !(playerRef.isOnMount())
		OnMount = false
	endif
	if (playerRef.isInCombat()) && (playerRef.isOnMount())
		HorseSpeed = theHorse.getActorValue("speedMult")
		if (HorseSpeed > 180)
			_SC_mountCrashLarge_spell.cast(theHorse)
		elseif (HorseSpeed > 150)
			_SC_mountCrashMedium_spell.cast(theHorse)
		elseif (HorseSpeed > 120)
			_SC_mountCrashSmall_spell.cast(theHorse)
		endif
		registerForSingleUpdate(1)
	else
		registerForSingleUpdate(3)
	endif
EndEvent