Scriptname _SC_riderAttackAI_script extends activemagiceffect  

FormList property horseList auto
GlobalVariable property _SC_NPC_mountAttackEditing auto
GlobalVariable property _SC_NPC_mountAttackBlockEditing auto
Spell property _SC_NPC_mountAttack_spell auto
Spell property _SC_NPC_MountAttackBlock_spell auto

Actor rider
Actor theHorse
Actor theCombatTarget
Actor targetHorse
Actor playerRef
bool mountedCombatStart = false
float horseSpeed
float mountDamage
float theWeaponSpeed
float targetSpeed
Weapon lastMeleeWeapon
float R_gHA_T
float T_gHA_R

Event OnEffectStart(Actor akTarget, Actor akCaster)
	rider = akTarget
	playerRef = Game.GetPlayer()
	registerForAnimationEvent(rider, "weaponSwing")
	if (rider.IsInCombat()) && (rider.IsOnMount())
		GotoState("MountCombat")
	else
		GotoState("NotMountCombat")
	endif
EndEvent


State NotMountCombat
Event OnBeginState()
	registerForSingleUpdate(1)
endEvent
Event OnUpdate()
	if (rider.IsInCombat()) && (rider.IsOnMount()) ;&& (mountedCombatStart == false)
		;mountedCombatStart = true
		if (rider.GetEquippedWeapon().getWeaponType() > 6)
			rider.equipItem(lastMeleeWeapon, false, true)
		endif
		rider.drawWeapon()
		theHorse = (Game.FindClosestReferenceOfAnyTypeInListFromRef(horseList,playerRef,150.0) as Form) as Actor
		GotoState("MountCombat")
	else	
		RegisterForSingleUpdate(1)
	endif
EndEvent
endState


State MountCombat

Event OnBeginState()
	registerForSingleUpdate(1)
endEvent
	
Event OnUpdate()
	if (rider.IsOnMount()) && (rider.IsInCombat())
		if !(rider.isWeaponDrawn())
			rider.drawWeapon()	
		endif
		theCombatTarget = rider.GetCombatTarget()
		;/
		if (theCombatTarget.IsOnMount())
			T_gHA_R = theCombatTarget.GetHeadingAngle(rider)
			targetHorse = (Game.FindClosestReferenceOfAnyTypeInListFromRef(horseList,theCombatTarget,150.0) as Form) as Actor
			if (R_gHA_T*T_gHA_R > 0)
				targetSpeed = targetHorse.getActorValue("speedmult")
			else
				targetSpeed = -targetHorse.getActorValue("speedmult")
			endif
		else
			targetSpeed = 0
		endif
		/;
		if (rider.getDistance(theCombatTarget) < 400 + theHorse.getActorValue("speedmult")*4.5 ) && !(rider.getAnimationVariableBool("isAttacking"))
			R_gHA_T = rider.GetHeadingAngle(theCombatTarget)
			if (R_gHA_T > 0)
				debug.sendAnimationEvent(rider,"attackStart_MC_1HMRight")
			else
				debug.sendAnimationEvent(rider,"attackStart_MC_1HMLeft")
			endif
			RegisterForSingleUpdate(0.5)
		else
			RegisterForSingleUpdate(0.01)	
		endif		
	else
		GotoState("NotMountCombat")
		;mountedCombatStart = false
	endif	
EndEvent

Event OnAnimationEvent(ObjectReference akSource, string asEventName)
	if (rider.IsOnMount()) && (rider.IsInCombat()) && (R_gHA_T*rider.GetHeadingAngle(theCombatTarget) > 0)
		horseSpeed = theHorse.getActorValue("speedmult")
		if (Math.abs(theCombatTarget.GetHeadingAngle(rider)) < 45) && (theCombatTarget.getAnimationVariableBool("isBlocking"))
			if (theHorse.GetAnimationVariablebool("IsSprinting"))
				mountDamage = (horseSpeed - 100)*0.1 + (playerRef.getLevel()*2)
			else
				mountDamage = (horseSpeed - 100)*0.1 + (playerRef.getLevel())
			endif
			if (mountDamage < 15)
				mountDamage = 15
			endif
			bool b = true
			while (b==true)
				if (_SC_NPC_MountAttackBlockEditing.getValue()==0)
					_SC_NPC_MountAttackBlockEditing.setValue(1)
					_SC_NPC_MountAttackBlock_spell.SetNthEffectMagnitude(0, mountDamage)
					_SC_NPC_MountAttackBlock_spell.cast(rider,theCombatTarget)
					_SC_NPC_MountAttackBlockEditing.setValue(0)
					b = false
				else
					utility.wait(0.1)
				endif
			endwhile
		else
			if (theHorse.GetAnimationVariablebool("IsSprinting"))
				mountDamage = (horseSpeed + targetSpeed - 100)*0.5 + (playerRef.getLevel()*10)
			else
				mountDamage = (horseSpeed + targetSpeed - 100)*0.5 + (playerRef.getLevel()*5)
			endif
			if (mountDamage < 30)
				mountDamage = 30
			endif
			bool b = true
			while (b==true)
				if (_SC_NPC_mountAttackEditing.getValue()==0)
					_SC_NPC_mountAttackEditing.setValue(1)
					_SC_NPC_mountAttack_spell.SetNthEffectMagnitude(0, mountDamage)
					_SC_NPC_mountAttack_spell.cast(rider,theCombatTarget)
					_SC_NPC_mountAttackEditing.setValue(0)
					b = false
				else
					utility.wait(0.1)
				endif
			endwhile
		endif
	endif	
EndEvent

Event OnObjectUnequipped(Form akBaseObject, ObjectReference akReference)
	if (akBaseObject as Weapon)
		Weapon UnequippedWeapon = (akReference as Form) as Weapon
		int theWeaponType = UnequippedWeapon.getWeaponType()
		if (theWeaponType < 7)
			lastMeleeWeapon = UnequippedWeapon 
		endif
	endif
EndEvent

endState