Scriptname _SC_riderMountCrash_script extends activemagiceffect  

Spell Property _SC_mountCrashSmall_spell auto
Spell Property _SC_mountCrashMedium_spell auto
Spell Property _SC_mountCrashLarge_spell auto
FormList property horseList auto

Actor rider
Actor theHorse
Actor theCombatTarget
float HorseSpeed
bool OnMount = false

Event OnEffectStart(Actor akTarget, Actor akCaster)
	rider = akTarget
	registerForSingleUpdate(1)
EndEvent

Event OnUpdate()
	if (OnMount == false) && (rider.isOnMount())
		OnMount = true
		theHorse = (Game.FindClosestReferenceOfAnyTypeInListFromRef(horseList,rider,150.0) as Form) as Actor	
	elseif !(rider.isOnMount())
		OnMount = false
	endif
	if (rider.isInCombat()) && (rider.isOnMount()) 
		theCombatTarget = rider.getCombatTarget()
		if (Math.abs(rider.GetHeadingAngle(theCombatTarget)) < 30) && (rider.getDistance(theCombatTarget) < 500)
			HorseSpeed = theHorse.getActorValue("speedMult")
			if (HorseSpeed > 180)
				_SC_mountCrashLarge_spell.cast(theHorse)
			elseif (HorseSpeed > 150)
				_SC_mountCrashMedium_spell.cast(theHorse)
			elseif (HorseSpeed > 120)
				_SC_mountCrashSmall_spell.cast(theHorse)
			endif
			registerForSingleUpdate(1)
		else
			registerForSingleUpdate(0.1)	
		endif
	else
		registerForSingleUpdate(3)
	endif
EndEvent