Scriptname _SC_riderMoveAI_script extends activemagiceffect  

FormList property horseList auto
KeyWord property _SC_mountedCombatXMark_keyword auto
Package property _SC_Cavalry_FollowCaptainCombat_Package auto
Actor rider
float chargeDamage
Actor theHorse
float horseSpeed
Actor theCombatTarget
Weapon theWeapon
ObjectReference combatXMark
int aloofTimes = 0

Event OnEffectStart(Actor akTarget, Actor akCaster)
	rider = akTarget
	if (rider.IsInCombat()) && (rider.IsOnMount())
		GotoState("MountCombat")
	else
		GotoState("NotMountCombat")
	endif
EndEvent

State NotMountCombat
	Event OnBeginState()
		registerForSingleUpdate(1)
	endEvent

	Event OnUpdate()
		if (rider.IsInCombat()) && (rider.IsOnMount()) 
			theHorse = (Game.FindClosestReferenceOfAnyTypeInListFromRef(horseList,rider,150.0) as Form) as Actor	
			GotoState("MountCombat")
		else
			registerForSingleUpdate(1)
		endif
	EndEvent
endState

State MountCombat
	Event OnBeginState()
		combatXMark = rider.getLinkedRef(_SC_mountedCombatXMark_keyword)
		rider.EvaluatePackage()
		registerForSingleUpdate(0.5)
	endEvent

	Event OnUpdate()
		if (rider.IsOnMount()) && (rider.IsInCombat())  
			debug.sendAnimationEvent(theHorse, "SprintStart")
			theCombatTarget = rider.GetCombatTarget()
			if (aloofTimes > 10)
				aloofTimes -= 1
				combatXMark.moveto(theCombatTarget, 200.0*Math.Sin(theHorse.GetAngleZ()), 200.0*Math.Cos(theHorse.GetAngleZ()), 30.0)	
				RegisterForSingleUpdate(0.5)
			elseif (Math.abs(rider.GetHeadingAngle(theCombatTarget)) < 45) 
				combatXMark.moveto(theCombatTarget, 200.0*Math.Sin(theHorse.GetAngleZ()), 200.0*Math.Cos(theHorse.GetAngleZ()), 30.0)	
				RegisterForSingleUpdate(0.5)
				aloofTimes = 0
			else
				if (rider.getDistance(theCombatTarget) < 1000) 
					combatXMark.moveto(theHorse, 500.0*Math.Sin(theHorse.GetAngleZ()), 500.0*Math.Cos(theHorse.GetAngleZ()), 30.0)
				else
					if (rider.GetHeadingAngle(theCombatTarget) < 0) 
						turnLeft(30.0)
					else
						turnRight(30.0)
					endif
				endif
				aloofTimes += 1
				RegisterForSingleUpdate(0.5)
			endif
			theHorse.pathToReference(combatXMark, 1.0)
		else
			debug.sendAnimationEvent(theHorse, "SprintStop")
			GotoState("NotMountCombat")
		endif	
	EndEvent

	Function turnLeft(float turnAngle)
		float oldAngle = theHorse.GetAngleZ()
		combatXMark.moveto(theHorse, 500.0*Math.Sin(oldAngle - turnAngle), 500.0*Math.Cos(oldAngle - turnAngle), 30.0)
	endFunction

	Function turnRight(float turnAngle)
		float oldAngle = theHorse.GetAngleZ()
		combatXMark.moveto(theHorse, 500.0*Math.Sin(oldAngle + turnAngle), 500.0*Math.Cos(oldAngle + turnAngle), 30.0)
	endFunction

endState

Function turnLeft(float turnAngle)
endFunction

Function turnRight(float turnAngle)
endFunction
