local MakePlayerCharacter = require "prefabs/player_common"

local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/sari.zip" ),
}
local prefabs = {
}

-- Custom starting items
local start_inv = {
    "saricatsword",
}

local fn = function(inst)

	inst.soundsname = "wendy"

	inst.MiniMapEntity:SetIcon( "sari.tex" )

	inst.components.health:SetMaxHealth(100)
	inst.components.hunger:SetMax(75)
	inst.components.sanity:SetMax(75)
	inst.components.hunger.hungerrate = 1.2 * TUNING.WILSON_HUNGER_RATE
	inst.components.locomotor.walkspeed = 5
	inst.components.locomotor.runspeed = 6
    inst.components.health.fire_damage_scale = 1.5
    inst.components.sanity.dapperness = TUNING.DAPPERNESS_MED
    inst.components.sanity.night_drain_mult = 1.1
    inst.components.sanity.neg_aura_mult = 1.2
    inst.components.combat.damagemultiplier = 0.9
    inst.components.combat.min_attack_period =0.55

    local saricatsword = Recipe("saricatsword", {Ingredient("coontail", 4), Ingredient("goldnugget", 2), Ingredient("hambat", 1)}, RECIPETABS.WAR, {SCIENCE = 2})
    saricatsword.atlas = "images/inventoryimages/saricatsword.xml"
    saricatsword.sortkey = 1

    local saribackpack = Recipe("saribackpack", {Ingredient("coontail", 10), Ingredient("greengem",1), Ingredient("purplegem", 1)}, RECIPETABS.MAGIC, {SCIENCE = 2})
    saribackpack.atlas = "images/inventoryimages/saribackpack.xml"
    saribackpack.sortkey = 1

end

return MakePlayerCharacter("sari", prefabs, assets, fn, start_inv)