local assets=
{
    Asset("ANIM", "anim/backpack.zip"),
    Asset("ANIM", "anim/swap_saribackpack.zip"),
    Asset("IMAGE", "images/inventoryimages/saribackpack.tex"),
    Asset("ATLAS", "images/inventoryimages/saribackpack.xml"),
}

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_body", "swap_saribackpack", "backpack")
    owner.AnimState:OverrideSymbol("swap_body", "swap_saribackpack", "swap_body")
    owner.components.inventory:SetOverflow(inst)

    inst.components.container:Open(owner)
end

local function onunequip(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_body")
    owner.AnimState:ClearOverrideSymbol("backpack")
    owner.components.inventory:SetOverflow(nil)

    inst.components.container:Close(owner)
end

local slotpos = {}

for y = 0, 5 do
    table.insert(slotpos, Vector3(-162, -y*75 + 170 ,0))
    table.insert(slotpos, Vector3(-162 +75, -y*75 + 170 ,0))
end

local function fn(Sim)
    local inst = CreateEntity()
    
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("saribackpack")
    inst.AnimState:SetBuild("swap_saribackpack")
    inst.AnimState:PlayAnimation("anim")
    
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/saribackpack.xml"
    inst.components.inventoryitem.cangoincontainer = false
    inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/krampuspack"
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY    
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )       
    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos)
    inst.components.container.widgetslotpos = slotpos
    inst.components.container.widgetanimbank = "ui_piggyback_2x6"
    inst.components.container.widgetanimbuild = "ui_piggyback_2x6"
    inst.components.container.widgetpos = Vector3(-5,-85,0)
    inst.components.container.side_widget = true    
    inst.components.container.type = "pack"
   
    return inst
end

return Prefab( "common/inventory/saribackpack", fn, assets) 
