local require = GLOBAL.require
require "samansha_util"
require "sa_mobexptable"
require "sa_mobbloodtable"
local Lang = GetModConfigData("Lang")---
local LanguageFile = "STRINGS_English.lua"
if Lang == 1 then
	LanguageFile = "STRINGS_Chinese.lua"
end
modimport(LanguageFile)
local UI_SCALE =  GetModConfigData("UI_Scale")
local DIFFICULTY = GetModConfigData("Difficulty")
GLOBAL.KEY_ULTIMATE = GetModConfigData("Key_Ultimate")
GLOBAL.KEY_NORMAL_1 = GetModConfigData("Key_A1")
GLOBAL.KEY_NORMAL_2 = GetModConfigData("Key_A2")
GLOBAL.KEY_NORMAL_3 = GetModConfigData("Key_A3")
GLOBAL.KEY_DEER_FOLLOW = GetModConfigData("Key_Deer_Follow")
local compass = GetModConfigData("Compass")
PrefabFiles = {
	"samansha",
	
	"hat_eyeshade",
	"bloodometer",
	
	"deer",
	"deerhat",
	"deerhorn",
	"deerheart",
	
	"lotus",
	"lotus_seed",
	"lotus_leaf",
	"lotus_pond",
	"lotus_umbrella",
	
	"fx_levelup",
	"buff_accelerate",
	"buff_ultimate",
	"buff_dizzy",
	"buff_sq",
	"magicfile",	
	
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/samansha.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/samansha.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/samansha.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/samansha.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/samansha_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/samansha_silho.xml" ),

    Asset( "IMAGE", "bigportraits/samansha.tex" ),
    Asset( "ATLAS", "bigportraits/samansha.xml" ),
	
	Asset( "IMAGE", "images/map_icons/samansha.tex" ),
	Asset( "ATLAS", "images/map_icons/samansha.xml" ),
	
	Asset( "IMAGE", "images/map_icons/lotus_pond.tex" ),
	Asset( "ATLAS", "images/map_icons/lotus_pond.xml" ),	

	--Ӹwidgets
	Asset("ANIM", "anim/ultimate_cd.zip"),
	Asset("ANIM", "anim/passive_cd.zip"),
	Asset("ANIM", "anim/normal_cd.zip"),
	Asset("ANIM", "anim/compass_bg.zip"),
	Asset("ANIM", "anim/compass_needle.zip"),
	Asset( "IMAGE", "images/skillpoint_button.tex" ),	
    Asset( "ATLAS", "images/skillpoint_button.xml" ),	
	Asset( "ATLAS", "images/HUD/BuffUI.xml" ),	
	
	--Ǹͼõ
	Asset( "ATLAS", "images/samansha_tab.xml" ),	
	Asset( "IMAGE", "images/lotus_pond.tex" ),	
    Asset( "ATLAS", "images/lotus_pond.xml" ),		
}
--Ԥ衪

local STRINGS = GLOBAL.STRINGS
local Recipe = GLOBAL.Recipe
local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local TECH = GLOBAL.TECH
local SpawnPrefab = GLOBAL.SpawnPrefab
local TheInput = GLOBAL.TheInput
local Vector3 = GLOBAL.Vector3
local FindEntity =GLOBAL.FindEntity
local TUNING = GLOBAL.TUNING
local GetPlayer = GLOBAL.GetPlayer
local GetWorld = GLOBAL.GetWorld
local GetClock = GLOBAL.GetClock
local ACTIONS = GLOBAL.ACTIONS
local Action = GLOBAL.Action
local SA_BLOOD_TABLE = GLOBAL.SA_BLOOD_TABLE
local SA_MOBEXP_TABLE = GLOBAL.SA_MOBEXP_TABLE
local GenerateNormal = GLOBAL.GenerateNormal
local SpawnToInst = GLOBAL.SpawnToInst
local GetValidBoss = GLOBAL.GetValidBoss
local GetValidEpic = GLOBAL.GetValidEpic
--ȫֵTUNING

--һĶ
local CASTMAGIC = Action(10,true)
CASTMAGIC.str = "ͷż"
CASTMAGIC.id = "CASTMAGIC"
CASTMAGIC.distance=math.huge
CASTMAGIC.fn = function(act)
	if act.castFn then
		act.castFn(act.doer,act.target or nil,act.pos or nil)
	end
	if act.doer.components.playeractionpicker.rightclickoverride ~= nil then
		act.doer.components.playeractionpicker.rightclickoverride = nil
	end
	return true
end
AddAction(CASTMAGIC)



--һЩҪͨAPIϷԤɵԡ
--AddPrefabPostInit

local function NoPetalsEvil(inst)
	
	local self = inst.components.lootdropper
	local function GenerateLoot()
		local loots = {}

		if self.lootsetupfn then
			self.lootsetupfn(self)
		end
		
		if self.numrandomloot and math.random() <= (self.chancerandomloot or 1) then
			for k = 1, self.numrandomloot do
				local loot = self:PickRandomLoot()
				if loot then
					table.insert(loots, loot)
				end
			end
		end
		
		if self.chanceloot then
			for k,v in pairs(self.chanceloot) do
				if v.chance >= 1.0 then
					table.insert(loots, v.prefab)
				elseif math.random() < v.chance then
					table.insert(loots, v.prefab)
					self.droppingchanceloot = true
				end
			end
		end

		if self.chanceloottable then
			local loot_table = LootTables[self.chanceloottable]
			if loot_table then
				for i, entry in ipairs(loot_table) do
					local prefab = entry[1]
					local chance = entry[2]    			
					if chance >= 1.0 then
						table.insert(loots, prefab)
					elseif math.random() <= chance then
						table.insert(loots, prefab)
						self.droppingchanceloot = true
					end
				end
			end
		end

		if not self.droppingchanceloot and self.ifnotchanceloot then
			self.inst:PushEvent("ifnotchanceloot")
			for k,v in pairs(self.ifnotchanceloot) do
				table.insert(loots, v.prefab)
			end
		end


		
		if self.loot then
			for k,v in ipairs(self.loot) do
				table.insert(loots, v)
			end
		end
		
		

		if recipe then
			local percent = 1

			if self.inst.components.finiteuses then
				percent = self.inst.components.finiteuses:GetPercent()
			end

			for k,v in ipairs(recipe.ingredients) do
				local amt = math.ceil( (v.amount * TUNING.HAMMER_LOOT_PERCENT) * percent)
				if self.inst:HasTag("burnt") then 
					amt = math.ceil( (v.amount * TUNING.BURNT_HAMMER_LOOT_PERCENT) * percent)
				end
				for n = 1, amt do
					table.insert(loots, v.type)
				end
			end
		end
		
		if self.inst:HasTag("burnt") and math.random() < .4 then
			table.insert(loots, "charcoal") -- Add charcoal to loot for burnt structures
		end

		return loots
	end
	
	self.GenerateLoot = GenerateLoot


end
AddPrefabPostInit("butterfly",NoPetalsEvil)
--޸ΪAddBrainPostInit
--ֲ̬
--񲻺
local function MakeBirdNotAfraid(brain)

	local SEE_THREAT_DIST = 5
	local inst = brain.bt.inst
	local function ShouldFlyAway(inst)
		local busy = inst.sg:HasStateTag("sleeping") or inst.sg:HasStateTag("busy") or inst.sg:HasStateTag("flying")
		if not busy then
			local x, y, z = inst.Transform:GetWorldPosition()
			local onflood = GetWorld().Flooding and GetWorld().Flooding:OnFlood(x, y, z)
			local threat = FindEntity(inst, 5, nil, nil, {"samansha",'notarget'}, {'player', 'monster', 'scarytoprey'})
			return threat ~= nil or onflood or GetClock():IsNight()
		end
	end

	for i,node in ipairs(brain.bt.root.children) do
		if node.name == "Sequence" and node.children[1].name ==	"Threat Near"  then
			node.children[1].fn = function() return ShouldFlyAway(inst) end
			break
		end
	end
	
end
AddBrainPostInit("birdbrain",MakeBirdNotAfraid)
--𼦲
--ͨƳscarytopreyɣΪΪӦƳñǩ
--󲻺
local function MakeKoalefantNotAfraid(brain,inst)

	local function ShouldRunAway(guy)
		return guy:HasTag("character") and not guy:HasTag("notarget") and not guy:HasTag("plant")
	end
	
	for i,node in ipairs(brain.bt.root.children) do
		if node.name == "Sequence" and node.children[2].name ==	"RunAway" then
			node.children[2].hunterparams = ShouldRunAway
			break
		end
	end
end
--AddBrainPostInit("koalefantbrain",MakeKoalefantNotAfraid)
---ӴеĶ
local FRAMES = GLOBAL.FRAMES
local EventHandler = GLOBAL.EventHandler
local TimeEvent = GLOBAL.TimeEvent
local ultimate_pre = {
        name = "ultimate_pre",
        onenter = function(inst)
			inst.components.locomotor:Stop()
            inst.AnimState:PlayAnimation("powerup")
			
        end,     
        events=
        {
			EventHandler("animover", function(inst) inst.sg:GoToState("ultimate_doing")	end),
        },
    }
local ultimate_doing = {
        name = "ultimate_doing",
        tags = {"busy","ultimate_doing"},
        onenter = function(inst)
            inst.AnimState:PlayAnimation("jump")
			inst.components.locomotor:Stop()
        end,
        onexit = function(inst)
            inst.sg:RemoveStateTag("ultimate_doing")
        end,
        events=
        {
			EventHandler("animover", function(inst)
				local self = inst.components.skiller
				local EleSkill = self:GetEleSkill("ultimate","plant")
				self:OnActivated(inst,EleSkill,"ultimate")
				inst.sg:GoToState("idle")
			end),
        },
    }	
AddStategraphState("wilson", GLOBAL.State(ultimate_pre))
AddStategraphState("wilson", GLOBAL.State(ultimate_doing))

--һЩ

local function GrowerPostInit(self)
	if self.PlantItem then
		local OldPlant = self.PlantItem
		self.PlantItem = function(self,item)
			if item.prefab == "lotus_seed"  and self.inst.prefab ~= "lotus_pond"then
				return false
			else
				return OldPlant(self,item)
			end
		end
	end
end
AddComponentPostInit("grower", GrowerPostInit)

--UI
--UI

local function AddSkill_CD_Indicator(self) 
	local RPG_State = require("widgets/RPG_State")
	if self.owner and self.owner:HasTag("samansha") then
		self.RPG_StateIndicator = self.bottom_root:AddChild(RPG_State(self.owner))	
		self.RPG_StateIndicator:SetPosition(120,70,0)
		self.RPG_StateIndicator:SetHAnchor(1)
		self.RPG_StateIndicator:SetVAnchor(2)		
		self.RPG_StateIndicator:MoveToFront()
		self.RPG_StateIndicator.scale = UI_SCALE
		self.RPG_StateIndicator:SetScale(self.RPG_StateIndicator.scale)
	end
	TheInput:AddKeyDownHandler(GLOBAL.KEY_MINUS, function()
		local inst = GetPlayer() 
		if inst and inst:HasTag("samansha") and not GLOBAL.IsPaused()then
			inst.HUD.controls.RPG_StateIndicator:Scale_DoDelta(-0.05)
		end
	end)
	TheInput:AddKeyDownHandler(GLOBAL.KEY_EQUALS, function()
		local inst = GetPlayer() 
		if inst and inst:HasTag("samansha") and not GLOBAL.IsPaused()then
			inst.HUD.controls.RPG_StateIndicator:Scale_DoDelta(0.05)
		end
	end)	
end

AddClassPostConstruct("widgets/controls", AddSkill_CD_Indicator)


--ָ
local function AddCoordinates(self)
	local coordinates = require "widgets/coordinates"
	self.coordinates = self:AddChild(coordinates())
	local pos_x =  -150
	local pos_y = 0
	self.coordinates:SetPosition(pos_x, pos_y, 0)
	self:SetScale(1,1,1)
end
--
if compass then
AddClassPostConstruct("widgets/uiclock", AddCoordinates)
end
--Buffʾ
local function AddBuffIndicator(self)
	local BuffBar = require("widgets/buffbar")
	if self.owner and self.owner:HasTag("samansha") then
		self.BuffBar = self.bottom_root:AddChild(BuffBar(self.owner))
		local pos = self.inv:GetPosition()
		self.BuffBar:SetPosition(pos.x,pos.y,pos.z)	
		self.BuffBar:MoveToFront()
	end
end
AddClassPostConstruct("widgets/controls", AddBuffIndicator)



--Ҷ1˶
AddIngredientValues({"lotus_leaf"}, {veggie=1}, true)

----β
table.insert(GLOBAL.CHARACTER_GENDERS.FEMALE, "samansha")
--ӵͼͼ
AddMinimapAtlas("images/map_icons/samansha.xml")
AddMinimapAtlas("images/map_icons/lotus_pond.xml")

AddModCharacter("samansha")



---ս

if DIFFICULTY > 1 then
	local function HardModeSkill(inst) 
		--ӱĴμBUFF
		local duration_blood_slaughter = 15
		local data_blood_slaughter = {damage = 0,killed = 0,layer = 0}
		local fntable_blood_slaughter = {
			BuffOccur = function(inst) 
				local self = inst.components.skiller
				inst:AddTag("blood_slaughter")  
				local buffdata = self:GetBuffData("blood_slaughter")
				if buffdata.damage and buffdata.killed and buffdata.layer then --ͼӱܳͷߣȻʧ
					local damage = math.max(buffdata.damage,buffdata.killed*100)*buffdata.layer/15*0.01*GLOBAL.GenerateNormal(2,1,0)
					inst.components.combat:GetAttacked(inst,damage)
				end
				buffdata = {
					damage = 0,
					killed = 0,
					layer = 0,
				}
				self:BuffData_DoDelta("blood_slaughter",buffdata)
				
			end,
			BuffOnHit = function(inst,data) 
				local self = inst.components.skiller
				local buffdata = self:GetBuffData("blood_slaughter")
				buffdata.damage = buffdata.damage + data.damage + 1*buffdata.layer
				self:BuffData_DoDelta("blood_slaughter",buffdata)
				if data.victim and data.victim.combat then --˺
					data.victim.combat:GetAttacked(inst,1*buffdata.layer)
				end
			end,
			BuffOnKilled = function(inst,data) 	
				local self = inst.components.skiller
				local duration = self:GetBuffDuration("blood_slaughter")
				self:SetBuffDurationTime(inst,"blood_slaughter",duration)
				local buffdata = self:GetBuffData("blood_slaughter")
				buffdata.layer =  math.min(buffdata.layer + 1,30)
				buffdata.killed = buffdata.killed +1
				local ultimate_lv = self:GetLevel("ultimate")
				if buffdata.layer >= 5 and inst:HasTag("ultimate_buff") and ultimate_lv>1 and not self:IsActivated("shock") then
					self:BuffActivated("shock",inst)
				end
				if buffdata.layer >= 10 and inst:HasTag("ultimate_buff") and ultimate_lv>1 and not self:IsActivated("vampire")then
					inst:BuffActivated("vampire",inst)
				end
				self:BuffData_DoDelta("blood_slaughter",buffdata)	
			end,
			BuffRemoved = function(inst)
				local self = inst.components.skiller
				local buffdata = self:GetBuffData("blood_slaughter")
				local damage = math.max(buffdata.damage,buffdata.killed*100)*buffdata.layer/15*0.1*GLOBAL.GenerateNormal(2,1,0) --˺
				inst.components.combat:GetAttacked(inst,damage)
				
				buffdata = {
					damage = 0,
					killed = 0,
					layer = 0,
				}
				self:BuffData_DoDelta("blood_slaughter",buffdata)
				inst:RemoveTag("blood_slaughter")  
				inst:RemoveTag("areahit")  
				inst:RemoveTag("vampire")  
				local blooddata = self:GetBuffData("lotus_bless")
				blooddata.blood = blooddata.blood +  damage
				self:BuffData_DoDelta("lotus_bless",blooddata)
			end,
		}
		local duration_blood_nemesis = 30
		local data_blood_nemesis = {layer = 0}
		local fntable_blood_nemesis = {
			BuffOccur = function(inst,inst,blood)
				inst:AddTag("blood_nemesis")
				local self = inst.components.skiller
				local layer = math.floor(blood/50) 
				local buffdata = self:GetBuffData("blood_nemesis")
				buffdata.layer = layer - 1
				self:BuffData_DoDelta("blood_nemesis",buffdata)
			end,
			BuffOnTick = function(inst,inst) 
				local self = inst.components.skiller	
				local buffdata = self:GetBuffData("blood_nemesis")
				inst.components.sanity:DoDelta(-buffdata.layer*0.1)
			end,
			BuffOnKilled = function(inst,data)
				local victim = data.victim
				if GLOBAL.SA_BLOOD_TABLE[victim.prefab] and GLOBAL.SA_BLOOD_TABLE[victim.prefab].default >=10 then
					local self = inst.components.skiller
					local duration = self:GetBuffDuration("blood_nemesis")
					self:SetBuffDurationTime(inst,"blood_nemesis",duration)	
					local buffdata = self:GetBuffData("blood_nemesis")
					buffdata.layer =  math.min(buffdata.layer + 1,30)
					self:BuffData_DoDelta("blood_nemesis",buffdata)				
				end
			end,
			BuffRemoved = function(inst) 
				local self = inst.components.skiller
				inst:RemoveTag("blood_nemesis") 
				local buffdata = {layer = 0}
				self:BuffData_DoDelta("blood_nemesis",buffdata)				
			end,
		}	
		inst.components.skiller:CreateBuff("blood_slaughter",duration_blood_slaughter,data_blood_slaughter,fntable_blood_slaughter)
		inst.components.skiller:CreateBuff("blood_nemesis",duration_blood_nemesis,data_blood_nemesis,fntable_blood_nemesis)
		inst.components.skiller:SetBuffTickTime("blood_nemesis",1)
		
		--޸ı
		local function onblood(inst,data)
			if data and data.victim and not data.victim:HasTag("structure") then	
				local victim = data.victim
				local buffdata = inst.components.skiller:GetBuffData("lotus_bless")
				local blood_cur =  buffdata.blood
				local delta_increase = SA_BLOOD_TABLE[victim.prefab] and SA_BLOOD_TABLE[victim.prefab].default or 0
				if not inst:HasTag("blood_slaughter") then
					inst.components.skiller:BuffActivated("blood_slaughter",inst)
					
				end
				if delta_increase >= 50 and not inst:HasTag("blood_nemesis") then
					inst.components.skiller:BuffActivated("blood_nemesis",inst,inst,delta_increase)
				end
				
				--Ѫծ
				local delta_decrease = 0
				local victim = data.victim
				delta_increase = delta_increase + GenerateNormal(1,1)
				--ɱǿѪծ
				if victim:HasTag("epic") and not victim:HasTag("tree")then
					if victim.prefab == "spiderqueen" or victim.prefab == "warg" then
						delta_decrease = delta_decrease + GenerateNormal(100,15)
					else
						delta_decrease = delta_decrease + GenerateNormal(400,30)
					end
				end
				--¾ǸѪծͱ¼
				local boss = GetValidBoss()
				local epic = GetValidEpic()
				local isdriving = inst.components.driver and inst.components.driver:GetIsDriving()
				local monster = nil
				if blood_cur > 300 and blood_cur <=500 and not isdriving then 
					if math.random()<0.1 +  (blood_cur-300) * 0.002 then
						monster = SpawnToInst(inst,epic[math.random(#epic)])
						delta_decrease = delta_decrease + GenerateNormal(50,25)
					end
				elseif blood_cur >500 and not isdriving then
					if math.random()<0.1 + (blood_cur-500) *0.001 then
						monster = SpawnToInst(inst,boss[math.random(#boss)])
						delta_decrease = delta_decrease + GenerateNormal(200,50)
					end
				end
				if monster then
					monster.components.combat:SetTarget(inst)
				end
				
				
				--
				local slaughter_layer = inst:HasTag("blood_slaughter") and inst.components.skiller:GetBuffData("blood_slaughter").layer or 0
				local nemesis_layer = inst:HasTag("blood_nemesis") and inst.components.skiller:GetBuffData("blood_nemesis").layer or 0
				--Ӱ
				local factor_slaughter = 1 + slaughter_layer*(slaughter_layer == 30 and 0.5 or slaughter_layer >=10 and 0.2 or 0.1)
				local factor_nemesis = 1 + nemesis_layer * 0.25
				buffdata.blood = math.max(blood_cur + delta_increase - delta_decrease,0)*factor_slaughter*factor_nemesis
				if victim.prefab == "krampus" and inst:HasTag("sackpawner") then --ݲÿ˹
					local chance = 0.001* buffdata.layer
					if math.random() < chance then
						buffdata.layer = math.max(buffdata.layer - 1000, 0)
						inst:RemoveTag("sackpawner")
						SpawnPrefab("poopcloud").Transform:SetPosition(inst:GetPosition():Get())
						SpawnPrefab("krampus_sack").Transform:SetPosition(inst:GetPosition():Get())
					end
				end		
				inst.components.skiller:BuffData_DoDelta("lotus_bless",buffdata)
			end
		end		
		local passivefntable = inst.components.skiller:GetBuffFn("lotus_bless")
		passivefntable.BuffOnKilled  = onblood
		if inst.components.skiller:IsActivated ("lotus_bless") then
			inst.components.skiller:BuffDeactivated("lotus_bless",inst)
			inst.components.skiller:BuffActivated("lotus_bless",inst)
		end
		--޸Ĵ
		local function flower_ultimate(inst,caster)
			inst:AddTag("ultimate_buff")
			local lv = inst.components.skiller:GetLevel("ultimate")
			local scale = 1.25 + (lv-1)*0.125
			inst.Transform:SetScale(scale,scale,scale)
			inst.buff_ultimate = SpawnPrefab("buff_ultimate")
			inst.buff_ultimate.entity:SetParent(inst.entity)
			inst.buff_ultimate.Transform:SetScale(1.5,1.5,1.5)
			inst.buff_ultimate.Transform:SetPosition(0, 0.5, 0)
			--
			if inst.components.hunger.AddBurnRateModifier then
				inst.components.hunger:AddBurnRateModifier("ultimate",0.5)
			else
				inst.components.hunger.hungerrate = inst.components.hunger.hungerrate*1.5
			end
			--ս
			local damagemodifier = 0.5+0.5*lv 
			if inst.components.combat.AddDamageModifier then
				inst.components.combat:AddDamageModifier("ultimate",damagemodifier)
			else
				inst.components.combat.damagemultiplier = damagemodifier+0.5
			end	
		end
		local ultimatefntable = inst.components.skiller:GetBuffFn("ultimate")
		ultimatefntable.BuffOccur  = flower_ultimate
	end
	AddPlayerPostInit(HardModeSkill)
	local function HardModeMonster(inst)
		local player = GetPlayer()
		local age_day = player.components.age:GetAge()/480
		if inst.components and not inst:HasTag("player") then
			if inst.components.health then
				inst.components.health:SetMaxHealth(inst.components.health.maxhealth*(1+age_day/20))
				if age_day/20>=1 then
					inst.components.health:StartRegen(age_day/20, age_day/20)
				end
			end
			if inst.components.combat then
			
			end
		end
	end
	--AddPrefabPostInitAny(HardModeMonster)
end


