require "behaviours/follow"
require "behaviours/faceentity"



require "behaviours/chaseandattack"
require "behaviours/runaway"
require "behaviours/wander"
require "behaviours/doaction"
require "behaviours/attackwall"
require "behaviours/panic"
require "behaviours/minperiod"

local MIN_FOLLOW_DIST = 2
local TARGET_FOLLOW_DIST = 5
local MAX_FOLLOW_DIST = 9

local STOP_RUN_DIST = 10
local SEE_PLAYER_DIST = 5
local WANDER_DIST_DAY = 20
local WANDER_DIST_NIGHT = 5
local MAX_CHASE_TIME = 6
local MAX_CHASE_DIST = 30
local RUN_AWAY_DIST = 8
local STOP_RUN_AWAY_DIST = 12
local START_FACE_DIST = 10
local KEEP_FACE_DIST = 14
local TRADE_DIST = 20

local function GetLeader(inst)
    return inst.components.follower.leader 
end

local function GetFaceTargetFn(inst)
    return inst.components.follower.leader
end

local function KeepFaceTargetFn(inst, target)
    return inst:IsNear(target, KEEP_FACE_DIST) and not target:HasTag("notarget")
end
local function GetTraderFn(inst)
    return FindEntity(inst, TRADE_DIST, function(target) return inst.components.trader:IsTryingToTradeWithMe(target) end, {"player"})
end
local function KeepTraderFn(inst, target)
    return inst.components.trader:IsTryingToTradeWithMe(target)
end


local DeerBrain = Class(Brain, function(self, inst)
    Brain._ctor(self, inst)
end)

function DeerBrain:OnStart()
    local root =
    PriorityNode(
    {
		WhileNode( function() return GetLeader(self.inst) ~= nil and ( self.inst.components.combat.target == nil or not self.inst.components.combat:InCooldown()) end, "AttackMomentarily",
			ChaseAndAttack(self.inst, MAX_CHASE_TIME, MAX_CHASE_DIST)),    
		WhileNode( function() return  self.inst.components.combat:InCooldown() end, "Dodge",
			RunAway(self.inst, function() return self.inst.components.combat.target end, 8, 12) ),
		RunAway(self.inst, function() return self.inst.components.combat.target end, 10, 15),
		
		FaceEntity(self.inst, GetTraderFn, KeepTraderFn),
		Follow(self.inst, GetLeader, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST),--typical follower behaviour
		IfNode(function() return GetLeader(self.inst) end, "has leader",--if we stand around and have a leader
			FaceEntity(self.inst, GetFaceTargetFn, KeepFaceTargetFn )), --stare at him creepily	 
	},.5)

    self.bt = BT(self.inst, root)
end

function DeerBrain:OnInitializationComplete()
    self.inst.components.knownlocations:RememberLocation("spawnpoint", self.inst:GetPosition())
end

return DeerBrain
