require "prefabutil"

local function CheckBlood(inst,data)
	if not inst:HasTag("burnt") then
		if data and data.NewData then
			local blood = NewData.blood
			local high_blood = 1000
			local low_blood = 0
			blood = math.min( math.max(low_blood, blood), high_blood)
			local percent = (blood + low_blood) / (high_blood - low_blood)
			inst.AnimState:SetPercent("meter", 1-percent)
		else
			local player = GetPlayer()
			local blood = player.components.skiller:GetBuffData("lotus_bless").blood
			local high_blood = 1000
			local low_blood = 0
			blood = math.min( math.max(low_blood, blood), high_blood)
			local percent = (blood + low_blood) / (high_blood - low_blood)
			inst.AnimState:SetPercent("meter", 1-percent)
		end
	end
end

local function onhammered(inst, worker)
	if inst:HasTag("fire") and inst.components.burnable then
		inst.components.burnable:Extinguish()
	end
	inst.components.lootdropper:DropLoot()
	SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
	inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")
	inst:Remove()
end

local function onhit(inst, worker)
	if not inst:HasTag("burnt") then
		inst.AnimState:PlayAnimation("hit")
		--the global animover handler will restart the check task
	end
end

local function onbuilt(inst)
	inst.AnimState:PlayAnimation("place")
	--the global animover handler will restart the check task
end

local assets = 
{
	Asset("ANIM", "anim/winter_meter.zip"),
}

local prefabs =
{
	"collapse_small",
}


local function getstatus(inst,player)
	local blood = player.components.skiller:GetBuffData("lotus_bless").blood
	local high_blood = 1000
	local low_blood = 0
	blood = math.min( math.max(low_blood, blood), high_blood)
	local percent = (blood + low_blood) / (high_blood - low_blood)
	if percent < 0.25 then
		return "one"
	elseif percent < 0.5 then
		return "two"
	elseif percent < 0.75 then
		return "three"
	elseif percent < 1 then
		return "four"
	elseif percent >= 1 then
		return "over"
	end
end

local function onsave(inst, data)
	if inst:HasTag("burnt") or inst:HasTag("fire") then
        data.burnt = true
    end
end

local function onload(inst, data)
	if data and data.burnt then
        inst.components.burnable.onburnt(inst)
    end
end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	
	local minimap = inst.entity:AddMiniMapEntity()
	minimap:SetIcon( "winterometer.png" )
    
	MakeObstaclePhysics(inst, .4)
    
	anim:SetBank("winter_meter")
	anim:SetBuild("winter_meter")
	anim:SetPercent("meter", 0)

	inst:AddComponent("inspectable")
	inst.components.inspectable.getstatus = getstatus
	
	inst:AddComponent("lootdropper")
	inst:AddComponent("workable")
	inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
	inst.components.workable:SetWorkLeft(4)
	inst.components.workable:SetOnFinishCallback(onhammered)
	inst.components.workable:SetOnWorkCallback(onhit)		
	MakeSnowCovered(inst, .01)
	
	CheckBlood(inst)

	inst:ListenForEvent("onbuilt", onbuilt)
	inst:ListenForEvent("animover",function(player,data) CheckBlood(inst,data) end,GetPlayer())

	inst:AddTag("structure")
	
	MakeSmallBurnable(inst, nil, nil, true)
	MakeSmallPropagator(inst)
	
	inst.OnSave = onsave
	inst.OnLoad = onload
	return inst
end
return Prefab( "common/objects/bloodometer", fn, assets, prefabs),
	   MakePlacer("common/bloodometer_placer", "winter_meter", "winter_meter", "idle" ) 


