require "stategraphs/SGdeer"
local brain = require("brains/deerbrain")

local assets =
{
	Asset("ANIM","anim/deer_build.zip"),
	Asset("ANIM","anim/deer_ice_build.zip"),
    Asset("ANIM", "anim/lightning_goat_actions.zip"),
    Asset("ANIM", "anim/lightning_goat_basic.zip"),
--    Asset("SOUND", "sound/deer.fsb"),
}

local prefabs =
{
    "deerhorn",
}

SetSharedLootTable( 'deer',
{
    {'deerhorn',1},
	{'meat',3},
})

--е
local function disarm(inst,victim)
	local lootchance = { generic = 0.1, imprison = 0.5} 
	if victim and victim.components and victim.components.lootdropper and victim.components.health and not victim.components.health:IsDead() then
		local chance = math.random()
		if  chance < lootchance.generic or (chance < lootchance.imprison and victim:HasTag("imprison")) or victim:HasTag("dizzy") then
			local self = victim.components.lootdropper		
			local loots = self:GenerateLoot()
			if #loots >=1 then
				local item = loots[math.random(1,#loots)]
				local pt = Vector3(victim.Transform:GetWorldPosition())
				self:SpawnLootPrefab(item,pt)
			end
		end
	end
end
--ɴ¹
local function SetSpring(inst)
	inst.deerstate ="spring"
	inst.AnimState:SetBuild("deer_build")
	--ӽе
	inst.components.combat.onhitotherfn = disarm
end
--ͱɶ¹
local function FrostAttack(inst,victim)
	if victim.components.freezable then
		victim.components.freezable:AddColdness(math.random()*3)
	end
end
local function SetWinter(inst)
	inst.deerstate ="winter"
	inst.AnimState:SetBuild("deer_ice_build")
	inst.components.combat.onhitotherfn = FrostAttack
end

--ǷƷ
local function ShouldAcceptItem(inst, item)
	if not inst:HasTag("trial") then
		if item:HasTag("lotus_item") then
			return true
		elseif item.prefab == "bluegem" and inst.deerstate =="spring" or item.prefab == "redgem" and inst.deerstate =="winter"then
			return true
		else
			return false
		end
	elseif inst:HasTag("trial") then
		return false
	end
end
--ȡƷ֮
local function OnGetItemFromPlayer(inst, giver, item)
	if item.prefab == "bluegem" then
		SetWinter(inst) 
	end
	if item.prefab == "redgem" then
		SetSpring(inst)
	end	
	if item:HasTag("lotus_item") then
		inst.components.health:DoDelta(50)
		if inst.components.follower.leader == nil and inst:HasTag("wild") then
			inst.components.follower:SetLeader(giver)
			inst.components.talker:Say(STRINGS.DEER.FOLLOW.FIRSTTIME)
			inst:RemoveTag("wild")
		end
		inst.mood = inst.mood + GenerateNormal(1,1)
		if math.random() < inst.mood*0.001 then
			SpawnPrefab("deerhorn").Transform:SetPosition(inst:GetPosition():Get())
			inst.mood = 0
		end
	end
end
---ܾƷ
local function OnRefuseItem(inst,item)
	if inst:HasTag("trial") then
		inst.components.talker:Say(STRINGS.DEER.REFUSEITEM.TRIAL)
	else
		if math.random() <0.01 then
			inst.components.talker:Say(STRINGS.DEER.REFUSEITEM.ANGRY)
			inst.components.follower:StopFollowing()
			inst:AddTag("wild")
		else
			inst.components.talker:Say(STRINGS.DEER.REFUSEITEM.NORMAL)
		end
	end
end


--ʱ
local function OnAttacked(inst, data)	
    local attacker = data and data.attacker
	if not attacker:HasTag("player") then
		inst.components.combat:SetTarget(attacker)
	end
end
--յʱ
local function OnStartFollow(inst,data)
	local amount = 100/TUNING.TOTAL_DAY_TIME
	inst.components.health:StartRegen(amount, 1)
	inst.components.talker:Say(STRINGS.DEER.FOLLOW.FOLLOW)
	
end
local function OnStopFollow(inst,data)
	local amount = 500/TUNING.TOTAL_DAY_TIME
	inst.components.health:StartRegen(amount, 1)
	inst.components.talker:Say(STRINGS.DEER.FOLLOW.STAY)	
	inst.components.locomotor:StopMoving()
end

local function OnSave(inst, data)
	if inst.deerstate then
		data.deerstate = inst.deerstate
	end
	if inst:HasTag("wild") then
		data.wild = true
	end
	if inst.mood then
		data.mood = inst.mood
	end
end
        
local function OnLoad(inst, data)
	local amount = 500/TUNING.TOTAL_DAY_TIME
	if data and data.deerstate then
		if  data.deerstate =="winter" then
			SetWinter(inst)
		elseif  data.deerstate =="spring" then
			SetSpring(inst)
		end
		if not data.wild then
			inst:RemoveTag("wild")
		end
		if data.mood then
			inst.mood = data.mood
		end
	end
	if inst.components.follower.leader then
		amount = amount/5
	end
	inst.components.health:StartRegen(amount, 1)
end


local function fn()
    local inst = CreateEntity()
	inst.entity:AddTransform()
    inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()--
	inst.entity:AddDynamicShadow()--Ӱ

    local minimap = inst.entity:AddMiniMapEntity()
	
	inst.DynamicShadow:SetSize(1.75,.75)	--趨ӰӴС
    inst.Transform:SetFourFaced()
	if IsDLCEnabled(CAPY_DLC) then--SW趨Ϊˮ·ܵ
		MakeAmphibiousCharacterPhysics(inst, 100, 1)
	else
		MakeCharacterPhysics(inst, 100, 1)
		inst.Physics:SetCollisionGroup(COLLISION.CHARACTERS)
		inst.Physics:ClearCollisionMask()
		inst.Physics:CollidesWith(COLLISION.WORLD)
		inst.Physics:CollidesWith(COLLISION.OBSTACLES)
		inst.Physics:CollidesWith(COLLISION.CHARACTERS)
	end	
    inst.AnimState:SetBank("lightning_goat")
    inst.AnimState:SetBuild("deer_build")
    
    ------------------------------------------
	--Ӷtag
	inst:AddTag("samansha_deer")
	inst:AddTag("wild")--жǷһθ
    ------------------------------------------
	--׷
	inst:AddComponent("follower")
	
	--趨ֵ
    inst:AddComponent("health")
    inst.components.health:SetMaxHealth(500)
	inst.components.health:SetAbsorptionAmount(0.5)
	
    ------------------
	--ս趨Ӧֵ
    inst:AddComponent("combat")
    inst.components.combat:SetDefaultDamage(50)
    inst.components.combat:SetRange(3)
    inst.components.combat:SetAttackPeriod(3)
	
	--趨ƶٶ
    inst:AddComponent("locomotor")
    inst.components.locomotor.walkspeed = TUNING.LIGHTNING_GOAT_WALK_SPEED
    inst.components.locomotor.runspeed = TUNING.LIGHTNING_GOAT_RUN_SPEED	
	---------------------------------------------------------
    inst:AddComponent("lootdropper")
    inst.components.lootdropper:SetChanceLootTable('deer') 
    ------------------------------------------
    inst:AddComponent("inspectable")
    ------------------------------------------
    ------------------------------------------	
    ------------------------------------------
    MakeMediumBurnableCharacter(inst, "lightning_goat_body")
	MakeHugeFreezableCharacter(inst, "lightning_goat_body")--趨ͬ
	
	inst:ListenForEvent("attacked", OnAttacked)
	inst:ListenForEvent("startfollowing", OnStartFollow )
	inst:ListenForEvent("stopfollowing", OnStopFollow )
	inst:ListenForEvent("seasonChange", function(it, data)
        if data.season == SEASONS.WINTER then
			SetWinter(inst)
        else 
            SetSpring(inst)
        end
    end, GetWorld())    
    ------------------------------------------
	
	--趨״̬ͼAI
    inst:SetStateGraph("SGdeer")
	inst:SetBrain(brain)
	inst.sg:GoToState("rebirth")

	--ӽԱ
	inst:AddComponent("trader")
    inst.components.trader:SetAcceptTest(ShouldAcceptItem)
    inst.components.trader.onaccept = OnGetItemFromPlayer
    inst.components.trader.onrefuse = OnRefuseItem
	inst.components.trader.deleteitemonaccept = true
	
	inst:AddComponent("knownlocations")

	SetSpring(inst)
	--һֻԵ¹
	inst:AddComponent("talker")
	inst.mood = 0 --ֵ
	inst.OnSave = OnSave
    inst.OnLoad = OnLoad--ѪҲдˡ
	----
	
    return inst
end

return Prefab( "common/monsters/deer", fn, assets, prefabs) 