assets =
{
	Asset("ANIM", "anim/hat_deer.zip"),
	Asset("IMAGE", "images/inventoryimages/deerhat.tex"),
	Asset("ATLAS", "images/inventoryimages/deerhat.xml")
}
prefabs = 
{
}

local function onequip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_hat", "hat_deer", "swap_hat")
	owner.AnimState:Show("HAT")
	owner.AnimState:Show("HAT_HAIR")
	owner.AnimState:Hide("HAIR_NOHAT")
	owner.AnimState:Hide("HAIR")
end

local function onunequip(inst, owner)
	owner.AnimState:Hide("HAT")
	owner.AnimState:Hide("HAT_HAIR")
	owner.AnimState:Show("HAIR_NOHAT")
	owner.AnimState:Show("HAIR")
end


local function onfinished(inst)
	inst:Remove()
end
	
local function fn()
	local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
	


	
    inst.AnimState:SetBank("hat_deer")
    inst.AnimState:SetBuild("hat_deer")
    inst.AnimState:PlayAnimation("anim")

    inst:AddTag("hat")

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/deerhat.xml"
	

    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
	inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )

	inst:AddComponent("insulator")
	inst.components.insulator:SetInsulation( TUNING.INSULATION_LARGE )

	inst:AddComponent("armor")
	inst.components.armor:InitCondition(750, TUNING.ARMOR_FOOTBALLHAT_ABSORPTION)	
	
	inst:AddComponent("waterproofer")
	inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_SMALL)	
	return inst
end
	
	
return Prefab( "common/inventory/deerhat", fn, assets, prefabs)