local assets=
{
	Asset("ANIM", "anim/deerheart.zip"),
	Asset("IMAGE", "images/inventoryimages/deerheart.tex"),
	Asset("ATLAS", "images/inventoryimages/deerheart.xml")
}
local function getstatus(inst,player)
	local layer = player.components.skiller:GetBuffData("lotus_bless").layer
	local percent = layer/1000
	if percent < 0.25 then
		return "one"
	elseif percent < 0.5 then
		return "two"
	elseif percent < 0.75 then
		return "three"
	elseif percent < 1 then
		return "four"
	elseif percent >= 1 then
		return "five"
	end	
end


local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	

	inst:AddTag("RespawnDeer")
	
    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("deerheart")
    inst.AnimState:SetBuild("deerheart")
    inst.AnimState:PlayAnimation("idle")
	
    inst:AddComponent("inspectable")
	inst.components.inspectable.getstatus = getstatus
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/deerheart.xml"

	return inst
end

return Prefab( "common/inventory/deerheart", fn, assets) 
