local assets=
{
	Asset("ANIM", "anim/deerhorn.zip"),
	Asset("IMAGE", "images/inventoryimages/deerhorn.tex"),
	Asset("ATLAS", "images/inventoryimages/deerhorn.xml")
}

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	

	
    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("deerhorn")
    inst.AnimState:SetBuild("deerhorn")
    inst.AnimState:PlayAnimation("idle")
    
    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM    
    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/deerhorn.xml"
    
	
	
	return inst
end

return Prefab( "common/inventory/deerhorn", fn, assets) 
