assets =
{
	Asset("ANIM", "anim/hat_eyeshade.zip"),
	Asset("IMAGE", "images/inventoryimages/hat_eyeshade.tex"),
	Asset("ATLAS", "images/inventoryimages/hat_eyeshade.xml"),
	
}
prefabs = 
{
}
local function OnPhraseChange(inst)
	GetWorld().components.colourcubemanager:SetOverrideColourCube(nil, .5)
	if GetClock():IsDay() and not GetWorld():IsCave() then
		GetWorld().components.colourcubemanager:SetOverrideColourCube("images/colour_cubes/mole_vision_off_cc.tex", .25)
	else -- Dusk and Night
		GetWorld().components.colourcubemanager:SetOverrideColourCube("images/colour_cubes/mole_vision_on_cc.tex", .25)
	end
end


local function onequip(inst, owner)
	if owner ~= GetPlayer() then return end
	owner.SoundEmitter:PlaySound("dontstarve_DLC001/common/moggles_on")
	if GetClock() and GetWorld() and GetWorld().components.colourcubemanager then
		GetClock():SetNightVision(true)
		if GetClock():IsDay() and not GetWorld():IsCave() then
			GetWorld().components.colourcubemanager:SetOverrideColourCube("images/colour_cubes/mole_vision_off_cc.tex", .25)
		else -- Dusk and Night
			GetWorld().components.colourcubemanager:SetOverrideColourCube("images/colour_cubes/mole_vision_on_cc.tex", .25)
		end
	end

	inst:ListenForEvent( "daytime", OnPhraseChange, GetWorld())
	
	owner.AnimState:OverrideSymbol("swap_hat", "hat_eyeshade", "swap_hat")
	owner.AnimState:Show("HAT")
	owner.AnimState:Hide("HAT_HAIR")
	owner.AnimState:Show("HAIR_NOHAT")
	owner.AnimState:Show("HAIR")
	
	if inst.components.fueled then
		inst.components.fueled:StartConsuming()        
	end
end

local function onunequip(inst, owner)
	if owner ~= GetPlayer() then return end
	owner.SoundEmitter:PlaySound("dontstarve_DLC001/common/moggles_off")
	if GetClock() then
		GetClock():SetNightVision(false)
	end
	if GetWorld() and GetWorld().components.colourcubemanager then
		GetWorld().components.colourcubemanager:SetOverrideColourCube(nil, .5)
	end
	inst:RemoveEventCallback( "daytime", OnPhraseChange, GetWorld())
	
	owner.AnimState:Hide("HAT")
	owner.AnimState:Hide("HAT_HAIR")
	owner.AnimState:Show("HAIR_NOHAT")
	owner.AnimState:Show("HAIR")
	if inst.components.fueled then
		inst.components.fueled:StopConsuming()        
	end

	
	
end


local function isplant(inst,data)
	if data and data.owner  then
		local owner = data.owner
		local slot = inst.components.equippable.equipslot
		if not owner:HasTag("samansha") or owner:HasTag("flower") then
			inst:DoTaskInTime(0,function ()
			local bufferedaction = BufferedAction(owner, nil, ACTIONS.UNEQUIP, inst)
			owner:PushBufferedAction(bufferedaction)
			owner.components.talker:Say(STRINGS.SAMANSHA.WARNING.HATEYESHADE)
			end)
		end
	end
end



local function fn()
	local inst = CreateEntity()
---基本代码
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
	
 
	
    inst.AnimState:SetBank("earmuffshat")
    inst.AnimState:SetBuild("hat_eyeshade")
    inst.AnimState:PlayAnimation("anim")

	--可检查和可放入物品栏
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/hat_eyeshade.xml"
	
	--可装备
	inst:AddComponent("equippable")
	inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
	inst.components.equippable:SetOnEquip(onequip)
	inst.components.equippable:SetOnUnequip(onunequip)
	--耐久度
	inst:AddComponent("fueled")
	inst.components.fueled.fueltype = "USAGE"
	inst.components.fueled:InitializeFuelLevel(TUNING.EARMUFF_PERISHTIME)
	inst.components.fueled:SetDepletedFn(inst.Remove)
	--夜视
	inst:AddTag("nightvision")
	--监测是否是第一状态，不是则卸下物品。
	inst:ListenForEvent("equipped",isplant)
	return inst
end
	
	
return Prefab( "common/inventory/hat_eyeshade", fn, assets, prefabs)