local assets =
{
	Asset("ANIM", "anim/lotus.zip"),
}

require "prefabs/veggies"
   
local prefabs = {}

local function onmatured(inst)
	inst.SoundEmitter:PlaySound("dontstarve/common/farm_harvestable")
end
local function onburnt(inst)
    local temp = SpawnPrefab(inst.components.crop.product_prefab)
    local product = nil
    if temp.components.cookable and temp.components.cookable.product then
        product = SpawnPrefab(temp.components.cookable.product)
    else
        product = SpawnPrefab("seeds_cooked")
    end
    temp:Remove()

    if inst.components.stackable and product.components.stackle then
        product.components.stackable.stacksize = inst.components.stackable.stacksize
    end

    if inst.components.crop and inst.components.crop.grower and inst.components.crop.grower.components.grower then
        inst.components.crop.grower.components.grower:RemoveCrop(inst)
    end

    product.Transform:SetPosition(inst.Transform:GetWorldPosition())
    inst:Remove()
end 
local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	local sound = inst.entity:AddSoundEmitter()

	
    anim:SetBank("lotus")
    anim:SetBuild("lotus")
    anim:PlayAnimation("grow")
	
    inst:AddComponent("crop")
    inst.components.crop:SetOnMatureFn(onmatured)
    local OldHarvest = inst.components.crop.Harvest
	local NewHarvest = function (self,harvester)
		if self.matured or self.withered then
			OldHarvest(self,harvester)
			if harvester.components.skiller then
				local lv = harvester.components.skiller:GetLevel("passive")
				harvester.components.inventory:GiveItem(SpawnPrefab("lotus_seed"))
				local extrachance = 0.5
				local seedchance = 0.1
				local leafchance = 0.05
				if math.random() <  extrachance then
					harvester.components.inventory:GiveItem(SpawnPrefab("lotus_seed"))
				end				
				for k=1,lv do
					if math.random() < seedchance then
						harvester.components.inventory:GiveItem(SpawnPrefab("lotus_seed"))
					end
					if math.random() < leafchance then
						harvester.components.inventory:GiveItem(SpawnPrefab("lotus_leaf"))
					end					
				end
			end
			return true
		end
	end
	inst.components.crop.Harvest = NewHarvest
    inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        if inst.components.crop:IsReadyForHarvest() then
            return "READY"
        else
            return "GROWING"
        end
    end
	
    MakeSmallBurnable(inst)
    MakeSmallPropagator(inst)
    inst.components.burnable:SetOnBurntFn(onburnt)
    inst.components.burnable:MakeDragonflyBait(1)    
	
	
    anim:SetFinalOffset(-1)
    
    return inst
end

return Prefab( "common/objects/lotus", fn, assets, prefabs) 
