assets =
{
	Asset("ANIM", "anim/lotus_leaf.zip"),
	Asset("IMAGE", "images/inventoryimages/lotus_leaf.tex"),
	Asset("ATLAS", "images/inventoryimages/lotus_leaf.xml")
}
prefabs = 
{
}


local function fn()
	local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
	

	
    inst.AnimState:SetBank("lotus_leaf")
    inst.AnimState:SetBuild("lotus_leaf")
    inst.AnimState:PlayAnimation("idle")
	
	inst:AddComponent("inspectable")

    inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
	
	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/lotus_leaf.xml"
	
	inst:AddComponent("tradable")
	inst:AddTag("lotus_item")
	
	inst:AddComponent("edible")
	inst.components.edible.healthvalue = TUNING.HEALING_TINY
	inst.components.edible.hungervalue = TUNING.CALORIES_SMALL
	inst.components.edible.sanityvalue = 0
	inst.components.edible.foodtype = "VEGGIE"
	
	inst:AddComponent("perishable")
	inst.components.perishable:SetPerishTime(TUNING.PERISH_MED)
	inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "spoiled_food"
	
	return inst
end


return Prefab( "common/inventory/lotus_leaf", fn, assets, prefabs)