local assets =
{
	Asset("ANIM", "anim/lotus_pond.zip"),
	Asset("MINIMAP_IMAGE", "lotus_pond"),
}



local function onhammered(inst, worker)
	if inst:HasTag("fire") and inst.components.burnable then
		inst.components.burnable:Extinguish()
	end
	if inst.components.grower then inst.components.grower:Reset() end
	inst.components.lootdropper:DropLoot()
	SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
	inst:Remove()
	inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")
end

local function lotus_grow(self,item)
	if item.prefab ~= "lotus_seed" then
		return false
	end
    if not item.components.plantable or item.components.plantable.minlevel > self.level then
        return false
    end
    self:Reset()
    local prefab = nil
    if item.components.plantable.product and type(item.components.plantable.product) == "function" then
		prefab = item.components.plantable.product(item)
    else
		prefab = item.components.plantable.product or item.prefab
	end
	for k,v in ipairs(self.croppoints) do
		local plant1 = SpawnPrefab("lotus")
		plant1.persists = false
		
		self.inst:AddTag("NOCLICK")
	    
		plant1.components.crop:StartGrowing(prefab, item.components.plantable.growtime*self.growrate, self.inst)
		local pos = Vector3(self.inst.Transform:GetWorldPosition()) + v
		plant1.Transform:SetPosition(pos:Get())
		self.crops[plant1] = true
	end
    
    self.isempty = false
    
    if self.onplantfn then
		self.onplantfn(item)
    end
	item:Remove()
	
	self.inst.AnimState:PlayAnimation( "grow",true )
    return true
end
local function getstatus(inst)
	if not inst.components.grower:IsFertile() then
		return "NEEDSFERTILIZER"
	elseif not inst.components.grower:IsEmpty() then
		return "GROWING"
	end
end
local function fn(Sim)
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()

	inst.AnimState:SetBank("lotus_pond")
	inst.AnimState:SetBuild("lotus_pond")
	inst.AnimState:PlayAnimation( "idle",true )
	inst.AnimState:SetOrientation(ANIM_ORIENTATION.OnGround)
    inst.AnimState:SetLayer(LAYER_BACKGROUND)
    inst.AnimState:SetSortOrder(3)
	
--Сͼͼ
	local minimap = inst.entity:AddMiniMapEntity()
	minimap:SetIcon( "lotus_pond.tex" )

	inst:AddComponent("inspectable")
	inst.components.inspectable.getstatus = getstatus

	inst:AddComponent("grower")
	inst.components.grower.onplantfn = function() inst.SoundEmitter:PlaySound("dontstarve/wilson/plant_seeds") end
	inst.components.grower.croppoints = { Vector3(0, 0, 0) }
	inst.components.grower.growrate = TUNING.FARM3_GROW_BONUS

	inst.components.grower.max_cycles_left = 30
	inst.components.grower.cycles_left = inst.components.grower.max_cycles_left
	inst.components.grower.PlantItem  = lotus_grow
	local OldOnLoad = inst.components.grower.OnLoad
	local NewOnLoad = function(self,data, newents)		
		OldOnLoad(self,data, newents)
		if not self:IsEmpty() then
			self.inst.AnimState:PlayAnimation( "grow",true )
		end
	end
	inst.components.grower.OnLoad = NewOnLoad
	
	local OldRemoveCrop = inst.components.grower.RemoveCrop
	local NewRemoveCrop = function(self,crop)
		OldRemoveCrop(self,crop)
		self.inst.AnimState:PlayAnimation( "idle",true )
	end
	inst.components.grower.RemoveCrop = NewRemoveCrop
	
	
	inst:AddComponent("lootdropper")
	inst:AddComponent("workable")
	inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
	inst.components.workable:SetWorkLeft(4)
	inst.components.workable:SetOnFinishCallback(onhammered)
	return inst
end    

return Prefab( "common/objects/lotus_pond",  fn, assets),
		MakePlacer( "common/lotus_pond_placer", "lotus_pond", "lotus_pond", "idle" ,true) 