assets =
{
	Asset("ANIM", "anim/lotus_seed.zip"),
	Asset("IMAGE", "images/inventoryimages/lotus_seed.tex"),
	Asset("ATLAS", "images/inventoryimages/lotus_seed.xml")
}
prefabs = 
{
}

local function fn()
	local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
	
 
	
    inst.AnimState:SetBank("lotus_seed")
    inst.AnimState:SetBuild("lotus_seed")
    inst.AnimState:PlayAnimation("idle")
	
	inst:AddComponent("inspectable")
	
    inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    inst:AddComponent("edible")
    inst.components.edible.foodtype = "SEEDS"
    inst.components.edible.healthvalue = 0
    inst.components.edible.hungervalue = TUNING.CALORIES_TINY/2
    
	inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime(TUNING.PERISH_SUPERSLOW)
    inst.components.perishable:StartPerishing()
    inst.components.perishable.onperishreplacement = "spoiled_food"
	
	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/lotus_seed.xml"

    inst:AddComponent("plantable")
    inst.components.plantable.growtime = TUNING.SEEDS_GROW_TIME
    inst.components.plantable.product = "lotus_leaf"
	
	inst:AddComponent("tradable")
	inst:AddTag("lotus_item")
	return inst
end


return Prefab( "common/inventory/lotus_seed", fn, assets, prefabs)