local assets=
{
	Asset("ANIM", "anim/lotus_umbrella.zip"),
	Asset("ANIM", "anim/swap_lotus_umbrella.zip"),
	Asset("IMAGE", "images/inventoryimages/lotus_umbrella.tex"),
	Asset("ATLAS", "images/inventoryimages/lotus_umbrella.xml"),	
}
local function UpdateSound(inst)
    local soundShouldPlay = GetSeasonManager():IsRaining() and inst.components.equippable:IsEquipped()
    if soundShouldPlay ~= inst.SoundEmitter:PlayingSound("umbrellarainsound") then
        if soundShouldPlay then
		    inst.SoundEmitter:PlaySound("dontstarve/rain/rain_on_umbrella", "umbrellarainsound") 
        else
		    inst.SoundEmitter:KillSound("umbrellarainsound")
		end
    end
end  
--装备/卸下   
--缴械技能
local function onequip(inst, owner) 
	--owner.AnimState:AddOverrideBuild("magicfile")
    owner.AnimState:OverrideSymbol("swap_object", "swap_lotus_umbrella", "swap_lotus_umbrella")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")

    UpdateSound(inst)
    owner.DynamicShadow:SetSize(1.7, 1)
	local x0,y0,z0 = inst.Transform:GetWorldPosition()
	local x1,y1,z1 = owner.AnimState:GetSymbolPosition("swap_object", 0, 0, 0)
	local x2,y2,z2 = owner.Transform:GetWorldPosition()
	local x3,y3,z3 = x1-x2 ,y1-y2,z1-z2
	inst.buff_ultimate = SpawnPrefab("buff_ultimate")
	inst.buff_ultimate.entity:SetParent(inst.entity)
	inst.buff_ultimate.Transform:SetScale(1,1,1)	
	inst.buff_ultimate.Transform:SetPosition(0,0,0)
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
    UpdateSound(inst)
    owner.DynamicShadow:SetSize(1.3, 0.6)
end

--雨伞损坏时触发，对人物有一点影响。
local function onperish(inst)
    if inst.components.inventoryitem and inst.components.inventoryitem:IsHeld() then
        local owner = inst.components.inventoryitem.owner
        inst:Remove()
        if owner then
            owner:PushEvent("umbrellaranout")
        end
    else
        inst:Remove()
    end
end
  
local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()    
    MakeInventoryPhysics(inst)
 	

	
    inst.AnimState:SetBank("lotus_umbrella")
    inst.AnimState:SetBuild("lotus_umbrella")
    inst.AnimState:PlayAnimation("idle")      

	inst:AddTag("nopunch")
    inst:AddTag("umbrella")
    inst:AddTag("waterproofer")

    
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/lotus_umbrella.xml"
	
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    inst.components.equippable.dapperness = TUNING.DAPPERNESS_MED
	--防雨
	inst:AddComponent("waterproofer")
	inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_HUGE)
	--遮阳
	inst:AddComponent("insulator")
    inst.components.insulator:SetSummer()
	inst.components.insulator:SetInsulation(TUNING.INSULATION_MED)

	--自动掉耐久	
    inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime(TUNING.PERISH_MED)
    inst.components.perishable:StartPerishing()
    inst.components.perishable:SetOnPerishFn(onperish)
    inst:AddTag("show_spoilage")
	
    
    return inst
end



return Prefab( "common/inventory/lotus_umbrella", fn, assets) 

