local MakePlayerCharacter = require "prefabs/player_common"
local DAY = TUNING.TOTAL_DAY_TIME

local assets = {
	Asset( "ANIM", "anim/samansha.zip" ),
	Asset( "ANIM", "anim/samansha_flower.zip" ),
	Asset("SCRIPT", "scripts/prefabs/player_common.lua"),
	Asset("ANIM", "anim/player_wolfgang.zip"),
	Asset( "ANIM", "anim/file_imprison.zip" ),
}
local prefabs = {

}
local start_inv = {
	"lotus_seed",
	"lotus_seed",
	"lotus_seed",
	"lotus_seed",
	"deerhorn",
}

local function sanityfn(inst)
    local x, y, z = inst.Transform:GetWorldPosition() 
    local delta = 0
    local max_rad = 10
    local ents = TheSim:FindEntities(x, y, z, max_rad,nil,nil, {"tree","bird"})
    for i, v in ipairs(ents) do
		if v:HasTag("tree") and v:HasTag("fire")then --burning trees make her sad
			if v.components.burnable ~= nil and v.components.burnable:IsBurning() then
				local rad = v.components.burnable:GetLargestLightRadius() or 1
				local sz = TUNING.SANITYAURA_TINY * math.min(max_rad, rad) / max_rad
				local distsq = inst:GetDistanceSqToInst(v) - 9
				-- shift the value so that a distance of 3 is the minimum
				delta = delta - sz / math.max(1, distsq)
			end
		end	
		if v:HasTag("bird") then -- birds make her happy
			local sz = TUNING.DAPPERNESS_TINY
			local distsq = inst:GetDistanceSqToInst(v) - 9
			-- shift the value so that a distance of 3 is the minimum
			delta = delta + sz / math.max(1, distsq)
		end			
    end
    return delta
end

local function oneat(inst, food)
	if food and food.components.edible then
		if food.prefab == "petals" then
			inst.components.sanity:DoDelta(-3)
		end
		if food:HasTag("lotus_item") then
			if food.prefab == "lotus_seed" and inst.added.health < 50 then
				inst.components.health.maxhealth = inst.components.health.maxhealth + 1	
				inst.added.health = inst.added.health + 1
			elseif food.prefab == "lotus_leaf" and inst.added.sanity < 100 then
				inst.components.sanity.max = inst.components.sanity.max + 1
				inst.added.sanity = inst.added.sanity + 1
			end
		end
	end
end

local function OnLevelUp(inst,newlevel)
	local lv = newlevel
	local nhunger = 120 + (lv-1)*7.5
	local nsanity = 150 + (lv-1)*10
	local nhealth = 60 + (lv-1)*5
	inst.components.hunger.max = nhunger 
	inst.components.sanity.max = nsanity + inst.added.sanity
	inst.components.health.maxhealth = nhealth + inst.added.health
	inst.components.health:DoDelta(0)
	inst.fx_levelup = SpawnPrefab("fx_levelup")
	inst.fx_levelup.entity:SetParent(inst.entity)
	local scale = 3
	inst.fx_levelup.Transform:SetScale(scale*1.5,scale*4/5,scale)
	inst.fx_levelup.Transform:SetPosition(0, 0, 0)
end
--=========================================================================================================
---趨֡
-----------------------------------------------------------------------
local function CreateActivatedSkill(inst)
	--
	--1-ֲ
	local function comsume1_plant_test(inst)
		local self = inst.components.sanity
		local val = self:GetPercent(true)*self:GetMaxSanity()
		if val >= 20 then
			return true
		end
		return false
	end
	local function comsume1_plant(inst,self)
		inst.components.sanity:DoDelta(-GenerateNormal(10,3))
	end
	--1-
	local function comsume1_flower_test(inst)
		local self = inst.components.hunger
		local val = self.current
		if val >= 10 then
			return true
		end
		return false
	end
	local function comsume1_flower(inst,self)
		inst.components.hunger:DoDelta(-10)
	end
	--2-ֲ
	local function comsume2_plant_test(inst)
		local self = inst.components.sanity
		local val = self:GetPercent(true)*self:GetMaxSanity()
		if val >= 10 then
			return true
		end
		return false
	end
	local function comsume2_plant(inst,self)
		inst.components.sanity:DoDelta(-10)
	end
	--2-
	local function comsume2_flower_test(inst)
		local self = inst.components.sanity
		local val = self:GetPercent(true)*self:GetMaxSanity()
		if val >= 20 then
			return true
		end
		return false
	end
	local function comsume2_flower(inst,self)
		inst.components.sanity:DoDelta(-20)
	end
	--3
	local function comsume3(inst,self)

	end
	--4-ֲ
	local function comsume4_plant_test(inst)
		local self = inst.components.hunger
		local val = self:GetPercent()
		if val >= 1/3 then
			return true
		end
		return false
	end
	local function comsume4_plant(inst,self)
		local hungermax = inst.components.hunger.max
		inst.components.hunger:DoDelta(-hungermax*1/3)
		inst.components.health:DoDelta(-GenerateNormal(10,1,0))
	end
	--4-
	local function comsume4_flower_test(inst)
		local self = inst.components.sanity
		local val = self:GetPercent(true)*self:GetMaxSanity()
		if val >= 10 then
			return true
		end
		return false
	end
	local function comsume4_flower(inst,self)
		inst.components.sanity:DoDelta(-10)
	end

	--CD
	local cd = {
		[1] = {plant = 10,flower = 20},--A1
		[2] = {plant = 10,flower = 30},--A2
		[3] = 5,--A3
		[4] = {plant = DAY*1.5,flower = DAY}, --
	}




--1
	local function gardening(inst,level)
		local range = 30
		local pos = Vector3(inst.Transform:GetWorldPosition())
		local ents = TheSim:FindEntities(pos.x,pos.y,pos.z, range)
		for k,v in pairs(ents) do
			if v.components.pickable then
				v.components.pickable:FinishGrowing()
			end

			if v.components.hackable then
				v.components.hackable:FinishGrowing()
			end

			if v.components.crop then
				v.components.crop:DoGrow(TUNING.TOTAL_DAY_TIME*3)
			end
			
			if v:HasTag("tree") and v.components.growable and not v:HasTag("stump") then
				v.components.growable:DoGrowth()
			end
		end
		local self = inst.components.skiller
		local BuffData = self:GetBuffData("lotus_bless")
		BuffData.layer = BuffData.layer + math.max(math.floor(GenerateNormal(level+0.5,1)),0)
		self:BuffData_DoDelta("lotus_bless",BuffData)
		
	end
	local function neutral(inst,level)
		local var = level
		local num = math.max(math.floor(GenerateNormal(5.5,level)),1)
		if IsDLCEnabled(CAPY_DLC) and SaveGameIndex:IsModeShipwrecked() then 
			local delay = 0.0
			for i = 1, num, 1 do
				local pos = Vector3(inst.Transform:GetWorldPosition())
				local x, y, z = TUNING.VOLCANOBOOK_FIRERAIN_RADIUS * UnitRand() + pos.x, pos.y, TUNING.VOLCANOBOOK_FIRERAIN_RADIUS * UnitRand() + pos.z
				inst:DoTaskInTime(delay, function(inst)
					local firerain = SpawnPrefab("firerain")
					firerain.Transform:SetPosition(x, y, z)
					firerain:StartStep()
				end)
				delay = delay + TUNING.VOLCANOBOOK_FIRERAIN_DELAY
			end 
		else 
			local pt = Vector3(inst.Transform:GetWorldPosition())
			inst:StartThread(function()
				for k = 1, num do
					local theta = math.random() * 2 * PI
					local radius = math.random(3, 8)
					-- we have to special case this one because birds can't land on creep
					local result_offset = FindValidPositionByFan(theta, radius, 12, function(offset)
						local x,y,z = (pt + offset):Get()
						local ents = TheSim:FindEntities(x,y,z , 1)
						return not next(ents) 
					end)

					if result_offset then
						local tentacle = SpawnPrefab("tentacle")
						
						tentacle.Transform:SetPosition((pt + result_offset):Get())
						GetPlayer().components.playercontroller:ShakeCamera(inst, "FULL", 0.2, 0.02, .25, 40)
						
						--need a better effect
						local fx = SpawnPrefab("splash_ocean")
						local pos = pt + result_offset
						fx.Transform:SetPosition(pos.x, pos.y, pos.z)
						--PlayFX((pt + result_offset), "splash", "splash_ocean", "idle")
						tentacle.sg:GoToState("attack_pre")
					end
					Sleep(.33)
				end
			end)
		end	
	end
	local function lightning(inst,level)
		local num_lightnings =  math.max(math.floor(GenerateNormal(18.5-2*level,6-level)),1)
		inst:StartThread(function()
			for k = 0, num_lightnings do

				local rad = math.random(3, 15)
				local angle = k*((4*PI)/num_lightnings)
				local pos = Vector3(inst.Transform:GetWorldPosition()) + Vector3(rad*math.cos(angle), 0, rad*math.sin(angle))
				GetSeasonManager():DoLightningStrike(pos)
				Sleep(math.random( .3, .5))
			end
		end)
		local self = inst.components.skiller
		local BuffData = self:GetBuffData("lotus_bless")
		BuffData.blood = BuffData.blood + math.max(math.floor(GenerateNormal(5.5 - level,1)),0)
		self:BuffData_DoDelta("lotus_bless",BuffData)
	end
	local function randomspell(inst,data)
		local randomsp = math.random(3)
		local level = inst.components.skiller:GetLevel("normal_1")
		local spell = {gardening,neutral,lightning}
		spell[randomsp](inst,level)
		inst.components.sanity.max = inst.components.sanity.max + 2 - randomsp
		inst:RemoveEventCallback("animover",randomspell)
	end
	local function activated1_plant(inst)
		inst.sg:GoToState("book")
		inst:ListenForEvent("animover",randomspell)
	end

	local function pushout(inst,victim,dist_push)
		if victim and inst:HasTag('player') and (victim.components.health and not victim.components.health:IsDead()) then
			local x1, y1, z1 = victim.Transform:GetWorldPosition()
			local x2, y2, z2 = inst.Transform:GetWorldPosition()
			local dist = math.sqrt((x1 - x2)*(x1 - x2) + (z1 - z2)*(z1 - z2))
			local x3 = (x2 - x1) *dist_push/dist + x2
			local z3 = (z1 - z2) *dist_push/dist + z2
			local testdist = math.sqrt((x3 - x2)*(x3 - x2) + (z3 - z2)*(z3 - z2))
			print("testdist",testdist)
			if dist <=0 then
				return
			end
			
			if dist <= dist_push then 
				--λ
				if victim.Physics ~=nil then
					victim.Physics:Teleport(x3, 0, z3)
				else
					victim.Transform:SetPosition(x3, 0, z3)
				end
		
				--жǷЧλãЧλã纣Ͷ
				local ents = TheSim:FindEntities(x3, 0, z3,1,{"lava"})--lavaΪҽ
				if not victim:HasTag('player') and (not victim:IsOnValidGround() or ents[1] ~= nil) then
					victim:DoTaskInTime(0.07,function(victim) victim:Remove() end)
					if ents[1] ~= nil then --lava
						SpawnPrefab("explode_small").Transform:SetPosition(x3, 0, z3)
						SpawnPrefab("splash_ocean").Transform:SetPosition(x3, 0, z3)
						SpawnPrefab("goldnugget").Transform:SetPosition(x3, 0, z3)
					else
						SpawnPrefab("splash_ocean").Transform:SetPosition(x3, 0, z3)
					end
				end
				--ңܴжӰ죬ԭλ
				if victim:HasTag('player') then
					victim:DoTaskInTime(2,function(victim)
						if not victim:IsOnValidGround() then
							if victim.Physics ~= nil then
								victim.Physics:Teleport(x1, 0, z1)
							else
								victim.Transform:SetPosition(x1, 0, z1)
							end
						end
					end)
				end
			end
		end
	end
	local function activated1_flower(inst)
		local x,y,z = inst.Transform:GetWorldPosition()
		local self = inst.components.skiller
		local lv = self:GetLevel("normal_1")
		local range = 3+lv --ڴ˾ڵʵ嶼ᱻƿ
		local dist_push = range*1.5 --ƿ룬˾ΪĿ걻ƿĵľ롣
		local ents = TheSim:FindEntities(x,y,z,range,nil,{"player"})
		local validnum = 0
		local damage = 0 
		local sum_damage = 0
		for k,v in pairs(ents) do--ɱƿĿ
			if v.components and v.components.locomotor and v.components.combat then
				validnum = validnum +1
			end
		end
		if validnum >= 4 then
			local duration = validnum*1.25*(lv+3)/4
			self:SetBuffDuration("dizzy",duration)
		end
		for k,v in pairs(ents) do
			if v.components and v.components.locomotor and v.components.combat then
				if not inst.components.combat:IsRecentTarget(v) then--ǰָΪĿ
					pushout(inst,v,dist_push)
				end
				if validnum >= 4 then
					self:BuffActivated("dizzy",v,inst)
				end
				if validnum >= 10 then
					damage = validnum*(1+(lv-1)/4)*math.max(GenerateNormal(3,1),0)
					--print("ǰĿ˺Ϊ",damage)
					sum_damage = damage + sum_damage
					v.components.combat:GetAttacked(inst,damage)
				end
			end
		end
		if validnum >= 10 then
			inst.components.combat:GetAttacked(inst,sum_damage*0.2)
			inst.components.hunger:DoDelta(-validnum*GenerateNormal(1,1,0))
			inst.components.hunger.max = inst.components.hunger.max +5
			inst.components.health.maxhealth = inst.components.health.maxhealth + 1
		end	
		local fx = SpawnPrefab("groundpoundring_fx") --Ч
		local scale = (lv+3)/8 
		fx.Transform:SetScale(scale,scale,scale)
		fx.Transform:SetPosition(x,y,z)
	end


	--2
	local function castimprison(inst,target,position)--ӦתɷBUFF
		local self = inst.components.skiller
		local lv = self:GetLevel("normal_2")
		local duration = 10 + (lv-1)*5
		self:SetFileDuration("imprison",duration)
		local range = 2+(lv-1)/2
		self:SetFileRange("imprison",range) 
		self:FileActivated("imprison",target or position ,inst)
	end


	local function fixarmorwood(item)
		if item and item.components and item.components.armor then
			if item.prefab == "armorseashell" or item.prefab =="armorwood" or item.prefab =="armorgrass" or item.prefab =="deerhat" then
				item.components.armor:SetPercent(1)
			end
		end
	end
	local function roll(owner,fn)
		local inv = owner and owner.components.inventory
		if inv then --װͱƷ
			for _,v in  pairs(EQUIPSLOTS) do
				local eq = inv:GetEquippedItem(v)
				fn(eq)
				if eq and eq.components.container then
					for k = 1, eq.components.container.numslots do
						local item = eq.components.container:GetItemInSlot(k)
							fn(item,eq.components.container,k)
					end
				end
				
			end
		end
		for k = 1, inv.maxslots do --ƷƷ
			local item = inv:GetItemInSlot(k)
			fn(item,inv,k)
		end
	end
	local function Regen(inst,lv)
		--ظѪ
		local health_delta = inst.components.health:GetMaxHealth()*(0.4+(lv-1)*0.05)
		inst.components.health:DoDelta(health_delta)
		--ж
		if inst.components.poisonable and inst.components.poisonable:IsPoisoned() then
			inst.components.poisonable:Cure(inst)
		end
		--޸װ
		roll(inst,fixarmorwood)
		
		--ͷЧ
		local pos = inst:GetPosition()
		local pop = SpawnPrefab("explode_small")
		pop.Transform:SetPosition(pos.x,pos.y,pos.z)
	end

	local function activated2_plant(inst)
		local function popcloud(inst, target_ent, position)
			local buffaction = BufferedAction(inst,target_ent,ACTIONS.CASTMAGIC,nil,position,nil,3)
			buffaction.castFn = castimprison
			return {buffaction}--BufferedActionǹؼתվ
		end
		inst.components.playeractionpicker.rightclickoverride = popcloud
	end
	local function activated2_flower(inst)
		local lv = inst.components.skiller:GetLevel("normal_2")
		Regen(inst,lv)
	end	

	--4Ϊʱõĺ
	local function OnIsDay(inst,isday)
		if isday and inst:HasTag("plant") then
			if not inst.photosynthesis then
				local lv = inst.components.skiller.skill.normal_3.lv
				local gexp = 1 + 2*(lv-1)/4
				local hungerdelta = TUNING.WILSON_HUNGER_RATE /16 *(1+lv/5)
				inst.photosynthesis = inst:DoPeriodicTask(DAY/16,function() 
				if not GetWorld().state.isday then
					inst.components.level:GetExp(gexp)
					inst.components.hunger:DoDelta(hungerdelta)
				else
					inst.photosynthesis:Cancel()
					inst.photosynthesis = nil
				end
				end)
			end
		elseif inst.photosynthesis then 	
			inst.photosynthesis:Cancel()
			inst.photosynthesis = nil
		end
	end
	local function hide_in(inst)
		inst.components.colourtweener:StartTween({0.3,0.3,0.3,1}, 0)
		inst:AddTag("notarget")
	end
	local function hide_out(inst)
		inst.components.talker:Say("")
		inst.components.colourtweener:StartTween({1,1,1,1}, 0)
		inst:RemoveTag("notarget")
	end
	local function flower_hide(inst,data)
		local x,y,z = inst.Transform:GetWorldPosition() 
		local range = 5
		local ents = TheSim:FindEntities(x,y,z,range, {"flower"}, {"player"})
		if #ents >=3 then
			--Χ仨ʱ
			hide_in(inst)
			--ʱ󣬽
			local flower_HideinTime = DAY/96
			inst:DoTaskInTime(flower_HideinTime,hide_out)
		end
	end

	--3
	local function OnActivatedFn_A3(inst,EleSkill,order)
		local self = inst.components.skiller
		if inst:HasTag("ultimate_buff") then -- дbuff͹رյ
			self:GetBuffFn("ultimate").BuffRemoved(inst)
		end
		self:StartCooling(order,EleSkill)--ȴȴȻ󴥷ҪȴвҲС
		EleSkill.ActivatedFn(inst,self)
		EleSkill.ComsumeFn(inst,self)
		if inst:HasTag("plant") then
			inst.components.talker:Say(STRINGS.SKILL.NAME.NORAMAL_3.PLANT)
		else
			inst.components.talker:Say(STRINGS.SKILL.NAME.NORAMAL_3.FLOWER)
		end
	end
	local function activated3(inst)
		local self = inst.components.skiller
		local BuffFn_plant = self:GetBuffFn("buff_plant")
		local BuffFn_flower = self:GetBuffFn("buff_flower")
		if inst:HasTag("flower") then
			BuffFn_plant.BuffOccur(inst)
			BuffFn_flower.BuffRemoved(inst)
		elseif inst:HasTag("plant") then
			BuffFn_flower.BuffOccur(inst)
			BuffFn_plant.BuffRemoved(inst)
		end
	end
	---
	local function OnActivatedFn_Ult_Plant (inst,EleSkill)
		inst.sg:GoToState("ultimate_pre")
	end	
	local function activated4_plant(inst)
		inst.components.groundpounder:GroundPound()
		inst.finishedwork_num = 0
		local function OnFinishedwork(inst,data)
			inst.finishedwork_num = inst.finishedwork_num +1
		end
		inst:ListenForEvent("finishedwork",OnFinishedwork)
		inst:DoTaskInTime(1,function(inst)	
			inst:RemoveEventCallback("finishedwork",OnFinishedwork)
			local extra = math.floor(inst.finishedwork_num/10)*0.05
			local damage = inst.finishedwork_num *(1+extra)*GenerateNormal(1,1,0)
			inst.components.combat:GetAttacked(inst,damage)
		end)
	end
	local function activated4_flower(inst)
		local self = inst.components.skiller
		local lv = self:GetLevel("ultimate")
		local duration = DAY*(lv+1)/32
		self:SetBuffDuration("ultimate",duration)
		self:BuffActivated("ultimate",inst)
	end	

	--ʼ
	inst.components.skiller:AddSkill("passive")
	inst.components.skiller:SetLevel("passive",1)
	inst.components.skiller:SetPassiveSkill("passive")	

	inst.components.skiller:AddElementSkill("normal_1","light",STRINGS.SKILL.NAME.NORAMAL_1.PLANT,"plant",cd[1].plant,activated1_plant,comsume1_plant,comsume1_plant_test)
	inst.components.skiller:AddElementSkill("normal_1","push",STRINGS.SKILL.NAME.NORAMAL_1.FLOWER,"flower",cd[1].flower,activated1_flower,comsume1_flower,comsume1_flower_test)
	inst.components.skiller:SetLevel("normal_1",0)
	
	inst.components.skiller:AddElementSkill("normal_2","imprison",STRINGS.SKILL.NAME.NORAMAL_2.PLANT,"plant",cd[2].plant,activated2_plant,comsume2_plant,comsume2_plant_test)
	inst.components.skiller:AddElementSkill("normal_2","regen",STRINGS.SKILL.NAME.NORAMAL_2.FLOWER,"flower",cd[2].flower,activated2_flower,comsume2_flower,comsume2_flower_test)
	inst.components.skiller:SetLevel("normal_2",0)	
	
	inst.components.skiller:AddElementSkill("normal_3","transform",STRINGS.SKILL.NAME.NORAMAL_3.GENERIC,"plant",cd[3],activated3,comsume3,nil,OnActivatedFn_A3)
	inst.components.skiller:SetLevel("normal_3",0)	
	
	inst.components.skiller:AddElementSkill("ultimate","groundpound",STRINGS.SKILL.NAME.ULTIMATE.PLANT,"plant",cd[4].plant,activated4_plant,comsume4_plant,comsume4_plant_test,OnActivatedFn_Ult_Plant)
	inst.components.skiller:AddElementSkill("ultimate","angry",STRINGS.SKILL.NAME.ULTIMATE.FLOWER,"flower",cd[4].flower,activated4_flower,comsume4_flower,comsume4_flower_test)
	inst.components.skiller:SetLevel("ultimate",0)

	--ܰ
	TheInput:AddKeyDownHandler(KEY_ULTIMATE, function()
		local inst = GetPlayer() 
		if inst and inst:HasTag("samansha") and not IsPaused() then
			if inst.components.driver and inst.components.driver:GetIsDriving()  then --ʱֻû̬
				if inst:HasTag("flower") then
					inst.components.playerskill:ActivedSkillTest("ultimate")
				end
				return
			end		
			if inst:HasTag("plant") then
				inst.components.skiller:ActivatedTest("ultimate","plant")
			elseif inst:HasTag("flower") then
				inst.components.skiller:ActivatedTest("ultimate","flower")
			end
		end
	end)
	TheInput:AddKeyDownHandler(KEY_NORMAL_1, function()
		local inst = GetPlayer() 
		if inst and inst:HasTag("samansha") and not IsPaused()  then
			if inst:HasTag("plant") then
				inst.components.skiller:ActivatedTest("normal_1","plant")
			elseif inst:HasTag("flower") then
				inst.components.skiller:ActivatedTest("normal_1","flower")
			end		
		end
	end)
	TheInput:AddKeyDownHandler(KEY_NORMAL_2, function()
		local inst = GetPlayer() 
		if inst and inst:HasTag("samansha") and not IsPaused()  then
			if inst:HasTag("plant") then
				inst.components.skiller:ActivatedTest("normal_2","plant")
			elseif inst:HasTag("flower") then
				inst.components.skiller:ActivatedTest("normal_2","flower")
			end		
		end
	end)
	TheInput:AddKeyDownHandler(KEY_NORMAL_3, function()
		local inst = GetPlayer() 
		if inst and inst:HasTag("samansha") and not IsPaused()then
			inst.components.skiller:ActivatedTest("normal_3","plant")		
		end
	end)
	
end

-------------------------BUFF--------------------------
local function CreateSelfBuff(inst)
	--
	local function ActionInit(inst)
		local plantfn = ACTIONS.PLANT.fn
		ACTIONS.PLANT.fn = function(act)
			if plantfn(act) then
				local layer = 1
				if act.invobject.prefab =="lotus_seed" then
					layer = 5
				end
				inst:PushEvent("layerdelta",{delta = layer})
				return true
			end
			return false
		end
		local harvestfn = ACTIONS.HARVEST.fn
		ACTIONS.HARVEST.fn = function (act)
			if harvestfn(act) then
				local layer = 1
				if act.target.components.crop and act.target.prefab == "lotus" then
					layer = 5
				end
				inst:PushEvent("layerdelta",{delta = layer})
				return true
			end
			return false
		end	
		local deployfn = ACTIONS.DEPLOY.fn
		ACTIONS.DEPLOY.fn = function(act)
			if deployfn(act) then
				local item = act.invobject
					if item.prefab == "acorn" or item.prefab == "pinecone" or item.prefab == "coconut" or item.prefab == "jungletreeseed" or item.prefab == "butterfly" then
						item:AddTag("deployed")
						inst:PushEvent("layerdelta",{delta = 1})
					end
				return true
			end
			return false	
		end
		
	end
	local function onlayerdelta(inst,data)	
		local data_cur = inst.components.skiller:GetBuffData("lotus_bless")
		local layer_cur = data.delta + data_cur.layer
		local x,y,z = inst.Transform:GetWorldPosition()
		local deerchance = layer_cur*0.001
		local deerheart = TheSim:FindEntities(x,y,z,30,{"RespawnDeer"})
		if math.random() < deerchance and #deerheart>0 then --һֻ¹
			local deer = SpawnPrefab("deer")
			local pos = deerheart[1]:GetPosition()
			deer.Transform:SetPosition(pos.x,pos.y,pos.z)
			deerheart[1]:Remove()
			layer_cur = layer_cur - 1000
			local boss = GetValidBoss()
			if data_cur.blood > 1000 then
				local delay = 5
				local trial = SpawnToInst(inst,boss[math.random(#boss)],delay)
				inst.components.playercontroller:ShakeCamera(deer, "FULL", delay, 0.05, .5, 40)
				local function trialover(deer,data)
					deer:RemoveTag("trial")
					deer:ReturnToScene()
				end			
				local str = STRINGS.DEER.ONLAYERDELTA
				deer:AddTag("trial")
				deer:DoTaskInTime(delay/2,function(deer) deer:RemoveFromScene() deer.components.talker:Say(str.TRIAL_1..str.TRIAL_2..(delay/2)..str.TRIAL_3) end)

				deer:ListenForEvent("death",function(trial,data)trialover(deer,data) end,trial)
				data_cur.blood = 0
				trial.components.combat:SetTarget(inst)
			end
		end
		data_cur.layer = math.max(layer_cur,0) 
		data_cur.blood = math.max(data_cur.blood - GenerateNormal(0.5,1)*data.delta ,0)
		inst.components.skiller:BuffData_DoDelta("lotus_bless",data_cur)
	end
	local function onblood(inst,data)
		if data and data.victim and not data.victim:HasTag("structure") then	
			local victim = data.victim
			local buffdata = inst.components.skiller:GetBuffData("lotus_bless")
			local blood_cur =  buffdata.blood
			local delta_increase = SA_BLOOD_TABLE[victim.prefab] and SA_BLOOD_TABLE[victim.prefab].default or 0
			--Ѫծ
			local delta_decrease = 0
			local victim = data.victim
			delta_increase = delta_increase + GenerateNormal(1,1)
			--ɱǿѪծ
			if victim:HasTag("epic") and not victim:HasTag("tree")then
				if victim.prefab == "spiderqueen" or victim.prefab == "warg" then
					delta_decrease = delta_decrease + GenerateNormal(200,30)
				else
					delta_decrease = delta_decrease + GenerateNormal(500,30)
				end
			end
			--¾ǸѪծͱ¼
			local boss = GetValidBoss()
			local epic = GetValidEpic()
			local isdriving = inst.components.driver and inst.components.driver:GetIsDriving()
			local monster = nil
			if blood_cur > 300 and blood_cur <=500 and not isdriving then 
				if math.random()<0.1 +  (blood_cur-300) * 0.002 then
					monster = SpawnToInst(inst,epic[math.random(#epic)])
					delta_decrease = delta_decrease + GenerateNormal(150,30)
				end
			elseif blood_cur >500 and not isdriving then
				if math.random()<0.1 + (blood_cur-500) *0.001 then
					monster = SpawnToInst(inst,boss[math.random(#boss)])
					delta_decrease = delta_decrease + GenerateNormal(500,50)
				end
			end
			if monster then
				monster.components.combat:SetTarget(inst)
			end
			
			
			--
			local slaughter_layer = inst:HasTag("blood_slaughter") and inst.components.skiller:GetBuffData("blood_slaughter").layer or 0
			local nemesis_layer = inst:HasTag("blood_nemesis") and inst.components.skiller:GetBuffData("blood_nemesis").layer or 0
			--Ӱ
			local factor_slaughter = 1 + slaughter_layer*(slaughter_layer == 30 and 0.5 or slaughter_layer >=10 and 0.2 or 0.1)
			local factor_nemesis = 1 + nemesis_layer * 0.25
			buffdata.blood = math.max(blood_cur + delta_increase - delta_decrease,0)*factor_slaughter*factor_nemesis
			if victim.prefab == "krampus" and inst:HasTag("sackpawner") then --ݲÿ˹
				local chance = 0.001* buffdata.layer
				if math.random() < chance then
					buffdata.layer = math.max(buffdata.layer - 1000, 0)
					inst:RemoveTag("sackpawner")
					SpawnPrefab("poopcloud").Transform:SetPosition(inst:GetPosition():Get())
					SpawnPrefab("krampus_sack").Transform:SetPosition(inst:GetPosition():Get())
				end
			end		
			inst.components.skiller:BuffData_DoDelta("lotus_bless",buffdata)
		end
	end
	local lotus_bless_Fntable = {
		BuffOccur = function(inst) inst:ListenForEvent("layerdelta",onlayerdelta) end,
		BuffOnKilled = onblood,
		BuffRemoved = function(inst) inst:RemoveEventCallback("layerdelta",onlayerdelta) end,
	}
	ActionInit(inst)
	inst.components.skiller:CreateBuff("lotus_bless",-1,nil,lotus_bless_Fntable)
	inst.components.skiller:SetBuffOrder("lotus_bless","passive")
	inst.components.skiller:SetBuffData("lotus_bless",{layer=0,blood=0})	
	inst.components.skiller:BuffActivated("lotus_bless",inst)

	--ѣ
	local function MakeDizzyBuff()--ѣBUFF
		local buff = {}
		

		local function dizzy (target,caster,data)
			target.components.locomotor:Stop()
			target.components.locomotor.disable = true
			target.components.combat.canattack = false
			target:AddTag("dizzy")
			--ΪЧ
			local fxposition_y = 4
			local scale = 1
			if target:HasTag("largecreature") then
				fxposition_y = 10
				scale = 1.3
			elseif target:HasTag("smallcreature") then
				fxposition_y = 2
			end
			target.fx_dizzy = SpawnPrefab("buff_dizzy")
			target.fx_dizzy.entity:SetParent(target.entity)
			target.fx_dizzy.Transform:SetPosition(0, fxposition_y, 0)
			target.fx_dizzy.Transform:SetScale(scale, scale, scale/2)
		end
		local function buffover(target,caster,data)
			target.components.locomotor.disable = false
			target.components.combat.canattack = true
			target:RemoveTag("dizzy")
			target.fx_dizzy:Remove()
		end
		buff.fn = {}
		buff.duration = 10
		buff.data = {}
		buff.fn.BuffOccur  = dizzy
		buff.fn.BuffRemoved = buffover
		return buff
	end	

	inst.components.skiller:AddBuff("dizzy",MakeDizzyBuff())
	inst.components.skiller:SetBuffOrder("dizzy","normal_1")
	--BUFF
	local function MakeImprisonBuff()
		local buff = {}
		local function imprison (target,caster,data)
			target.components.locomotor:StopMoving()
			target.Physics:SetActive(false) 
			target:AddTag("imprison")
			target.AnimState:SetMultColour(0.3, 0.3, 0.3, 1)
		end
		local function buffover(target,caster,data)
			target.Physics:SetActive(true) 
			target:RemoveTag("imprison")
			target.AnimState:SetMultColour(1,1,1,1)
		end	
		buff.fn = {}
		buff.duration = 10
		buff.data = {}
		buff.fn.BuffOccur  = imprison
		buff.fn.BuffRemoved = buffover
		return buff
	end	
	--
	local function castimprisondebuff(pos,caster,range,left_duration,data) --ı
		local self = caster.components.skiller
		local ents  = TheSim:FindEntities(pos.x,pos.y,pos.z,range,nil,{"samansha","imprison"})
		self:SetBuffDuration("imprison",left_duration)
		for k,v in pairs(ents) do
			if v.components and v.components.locomotor then
				self:BuffActivated("imprison",v,caster)
			end
		end			
	end
	local imprisonfile_fntable = {
		FileOccur = function(magicinst,caster,range,left_duration,data)
			local pos = magicinst:GetPosition()
			local pop = SpawnPrefab("poopcloud")
			pop.Transform:SetPosition(pos.x,pos.y,pos.z)
			castimprisondebuff(pos,caster,range,left_duration,data)
		end,
		FileOnTick = function(magicinst,caster,range,left_duration,data)
			local pos = magicinst:GetPosition()
			castimprisondebuff(pos,caster,range,left_duration,data)	
		end,
		FileRemoved = function(magicinst,caster,range,left_duration,data)
			--ҲԼӵЧģ
		end	

	}
	local function filecustomfn_imprison(inst)
		inst.AnimState:SetBank("file_imprison")
		inst.AnimState:SetBuild("file_imprison")
		inst.AnimState:PlayAnimation("ontick",true)
	end
	inst.components.skiller:AddBuff("imprison",MakeImprisonBuff())
	inst.components.skiller:SetBuffOrder("imprison","normal_2")	
	inst.components.skiller:CreateFile("imprison",10,imprisonfile_fntable,nil,1,filecustomfn_imprison)

	--̬תBUFF
	local function A3_plant_on(inst)
		local self = inst.components.skiller
		local lv = self:GetLevel("normal_3")
		inst:AddTag("plant")
		inst.AnimState:SetBuild("samansha")
		--ƶϵ޸
		local modifier =lv/10
		if inst.components.locomotor.AddSpeedModifier_Mult then
			inst.components.locomotor:AddSpeedModifier_Mult("samansha_plant",modifier)--SWķʽ
		else
			inst.components.locomotor.walkspeed = TUNING.WILSON_WALK_SPEED * (modifier+1)--ROGķʽ
			inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED * (modifier+1)				
		end	
		
	end
	local function A3_plant_off(inst)
		inst:RemoveTag("plant")
		--ƶϵ޸
		if inst.components.locomotor.AddSpeedModifier_Mult then
			inst.components.locomotor:RemoveSpeedModifier_Mult("samansha_plant")	
		else
			inst.components.locomotor.walkspeed = TUNING.WILSON_WALK_SPEED --ROGķʽ
			inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED		
		end			
	end
	local function A3_flower_on(inst)
		local self = inst.components.skiller
		local lv = self:GetLevel("normal_3")
		inst.AnimState:SetBuild("samansha_flower")
		inst:AddTag("flower")
		--ϵ޸
		if inst.components.combat.AddDamageModifier then --SWķʽ
			inst.components.combat:AddDamageModifier("samansha_flower",0.5 + (lv-1)*0.05)
		else
			inst.components.combat.damagemultiplier = 1+(lv-1)*0.05
		end	
	end
	local function A3_flower_off(inst)
		inst:RemoveTag("flower")
		if inst.components.combat.attack_damage_modifiers then --SWķʽ
			inst.components.combat.attack_damage_modifiers["samansha_flower"]=nil--ƳĹ
		else 
			inst.components.combat.damagemultiplier = 0.5 --ROGʽ
		end		
	end
	inst.components.skiller:CreateBuff("buff_plant",-1,{},nil,A3_plant_on,A3_plant_off)
	inst.components.skiller:CreateBuff("buff_flower",-1,{},nil,A3_flower_on,A3_flower_off)
	inst:ListenForEvent("SkillLvDelta",function(inst,data)  -- ʱһܵȼʱ±
		if data and data.order and data.order == "normal_3" then
			local name
			if inst:HasTag("plant") then
				name = "buff_plant"
			elseif inst:HasTag("flower") then
				name = "buff_flower"
			end
			local BuffFn = inst.components.skiller:GetBuffFn(name)
			BuffFn.BuffOccur(inst)
		end
	end)
	--
	local function aoe_on (inst,caster)
		local lv = inst.components.skiller:GetLevel("ultimate")
		local range = lv+2--Χ
		local percent = (lv-1)/4
		inst.components.combat:SetAreaDamage(range, percent)
	end
	local function aoe_fx(inst,data)
		local lv = inst.components.skiller:GetLevel("ultimate")
		if data and data.target  then
			local other = data.target
			local fx = SpawnPrefab("groundpoundring_fx")
			fx.Transform:SetScale((lv+1)/2,(lv+1)/2,(lv+1)/2) 
			fx.Transform:SetPosition(other:GetPosition():Get())
		end	
	end
	local function aoe_off()
		local range = nil
		local percent = nil		
		inst.components.combat:SetAreaDamage(range, percent)	
	end
	inst.components.skiller:CreateBuff("shock",-1,{},nil,aoe_on,aoe_off,nil,nil,aoe_fx)
	--Ѫ
	local function vampire_onhit(inst,data)
		local lv = inst.components.skiller:GetLevel("ultimate")
		if data and data.damage then --Ѫ
			local regen = data.damage *(0.25 + (lv-1)*0.125)
			inst.components.health:DoDelta(regen)
		end
	end
	inst.components.skiller:CreateBuff("vampire",-1,{},nil,nil,nil,nil,nil,vampire_onhit)
	--
	local function MakeUltimateBuff()
		local buff = {}
		local function onkilled(inst,data)
			local self = inst.components.skiller
			if inst.buffduration and inst.buffduration["ultimate"] then
				inst.buffduration["ultimate"] = inst.buffduration["ultimate"] + 2
			end
		end	
		local function flower_ultimate(inst,caster)
			inst:AddTag("ultimate_buff")
			local lv = inst.components.skiller:GetLevel("ultimate")
			local scale = 1.25 + (lv-1)*0.125
			inst.Transform:SetScale(scale,scale,scale)
			inst.buff_ultimate = SpawnPrefab("buff_ultimate")
			inst.buff_ultimate.entity:SetParent(inst.entity)
			inst.buff_ultimate.Transform:SetScale(1.5,1.5,1.5)
			inst.buff_ultimate.Transform:SetPosition(0, 0.5, 0)
			--
			if inst.components.hunger.AddBurnRateModifier then
				inst.components.hunger:AddBurnRateModifier("ultimate",0.5)
			else
				inst.components.hunger.hungerrate = inst.components.hunger.hungerrate*1.5
			end
			--ս
			local damagemodifier = 0.5+0.5*lv 
			if inst.components.combat.AddDamageModifier then
				inst.components.combat:AddDamageModifier("ultimate",damagemodifier)
			else
				inst.components.combat.damagemultiplier = damagemodifier+0.5
			end	
			if lv>1 then
				inst.components.skiller:BuffActivated("shock",inst)
				inst.components.skiller:BuffActivated("vampire",inst)
			end
		end
		--==============================================================
		local function flower_ultimate_cancel(inst,caster)
			local self = inst.components.skiller
			inst:RemoveTag("ultimate_buff")
			inst.Transform:SetScale(1, 1, 1)
			if inst.buff_ultimate then
				inst.buff_ultimate:Remove()
			end			
			--
			if inst.components.hunger.RemoveBurnRateModifier then
				inst.components.hunger:RemoveBurnRateModifier("ultimate")
			else
				inst.components.hunger.hungerrate = inst.components.hunger.hungerrate/1.5
			end
			
			--ս
			if inst.components.combat.RemoveDamageModifier then
				inst.components.combat:RemoveDamageModifier("ultimate")
			else
				inst.components.combat.damagemultiplier = 1
			end	
			if self:IsActivated("shock") then
				self:BuffDeactivated("shock",inst)
			end
			if self:IsActivated("vampire") then
				self:BuffDeactivated("vampire",inst)
			end
		end
		buff.fn = {}
		buff.duration = DAY/16 -- 趨1ʱ䣬֮仯
		buff.data = {}
		buff.fn.BuffOccur  = flower_ultimate
		buff.fn.BuffRemoved = flower_ultimate_cancel
		buff.fn.BuffOnKilled = onkilled
		return buff	
	end
	inst.components.skiller:AddBuff("ultimate",MakeUltimateBuff())
	inst.components.skiller:SetBuffOrder("ultimate","ultimate")	

end

--========================================================================================================
--ר
local function CustomRecipe()
	---רƷ
	--ͼ
	RECIPETABS['SAMANSHA_TAB'] = {str = "SAMANSHATAB", sort=999, icon = "samansha_tab.tex", icon_atlas = "images/samansha_tab.xml"}
	--Ҷͼ
	local lotus_leaf = Ingredient("lotus_leaf", 1, "images/inventoryimages/lotus_leaf.xml")
	--
	local eyeshadeRecipe = Recipe("hat_eyeshade", {Ingredient("silk", 10),Ingredient("cutreeds", 1)}, RECIPETABS.SAMANSHA_TAB, TECH.SCIENCE_ONE)
	eyeshadeRecipe.atlas = "images/inventoryimages/hat_eyeshade.xml"
	--Ҷɡ
	local lotus_umbrellaRecipe = Recipe("lotus_umbrella", {lotus_leaf}, RECIPETABS.SAMANSHA_TAB, TECH.SCIENCE_TWO)
	lotus_umbrellaRecipe.atlas = "images/inventoryimages/lotus_umbrella.xml"
	--
	local butterflyRecipe = Recipe("butterfly", {Ingredient("petals_evil", 1)}, RECIPETABS.SAMANSHA_TAB, TECH.NONE)	
	--ɻغѪծƣΪSWRECIPEı䣬Ҫж
	if IsDLCEnabled(CAPY_DLC) then
		local lotus_pondRecipe = Recipe("lotus_pond", {Ingredient("shovel", 2),Ingredient("rocks", 6),Ingredient("poop", 6)}, RECIPETABS.SAMANSHA_TAB, TECH.SCIENCE_TWO,RECIPE_GAME_TYPE.COMMON,"lotus_pond_placer",5)
		lotus_pondRecipe.atlas = "images/lotus_pond.xml"
		local bloodRecipe = Recipe("bloodometer", {Ingredient("livinglog", 2), Ingredient("nightmarefuel", 1),Ingredient("goldnugget", 2)}, RECIPETABS.SAMANSHA_TAB,  TECH.MAGIC_TWO, RECIPE_GAME_TYPE.COMMON, "bloodometer_placer")
		bloodRecipe.image =	"winterometer.tex"
	else
		local lotus_pondRecipe = Recipe("lotus_pond", {Ingredient("shovel", 2),Ingredient("rocks", 6),Ingredient("poop", 6)}, RECIPETABS.SAMANSHA_TAB, TECH.SCIENCE_TWO,"lotus_pond_placer",5)
		lotus_pondRecipe.atlas = "images/lotus_pond.xml"
		local bloodRecipe = Recipe("bloodometer", {Ingredient("livinglog", 2), Ingredient("nightmarefuel", 1),Ingredient("goldnugget", 2)}, RECIPETABS.SAMANSHA_TAB,  TECH.MAGIC_TWO, "bloodometer_placer")
		bloodRecipe.image =	"winterometer.tex"
	end

	--¹ͼ
	local deerhorn =  Ingredient("deerhorn",1,"images/inventoryimages/deerhorn.xml")

	--¹ñ 
	local deerhat_1 = nil
	if IsDLCEnabled(CAPY_DLC) and SaveGameIndex:IsModeShipwrecked() then 
		deerhat_1 = Ingredient("blubber", 8)
	else 
		deerhat_1 = Ingredient("beefalowool", 12)
	end	
	local deerhatRecipe = Recipe("deerhat", {deerhorn, deerhat_1}, RECIPETABS.SAMANSHA_TAB, TECH.MAGIC_TWO)
	deerhatRecipe.atlas = "images/inventoryimages/deerhat.xml"
	
	local lotus_leaf_deerheart = Ingredient("lotus_leaf", 40, "images/inventoryimages/lotus_leaf.xml")
	local lotus_seed_deerheart = Ingredient("lotus_seed", 40, "images/inventoryimages/lotus_seed.xml")
	--¹
	local deerheartRecipe = Recipe("deerheart", {Ingredient("nightmarefuel", 10), lotus_leaf_deerheart,lotus_seed_deerheart}, RECIPETABS.SAMANSHA_TAB, TECH.MAGIC_THREE)
	deerheartRecipe.atlas = "images/inventoryimages/deerheart.xml"
	--ֽԵĺϳ
	Recipe("dug_berrybush", {Ingredient("dug_sapling", 1),Ingredient("twigs", 10)}, RECIPETABS.SAMANSHA_TAB, TECH.SCIENCE_TWO)
	Recipe("dug_berrybush2", {Ingredient("dug_grass", 1),Ingredient("cutgrass", 10)}, RECIPETABS.SAMANSHA_TAB, TECH.SCIENCE_TWO)

end

---------------ȡ
---------------ȡ
local function onsave(inst,data)
	if not inst:HasTag("sackpawner") then
		data.havesack = true
	end
	if inst:HasTag("plant") then
		data.iswhat = "plant"
	elseif inst:HasTag("flower") then
		data.iswhat = "flower"
	end
	data.added = inst.added
	data.statusdata = {
	hunger = {percent = inst.components.hunger:GetPercent()},
	sanity ={percent = inst.components.sanity:GetPercent(true) },
	health ={percent = inst.components.health:GetPercent() },
	
	}
end
local function onload(inst,data)
	local self = inst.components.skiller
	if data then 
		if data.havesack then
			inst:RemoveTag("sackpawner")
		end
		if data.iswhat then
			local BuffFn_plant = inst.components.skiller:GetBuffFn("buff_plant")
			local BuffFn_flower = inst.components.skiller:GetBuffFn("buff_flower")
			if data.iswhat == "plant" then
				BuffFn_plant.BuffOccur(inst)
				BuffFn_flower.BuffRemoved(inst)
			elseif data.iswhat == "flower" then
				BuffFn_flower.BuffOccur(inst)
				BuffFn_plant.BuffRemoved(inst)
			end
		end
		if data.added then
			inst.added = data.added
			inst.components.sanity.max = inst.components.sanity.max + inst.added.sanity
			inst.components.health.maxhealth = inst.components.health.maxhealth + inst.added.health
		end
		if data.statusdata then
			inst.components.hunger:SetPercent(data.statusdata.hunger.percent)
			inst.components.sanity:SetPercent(data.statusdata.sanity.percent)
			inst.components.health:SetPercent(data.statusdata.health.percent,"file_load")
		end
	end
	
end
local fn = function(inst)

	inst.MiniMapEntity:SetIcon( "samansha.tex" )
	inst:AddTag("samansha")
	inst:AddTag("plant")

	inst:AddTag("sackpawner")

	inst.soundsname = "wendy"

	inst.AnimState:SetBuild("samansha")

	inst.components.locomotor.walkspeed = TUNING.WILSON_WALK_SPEED
	inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED

    
	if inst.components.combat.AddDamageModifier then
		inst.components.combat:AddDamageModifier("samansha_plant",-0.5)
	else
		inst.components.combat.damagemultiplier = 0.5
	end

	inst.components.hunger:SetMax(120)
	inst.components.sanity:SetMax(150)
	inst.components.health:SetMaxHealth(60)
	

	--inst:ListenForEvent("killed",deerspawner)

	

	inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE

	inst.components.eater:SetOnEatFn(oneat)

	--inst.components.eater:SetDiet({FOODGROUP.OMNI}, {FOODGROUP.OMNI_NOMEAT})

	inst:RemoveTag("scarytoprey")	
	inst.components.sanity.custom_rate_fn = sanityfn


	inst:AddComponent("groundpounder")
	inst.components.groundpounder.destroyer = true
	
	--ȼʼ
	inst:AddComponent("leveler")
	inst.components.leveler:AddKillLevelSystem()
	inst.components.leveler:SetOnLevelDeltaFn("kill",OnLevelUp)
	
	--ܳʼ
	inst:AddComponent("skiller")
	CreateActivatedSkill(inst)
	CreateSelfBuff(inst)

	--ר
	CustomRecipe()
	
	--¹
	TheInput:AddKeyDownHandler(KEY_DEER_FOLLOW, function()
		local tag = "samansha_deer"
		local str = STRINGS.DEER.LEADER
		if inst.components.leader:CountFollowers(tag)> 0 then
			inst.components.leader:RemoveFollowersByTag(tag)
			inst.components.talker:Say(str.STAY)
		else
			local deer = FindEntity(inst,30,nil,{tag})
			if deer and not deer:HasTag("wild") then
				inst.components.leader:AddFollower(deer)
				inst.components.talker:Say(str.FOLLOW)
			else
				inst.components.talker:Say(str.LOST)
			end	
		end
	end)

	--ͳϵͳlocomotor
	--inst:AddComponent("achievement")


	inst.added = {health = 0,sanity = 0}
	inst.OnSave = onsave
	inst.OnLoad = onload
	--
	--
	--[[
	TheInput:AddKeyDownHandler(KEY_Z, function()
		print("ok")
		inst.components.leveler:DoDelta("kill",1000)
	end)
	TheInput:AddKeyDownHandler(KEY_X, function()
		local blood = inst.components.skiller:GetBuffData("lotus_bless").blood
		local slaughter_layer = inst.components.skiller:GetBuffData("blood_slaughter").layer
		local nemesis_layer = inst.components.skiller:GetBuffData("blood_nemesis").layer
		print(string.format("blood:%d,slaughter:%d,namesis%d",blood,slaughter_layer,nemesis_layer))
	end)	]]
	
end


return MakePlayerCharacter("samansha", prefabs, assets, fn, start_inv)