local UIAnim = require "widgets/uianim"
local Text = require "widgets/text"
local Widget = require "widgets/widget"
local Image = require "widgets/image"
local ImageButton = require "widgets/imagebutton"
local AnimButton = require "widgets/animbutton"
local HoverText = require "widgets/hoverer"


local function refresh(self,Lose)
	if self.CDduration.duration <=0 and Lose == true then
		self.CDduration:Hide()
		if self.lv then
			self.lv:Show()
		end
	elseif self.CDduration.duration >0 and Lose == false then 
		self.CDduration:Hide()
		if self.lv then
			self.lv:Show()
		end
	else
		self.CDduration:Show()
		if self.lv then
			self.lv:Hide()
		end		
	end
	if self.lv and self.lv.num <= 0 then
		self.CDduration:Hide()
		self.lv:Hide()
	end
end

local function animSetPercent (self, val, num)
	local val = val or 0
	self.anim:GetAnimState():SetPercent("anim", val)
	if self.CDduration  then
		self.CDduration.duration = num or 0
		self.CDduration:SetString(self.CDduration.duration)
	end
end

local RPG_State = Class(Widget, function(self, owner)
	Widget._ctor(self, "RPG_State")
	self.owner = owner
	self.scale = 1
	--ָʾ
	if self.owner and self.owner.components.skiller then	
		self.passive = self:AddChild(Widget("passive"))	
		self.passive:SetPosition(0,80,0)
		self.passive:SetScale(0.5,0.5,0.5)	
		self.passive:MoveToFront()
		self.passive.anim = self.passive:AddChild(UIAnim())
		self.passive.anim:GetAnimState():SetBank("passive_cd")
		self.passive.anim:GetAnimState():SetBuild("passive_cd")
		self.passive.anim:GetAnimState():PlayAnimation("anim")

		self.passive.CdDuration = self.passive:AddChild(Text(BODYTEXTFONT, 45)) --ʾף
		self.passive.CdDuration:SetPosition(5, -20, 0)
		self.passive.CdDuration:Hide()
		
		self.passive.lv = self.passive:AddChild(Text(BODYTEXTFONT, 40)) --ʾܵȼ
		self.passive.lv:SetPosition(5, 10, 0)
		self.passive.lv:Hide()
		
		self.passive.OnGainFocus = function()
			self:OnGainFocus(self)
			self.passive.lv:Show()
			self.passive.CdDuration:Show()
		end
		self.passive.OnLoseFocus = function()
			self:OnLoseFocus(self)
			self.passive.lv:Hide()
			self.passive.CdDuration:Hide()
		end		
		
	end
		
		--ָʾ
	if self.owner and self.owner.components.skiller then	
		self.ultimate = self:AddChild(Widget("ultimate"))
		self.ultimate:SetPosition(0, 0,0)
		self.ultimate:SetScale(0.3,0.3,0.3)	
		self.ultimate:MoveToBack()
		self.ultimate.anim = self.ultimate:AddChild(UIAnim())
		self.ultimate.anim:GetAnimState():SetBank("ultimate_cd")
		self.ultimate.anim:GetAnimState():SetBuild("ultimate_cd")
		self.ultimate.anim:GetAnimState():PlayAnimation("anim")
		--ultimate
		self.ultimate.CDduration = self.ultimate:AddChild(Text(BODYTEXTFONT, 120)) --ʾCDʱ
		self.ultimate.CDduration:SetHAlign(ANCHOR_MIDDLE)
		self.ultimate.CDduration:SetPosition(5, 0, 0)
		self.ultimate.lv = self.ultimate:AddChild(Text(BODYTEXTFONT, 120)) --ʾܵȼ		
		self.ultimate.lv:SetHAlign(ANCHOR_MIDDLE)
		self.ultimate.lv:SetPosition(5, 0, 0)	
		self.ultimate.OnGainFocus = function()
			self:OnGainFocus(self)
			refresh(self.ultimate,false)
		end
		self.ultimate.OnLoseFocus = function()
			self:OnLoseFocus(self)
			refresh(self.ultimate,true)
		end	

		self.ultimate.point = self.ultimate:AddChild(ImageButton("images/skillpoint_button.xml", "skillpoint_button.tex", "skillpoint_button.tex", "skillpoint_button.tex"))
		self.ultimate.point:SetTooltip("U")
		self.ultimate.point:SetPosition(140, 0, 0)
		self.ultimate.point:SetScale(4)	
		self.ultimate.point:MoveToFront()
		self.ultimate.point:SetOnClick( function() self.owner:PushEvent("SurplusDelta",{Delta = -1,order = "ultimate"})  end)	
		self.ultimate.point:Hide()
	end
	--Сָʾ
	--normal_1
	if self.owner and self.owner.components.skiller then
		self.normal_1 = self:AddChild(Widget("normal_1"))
		self.normal_1:SetPosition(80, 40,0)
		self.normal_1:SetScale(0.7,0.7,0.7)	
		--
		self.normal_1.anim = self.normal_1:AddChild(UIAnim())
		self.normal_1.anim:GetAnimState():SetBank("normal_cd")
		self.normal_1.anim:GetAnimState():SetBuild("normal_cd")
		self.normal_1.anim:GetAnimState():PlayAnimation("anim")
		--ֲ
		self.normal_1.lv = self.normal_1:AddChild(Text(BODYTEXTFONT, 40))
		self.normal_1.lv:SetHAlign(ANCHOR_MIDDLE)
		self.normal_1.lv:SetPosition(0, 0, 0)
		self.normal_1.lv:SetColour(0, 0.5, 0, 0.5)
		self.normal_1.lv:Hide()	
		--ƶʱ״̬
		self.normal_1.OnGainFocus = function()
			self:OnGainFocus(self)
			self.normal_1.lv:Show()
		end
		self.normal_1.OnLoseFocus = function()
			self:OnLoseFocus(self)
			self.normal_1.lv:Hide()	
		end
		
		--ӵйصİť	
		self.normal_1.point = self.normal_1:AddChild(ImageButton("images/skillpoint_button.xml", "skillpoint_button.tex", "skillpoint_button.tex", "skillpoint_button.tex"))
		self.normal_1.point:SetTooltip("A1")
		self.normal_1.point:SetPosition(50, 0, 0)
		self.normal_1.point:Hide()
		self.normal_1.point:SetOnClick( function()self.owner:PushEvent("SurplusDelta",{Delta = -1,order = "normal_1"})  end)	
	end
	--normal_2
	if self.owner and self.owner.components.skiller then
		self.normal_2 = self:AddChild(Widget("normal_2"))
		self.normal_2:SetPosition(80, 0,0)
		self.normal_2:SetScale(0.7,0.7,0.7)	
		--
		self.normal_2.anim = self.normal_2:AddChild(UIAnim())
		self.normal_2.anim:GetAnimState():SetBank("normal_cd")
		self.normal_2.anim:GetAnimState():SetBuild("normal_cd")
		self.normal_2.anim:GetAnimState():PlayAnimation("anim")
		--ֲ
		self.normal_2.lv = self.normal_2:AddChild(Text(BODYTEXTFONT, 40))
		self.normal_2.lv:SetHAlign(ANCHOR_MIDDLE)
		self.normal_2.lv:SetPosition(0, 0, 0)
		self.normal_2.lv:SetColour(0, 0.5, 0, 0.5)
		self.normal_2.lv:Hide()	
		
		--ƶʱ״̬
		self.normal_2.OnGainFocus = function()
			self:OnGainFocus(self)
			self.normal_2.lv:Show()
		end
		self.normal_2.OnLoseFocus = function()
			self:OnLoseFocus(self)
			self.normal_2.lv:Hide()	
		end
		--ӵйصİť	
		self.normal_2.point = self.normal_2:AddChild(ImageButton("images/skillpoint_button.xml", "skillpoint_button.tex", "skillpoint_button.tex", "skillpoint_button.tex"))
		self.normal_2.point:SetTooltip("A2")
		self.normal_2.point:SetPosition(50, 0, 0)
		self.normal_2.point:Hide()
		self.normal_2.point:SetOnClick( function() self.owner:PushEvent("SurplusDelta",{Delta = -1,order = "normal_2"})  end)	
	end	
	
	--normal_3
	if self.owner and self.owner.components.skiller then
		self.normal_3 = self:AddChild(Widget("normal_3"))
		self.normal_3:SetPosition(80, -40,0)
		self.normal_3:SetScale(0.7,0.7,0.7)	
		
		--
		self.normal_3.anim = self.normal_3:AddChild(UIAnim())
		self.normal_3.anim:GetAnimState():SetBank("normal_cd")
		self.normal_3.anim:GetAnimState():SetBuild("normal_cd")
		self.normal_3.anim:GetAnimState():PlayAnimation("anim")
		--ֲ
		self.normal_3.lv = self.normal_3:AddChild(Text(BODYTEXTFONT, 40))
		self.normal_3.lv:SetHAlign(ANCHOR_MIDDLE)
		self.normal_3.lv:SetPosition(0, 0, 0)	
		self.normal_3.lv:SetColour(0, 0.5, 0, 0.5)
		self.normal_3.lv:Hide()	
		--ƶʱ״̬
		self.normal_3.OnGainFocus = function()
			self:OnGainFocus(self)
			self.normal_3.lv:Show()
		end
		self.normal_3.OnLoseFocus = function()
			self:OnLoseFocus(self)
			self.normal_3.lv:Hide()	
		end
		
		--ӵйصİť	
		self.normal_3.point = self.normal_3:AddChild(ImageButton("images/skillpoint_button.xml", "skillpoint_button.tex", "skillpoint_button.tex", "skillpoint_button.tex"))
		self.normal_3.point:SetTooltip("A3")
		self.normal_3.point:SetPosition(50, 0, 0)
		
		self.normal_3.point:SetOnClick( function() self.owner:PushEvent("SurplusDelta",{Delta = -1,order = "normal_3"}) end)	
		self.normal_3.point:Hide()	
	end	

	--
	local function AddPoint(self,Valid)
		for k,v in pairs(Valid) do
			if Valid[k] ==true then
				self[k].point:Show()
			else
				self[k].point:Hide()
			end
		end
	end	
	function self:OnUIAddPoint(owner,data)
		if data and data.Valid then
			local Valid = data.Valid
			AddPoint(self,Valid)
		end
	end		
	self.OnUIAddPointFn = function(owner,data) self:OnUIAddPoint(owner,data) end
	self.owner:ListenForEvent("UIAddPoint", self.OnUIAddPointFn)
	self.owner:PushEvent("SurplusDelta",{Delta = 0})--һΪ˳ʼͶ󴥷ӵ㰴ťʾ
	
	--ʾȼ;	
	if self.owner.components and self.owner.components.leveler then
		self.level = self:AddChild(Widget("level"))
		self.level.lv = self.level:AddChild(Text(BODYTEXTFONT, 40))
		self.level.lv:SetHAlign(ANCHOR_MIDDLE)
		self.level.lv:SetPosition(0, 145, 0)
		self.level.exp = self.level:AddChild(Text(BODYTEXTFONT, 25))
		self.level.exp:SetHAlign(ANCHOR_MIDDLE)
		self.level.exp:SetPosition(0,120, 0)
	end
	--ʼ
	self:OnUpdate(0)
	self:StartUpdating()
	--UI϶
	self.passive.OnControl = function (self,control, down)
		self:GetParent():Passive_OnControl(control, down) 
	end
end)
function RPG_State:OnGainFocus()
    RPG_State._base.OnGainFocus(self)
end

function RPG_State:OnLoseFocus()
    RPG_State._base.OnLoseFocus(self)
end
function RPG_State:Passive_OnControl(control, down)
	if control == CONTROL_ACCEPT then
		if down then
			self:StartDrag()
		else
			self:EndDrag()
		end
	end
end

function RPG_State:SetDragPosition(x, y, z)

	local pos
	if type(x) == "number" then
		pos = Vector3(x, y, z)
	else
		pos = x
	end
	self:SetPosition(pos + self.dragPosDiff)
end

function RPG_State:StartDrag()
	-- based on Widget:FollowMouse()
	if not self.followhandler then
		local mousepos = TheInput:GetScreenPosition()
		self.dragPosDiff = self:GetPosition() - mousepos
		self.followhandler = TheInput:AddMoveHandler(function(x,y) self:SetDragPosition(x,y) end)
		self:SetDragPosition(mousepos)
	end
end

function RPG_State:EndDrag()
	-- based on Widget:StopFollowMouse()
	if self.followhandler then
		self.followhandler:Remove()
	end
	self.followhandler = nil
	self.dragPosDiff = nil
end

function RPG_State:Scale_DoDelta(delta)
	self.scale = math.max(self.scale+delta,0.1)
	self:SetScale(self.scale,self.scale,self.scale)
end

function RPG_State:OnUpdate(dt)
	local owner = self.owner
	local leveler = owner.components.leveler
	local skiller = owner.components.skiller
	---EXP
	self.level.lv.num = owner.components.leveler:GetLevel("kill")
	self.level.lv:SetString("Lv:"..tostring(self.level.lv.num))	
	self.level.exp.cur = owner.components.leveler:GetExp("kill")
	self.level.exp.max = owner.components.leveler:GetLevelMaxExp("kill",self.level.lv.num)
	self.level.exp:SetString(string.format("EXP:%d/%d",self.level.exp.cur,self.level.exp.max))	
	---CD͵ȼ
	local tag
	if	owner:HasTag("plant") then
		tag = "plant"
	elseif owner:HasTag("flower") then
		tag = "flower"
	end
	local Cd = {
	passive = 1000,
	normal_1 = skiller:GetCd(tag,"normal_1"),
	normal_2 = skiller:GetCd(tag,"normal_2"),
	normal_3 = skiller:GetCd("plant","normal_3"),
	ultimate = skiller:GetCd(tag,"ultimate"),
	}
	local CdDuration = {
	passive = skiller:GetBuffData("lotus_bless").layer,
	normal_1 = skiller:GetCdDuration(tag,"normal_1"),
	normal_2 = skiller:GetCdDuration(tag,"normal_2"),
	normal_3 = skiller:GetCdDuration("plant","normal_3"),
	ultimate = skiller:GetCdDuration(tag,"ultimate"),
	}
	local lv = {
	}
	for order,cdduration in pairs(CdDuration) do
		local np = order == "passive" and 1-cdduration/Cd[order] or cdduration/Cd[order]
		animSetPercent(self[order],np,cdduration)
		self[order].lv.num =  skiller:GetLevel(order)
		self[order].lv:SetString("Lv:"..self[order].lv.num)		
		if order == "ultimate" then
			refresh(self[order],true)
		end
		if order == "passive" then
			self.passive.CdDuration:SetString(STRINGS.RPG_STATE.PASSIVE..cdduration)
		end
	end
	--BUFFף仯
	
end
return RPG_State

