local Widget = require "widgets/widget"
local BuffSlot = require "widgets/buffslot"
local W = 64
local SEP = 12
local YSEP = 8
local INTERSEP = 28
local BUFF_ATLAS = "images/HUD/BuffUI.xml"
local BuffBar = Class(Widget, function(self, owner)
	Widget._ctor(self, "BuffBar")
	self.owner = owner
	self.skiller = owner.components.skiller
	self.root = self:AddChild(Widget("root"))
	self.buffinv = {}
	self.base_scale = .6
	self.selected_scale = .8
    self:SetScale(self.base_scale)
    self:SetPosition(100,0,0)

	self.in_pos = Vector3(0,160,0)	
	self.root:SetPosition(self.in_pos)
	self:StartUpdating()
end)
function BuffBar:OnUpdate(dt)
	if self.toprow then
		self.toprow:Kill()
	end
	self.toprow = self.root:AddChild(Widget("toprow"))
	
	local k = 0
    local num_slots = self.owner.components.inventory:GetNumSlots()
    local num_equip = 4
    local num_intersep = math.floor(num_slots / 5) + 1 
    local total_w = (num_slots + num_equip)*(W) + (num_slots + num_equip - 2 - num_intersep) *(SEP) + INTERSEP*num_intersep	
	for name,value in pairs(self.skiller.buff) do
		if self.skiller:IsActivated(name) then
			k = k +1
			local interseps = math.floor((k-1) / 5)
			local x = -total_w/2 + W/2 + interseps*(INTERSEP - SEP) + (k-1)*W + (k-1)*SEP
			local slot = BuffSlot(BUFF_ATLAS, name, self.owner)
			self.buffinv[name] = self.toprow:AddChild(slot)
			self.buffinv[name]:SetPosition(x,0,0)
			local buffdata = self.skiller:GetBuffData(name)
			if buffdata and buffdata.layer then
				self.buffinv[name]:SetText(buffdata.layer)
			end
		end
	end

end






return BuffBar