local Widget = require "widgets/widget"
local UIAnim = require "widgets/uianim"
local Text = require "widgets/text"
local Coordinates = Class(Widget, function(self)
	Widget._ctor(self, "Coordinates")
	self.owner = GetPlayer()
	
	self.bg = self:AddChild(UIAnim())
	self.bg:GetAnimState():SetBank("compass_bg")
    self.bg:GetAnimState():SetBuild("compass_bg")
    self.bg:GetAnimState():PlayAnimation("idle")

    self.needle = self:AddChild(UIAnim())
    self.needle:GetAnimState():SetBank("compass_needle")
    self.needle:GetAnimState():SetBuild("compass_needle")
    self.needle:GetAnimState():PlayAnimation("idle", true)

    self.displayheading = 0
    self.currentheading = 0
    self.offsetheading = 0
    self.forceperdegree = 0.005
    self.headingvel = 0
    self.damping = 0.98
    self.easein = 0
	
    self.needle:Show()
    self:StartUpdating()
	self.text = self:AddChild(Text(BODYTEXTFONT, 25))
	self.text:SetPosition(0,-60,0)
	self:OnUpdate()
    self:StartUpdating()
end)

local function NormalizeHeading(heading)
    while heading < -180 do heading = heading + 360 end
    while heading > 180 do heading = heading -360 end
    return heading
end

local function EaseHeading(heading0, heading1, k)
    local delta = NormalizeHeading(heading1 - heading0)
    return NormalizeHeading(heading0 + math.clamp(delta * k, -20, 20))
end

function Coordinates:GetCompassHeading()
    return TheCamera ~= nil and (TheCamera:GetHeading() - 270) or 0
end
local function coorToString(x,y)
	local NS = string.format("%4.1f ",math.abs(y))
	local NS_direction = y> 0 and "N  " or "S  "
	local EW = string.format("%4.1f",math.abs(x))
	local EW_direction = x> 0 and "E  " or "W  "
	local coorstr = NS_direction..NS.."  "..EW_direction..EW
	return  coorstr 
end
function Coordinates:OnUpdate(dt)
    local delta = NormalizeHeading(self:GetCompassHeading() - self.currentheading)

    self.headingvel = self.headingvel + delta * self.forceperdegree
    self.headingvel = self.headingvel * self.damping
    self.currentheading = NormalizeHeading(self.currentheading + self.headingvel)

    local t = GetTime()

    -- Offsets from sanity
    local sanity = self.owner.components.sanity
    local sanity_t = math.clamp(sanity:GetPercent(true) * 3, 0, 1)
    local sanity_offset = math.sin(t*0.2) * Lerp(720, 0, sanity_t)

    -- Offset from full moon
    local fullmoon_t =  0
    local fullmoon_offset = math.sin(t*0.8) * Lerp(0, 720, fullmoon_t)

    -- Offset from wobble
    local wobble_offset = math.sin(t*2)*5

    self.offsetheading = EaseHeading(self.offsetheading, wobble_offset + fullmoon_offset + sanity_offset, .5)

    self.easein = 1
    self.displayheading = EaseHeading(self.displayheading, self.currentheading + self.offsetheading, self.easein)
    self.needle:SetRotation(self.displayheading)
	
	local x,z,y = self.owner.Transform:GetWorldPosition()
	self.text:SetString(coorToString(x,y)) 
	
end


function Coordinates:OnControl(control, down)
	if control == CONTROL_ACCEPT then
		
		if down then
			self:StartDrag()
		else
			self:EndDrag()
		end
		return true
	end
	return Coordinates._base.OnControl(self, control, down)
end

function Coordinates:SetDragPosition(x, y, z)
	local pos
	if type(x) == "number" then
		pos = Vector3(x, y, z)
	else
		pos = x
	end
	self:SetPosition(pos + self.dragPosDiff)
end

function Coordinates:StartDrag()
	if not self.followhandler then
		local mousepos = TheInput:GetScreenPosition()
		self.dragPosDiff = self:GetPosition() - mousepos
		self.followhandler = TheInput:AddMoveHandler(function(x,y) self:SetDragPosition(x,y) end)
		self:SetDragPosition(mousepos)
	end
end

function Coordinates:EndDrag()
	if self.followhandler then
		self.followhandler:Remove()
	end
	self.followhandler = nil
	self.dragPosDiff = nil
end



return Coordinates
