local assets=
{
	Asset("ANIM", "anim/coconutmilk.zip"),
	Asset("ATLAS", "images/inventoryimages/coconutmilk.xml"),  
	Asset("IMAGE", "images/inventoryimages/coconutmilk.tex"),	
}

local prefabs = {"spoiled_food",}

local function oneaten(inst, eater)	
	if eater and eater.components.temperature then
		local temp = eater.components.temperature:GetCurrent()
		eater.components.temperature:SetTemperature(temp-7)
	end	
end

--[[local function onfinished(inst)
    --inst:RemoveComponent("inventoryitem")    
    inst:Remove()
end]]

local function MakeCoconutMilk()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	--local s  = 0.5
    --inst.Transform:SetScale(s,s,s)
	inst.entity:AddAnimState()
	--inst.entity:AddSoundEmitter()
	inst.entity:AddNetwork()
	MakeInventoryPhysics(inst)
	
	inst.AnimState:SetBank("coconutmilk")
    inst.AnimState:SetBuild("coconutmilk")


    inst.AnimState:PlayAnimation("idle")
	--inst:AddTag("preparedfood")
	--inst:AddTag("coconutmilk")
	--inst:AddTag("tool")
	
	if not TheWorld.ismastersim then
        return inst
    end

    inst.entity:SetPristine()
	
	inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

     inst:AddComponent("edible")
    inst.components.edible.healthvalue = 0
    inst.components.edible.hungervalue = 2
    inst.components.edible.sanityvalue = -(3*TUNING.SANITY_SUPERTINY)
    inst.components.edible.temperaturedelta = TUNING.COLD_FOOD_BONUS_TEMP
    inst.components.edible.temperatureduration = TUNING.FOOD_TEMP_BRIEF * 4
    --inst.components.edible:SetOnEatenFn(oneaten)
    inst.components.edible.foodtype = "VEGGIE"

	--inst:AddComponent("instrument")
    --inst.components.instrument.onplayed = OnPlayed

	--[[inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.PLAY)

    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(5)
    inst.components.finiteuses:SetUses(5)
    inst.components.finiteuses:SetOnFinished( onfinished)
    inst.components.finiteuses:SetConsumption(ACTIONS.PLAY, 1)]]

	inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime(TUNING.PERISH_PRESERVED)
    inst.components.perishable:StartPerishing()
    inst.components.perishable.onperishreplacement = "spoiled_food"

	inst:AddComponent("inspectable")
	inst:AddComponent("inventoryitem")	
	inst.components.inventoryitem.imagename = "coconutmilk"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/coconutmilk.xml"
		
	return inst
end

STRINGS.NAMES.COCONUTMILK = "冰椰子"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.COCONUTMILK = {   
    "啊哈哈哈哈，寒冷的点心",
    "胜过吃冰",
}


return Prefab( "common/inventory/coconutmilk", MakeCoconutMilk, assets)