local assets=
{ 
    Asset("ANIM", "anim/hat_bee_bw.zip"),
    Asset("ANIM", "anim/hat_bee_bw_swap.zip"), 

    Asset("ATLAS", "images/inventoryimages/hat_bee_bw.xml"),
    Asset("IMAGE", "images/inventoryimages/hat_bee_bw.tex"),
}

local prefabs = 
{
}

local function fn()

    local function OnEquip(inst, owner) 
        owner.AnimState:OverrideSymbol("swap_hat", "hat_bee_bw_swap", "swap_hat")
        owner.AnimState:Show("HAT")
        owner.AnimState:Show("HAT_HAIR")
        owner.AnimState:Hide("HAIR_NOHAT")
        owner.AnimState:Hide("HAIR")
        
        if owner:HasTag("player") then
            
            owner.AnimState:Hide("HEAD")
            owner.AnimState:Show("HEAD_HAT")
        end
    end

    local function OnUnequip(inst, owner) 
        owner.AnimState:Hide("HAT")
        owner.AnimState:Hide("HAT_HAIR")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")

        if owner:HasTag("player") then
            owner.AnimState:Show("HEAD")
            owner.AnimState:Hide("HEAD_HAT")
        end
    end

    local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
    MakeInventoryPhysics(inst)
    
     inst.AnimState:SetBank("hat_bee_bw")
    inst.AnimState:SetBuild("hat_bee_bw")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("show_spoilage")

    if not TheWorld.ismastersim then
            return inst
    end

    inst.entity:SetPristine()

    inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime(TUNING.PERISH_MED)
    inst.components.perishable:StartPerishing()
    inst.components.perishable.onperishreplacement = "spoiled_food"

    inst:AddComponent("armor")
    inst.components.armor:InitCondition(TUNING.WILSON_HEALTH*9999, TUNING.ARMOR_FOOTBALLHAT_ABSORPTION)

    inst:AddComponent("waterproofer")
    inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_SMALL)
        
    

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "hat_bee_bw"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/hat_bee_bw.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
    inst.components.equippable:SetOnEquip(OnEquip)
    inst.components.equippable:SetOnUnequip(OnUnequip)

    return inst
end

return  Prefab("common/inventory/hat_bee_bw", fn, assets, prefabs)