﻿----------------------------------------------------------------------------
----Author: ViperGTS96------------------------------------------------------
----------------------------------------------------------------------------
--------------------"The simplest design is the best design." --------------
----------------------------------------------------------------------------

StoreDeliveries = {};
StoreDeliveries.dir = g_currentModDirectory;
StoreDeliveries.ringFile = StoreDeliveries.dir.."ringSelector.i3d";
StoreDeliveries.textBG = createImageOverlay(StoreDeliveries.dir.."textbg.dds");
local modDescFile = loadXMLFile("modDesc", StoreDeliveries.dir.."modDesc.xml");
StoreDeliveries.title = getXMLString(modDescFile, "modDesc.title.en");
StoreDeliveries.author = getXMLString(modDescFile, "modDesc.author");
StoreDeliveries.version = getXMLString(modDescFile, "modDesc.version");
StoreDeliveries.setSpotSnd = createSample("setLocationSound");
StoreDeliveries.deliverySnd = createSample("deliverySound");
loadSample(StoreDeliveries.setSpotSnd, StoreDeliveries.dir.."sounds/setLocation.ogg", false);
loadSample(StoreDeliveries.deliverySnd, StoreDeliveries.dir.."sounds/purchase.ogg", false);
setSamplePitch(StoreDeliveries.setSpotSnd, 1.3);
setSamplePitch(StoreDeliveries.deliverySnd, 1.0);
StoreDeliveries.storedLocation = {};
StoreDeliveries.storedDirection = {};
StoreDeliveries.storedPerpDirection = {};
StoreDeliveries.storedRotation = {};
StoreDeliveries.ringColor = {1,0.3,0,1,false};--r,g,b,?,_
StoreDeliveries.btnDown = false;
StoreDeliveries.chargeForAnimals = false; -- Delivery charge for animals? -untested (is player at animal store for pickup?)
StoreDeliveries.money = {};
StoreDeliveries.money.text = "";
StoreDeliveries.money.render = false;
StoreDeliveries.money.renderTime = 0;
StoreDeliveries.money.renderDuration = 300;
StoreDeliveries.money.delivery = {};
StoreDeliveries.money.delivery.charge = 0;
StoreDeliveries.money.delivery.totalCharges = 0;
StoreDeliveries.money.delivery.wasCharged = false;
StoreDeliveries.money.delivery.rate = 0.025; --[%]
StoreDeliveries.money.rateString = "2.5"--string.sub(tostring(StoreDeliveries.money.delivery.rate *100),1,3);
StoreDeliveries.money.delivery.maxCharge = 5000.0; -- $
StoreDeliveries.isLoaded = false;
addModEventListener(StoreDeliveries);
delete(modDescFile);

function StoreDeliveries:loadMap(savegame)
	
	g_currentMission.storeDeliveries = {};	
	g_currentMission.storeDeliveries.selectionRing = loadI3DFile(StoreDeliveries.ringFile, false, false, false);
	g_currentMission.storeDeliveries.selectionRing = getChildAt(g_currentMission.storeDeliveries.selectionRing, 0);
	link(getRootNode(), g_currentMission.storeDeliveries.selectionRing);
	setVisibility(g_currentMission.storeDeliveries.selectionRing, false);
    setShaderParameter(getChildAt(g_currentMission.storeDeliveries.selectionRing,0), "colorScale", unpack(StoreDeliveries.ringColor));
	setOverlayColor(StoreDeliveries.textBG, 0.0, 0.0, 0.0, 0.5);
	--for i, _ in pairs(storePlace) do print(i); end;	--*Note* There is more than 1 Store Delivery Location, only the first one is being modified.
	local storePlace = g_currentMission.storeSpawnPlaces[1];
	StoreDeliveries.storedLocation = {storePlace.startX, storePlace.startY, storePlace.startZ};
	StoreDeliveries.storedRotation = {storePlace.rotX, storePlace.rotY, storePlace.rotZ};
	StoreDeliveries.storedDirection = {storePlace.dirX, storePlace.dirY, storePlace.dirZ};
	StoreDeliveries.storedPerpDirection = {storePlace.dirPerpX, storePlace.dirPerpY, storePlace.dirPerpZ};
	FSBaseMission.saveSavegame = Utils.appendedFunction(FSBaseMission.saveSavegame, StoreDeliveries.saveSettings);
	FarmStats.changeFinanceStats = Utils.appendedFunction(FarmStats.changeFinanceStats, StoreDeliveries.changeFinanceStats);
	local settingsLoaded = StoreDeliveries:loadSettings();
	local settingsLoadedString = "";
	if settingsLoaded then settingsLoadedString = " : Custom 'Store Location' loaded" end;
	print("Load mod: "..StoreDeliveries.title.." : v"..StoreDeliveries.version.." by "..StoreDeliveries.author..settingsLoadedString);

end;

function StoreDeliveries:loadMapFinished()	
end;

function StoreDeliveries:moneyListener()
	if StoreDeliveries.isLoaded then 
	-----------------------------------------While in Menu --------------------------------------------------------
		--[[if g_gui:getIsGuiVisible() then
			if StoreDeliveries.money.deductionPossible == 1 and string.upper(tostring(FocusManager.currentGui)) == "YESNODIALOG" then
				local farm = g_farmManager:getFarmById(g_currentMission.player.farmId);
				StoreDeliveries.money.priorDeduction = farm.money; --Get money before purchase
				StoreDeliveries.money.deductionPossible = 2;
			elseif StoreDeliveries.money.deductionPossible >= 2 and 
			(string.upper(tostring(FocusManager.currentGui)) == "MESSAGEDIALOG" or 
			string.upper(tostring(FocusManager.currentGui)) == "INFODIALOG") then
				local farm = g_farmManager:getFarmById(g_currentMission.player.farmId);
				if farm.money < StoreDeliveries.money.priorDeduction then--(if Money After Purchase < Money Before Purchase then)
					local moneySpent = StoreDeliveries.money.priorDeduction - farm.money;
					local deliveryCost = moneySpent * StoreDeliveries.money.rate; --print("$"..deliveryCost); -- Delivery Price per purchase
					StoreDeliveries.money.delivery.totalCharges = StoreDeliveries.money.delivery.totalCharges + deliveryCost; -- Delivery Price per all purchases (for notification message)
					g_currentMission:addMoney(-deliveryCost, 1, MoneyType.VEHICLE_RUNNING_COSTS);
					StoreDeliveries.money.deductionPossible = 0;
				end;
			else
				if string.upper(tostring(FocusManager.currentGui)) == "SHOPCONFIGSCREEN" then --Begin watch for purchase
					if StoreDeliveries.money.deductionPossible <= 0 then
						StoreDeliveries.money.deductionPossible = 1;
						--render icon				
					end;
				elseif StoreDeliveries.money.deductionPossible > 0 then
					if string.upper(tostring(FocusManager.currentGui)) ~= "YESNODIALOG" and 
					string.upper(tostring(FocusManager.currentGui)) == "MESSAGEDIALOG" and 
					string.upper(tostring(FocusManager.currentGui)) == "INFODIALOG" then
						StoreDeliveries.money.deductionPossible = 0; 
					end;
				end;
			end;
		end;]]
		if StoreDeliveries.money.delivery.wasCharged then --g_gui:getIsGuiVisible() and 
			StoreDeliveries.money.delivery.wasCharged = false;
			g_currentMission:addMoney(-StoreDeliveries.money.delivery.charge, 1, MoneyType.VEHICLE_RUNNING_COSTS);
			StoreDeliveries.money.delivery.charge = 0;
			playSample(StoreDeliveries.deliverySnd,1,0.6,0,0,0);
		end;
	--------------------------------------Post Menu Notification---------------------------------------------------
		if StoreDeliveries.money.delivery.totalCharges > 0 then
			if not g_gui:getIsGuiVisible() then
				StoreDeliveries.money.text = g_i18n:formatMoney(StoreDeliveries.money.delivery.totalCharges, 0, false, true);
				StoreDeliveries.money.renderTime = StoreDeliveries.money.renderDuration;
				StoreDeliveries.money.render = true;
				StoreDeliveries.money.delivery.totalCharges = 0;
				StoreDeliveries.money.priorDeduction = 0;
				--local sideNotifiyer = SideNotification.new(g_currentMission.hudAtlasPath);
				--sideNotifiyer:addNotification(StoreDeliveries.money.text, {1,0.3,0,1}, 20);
			end;
		end;
	
		if StoreDeliveries.money.render then
			if StoreDeliveries.money.renderTime > 0 then
				StoreDeliveries.money.renderTime = StoreDeliveries.money.renderTime - 1;
			else
				StoreDeliveries.money.render = false;
			end;
		end;
	---------------------------------------------------------------------------------------------------------------
	end;
end;

function StoreDeliveries:alignMarkerToGround(node)
    local x1,y1,z1 = localToWorld(node,0,0,5);
    local x2,y2,z2 = localToWorld(node,0,0,-5);
    local x3,y3,z3 = localToWorld(node,5,0,0);
    local x4,y4,z4 = localToWorld(node,-5,0,0);
    y1 = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x1,y1,z1);
    y2 = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x2,y2,z2);
    y3 = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x3,y3,z3);
    y4 = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x4,y4,z4);
    local dirX = x2 - x1;
    local dirY = y2 - y1;
    local dirZ = z2 - z1;
    local dir2X = x3 - x4;
    local dir2Y = y3 - y4;
    local dir2Z = z3 - z4;
    local upX,upY,upZ = MathUtil.crossProduct(dir2X, dir2Y, dir2Z, dirX, dirY, dirZ);
    setDirection(getChildAt(node,0), dirX, dirY, dirZ, upX,upY,upZ);
end;

function StoreDeliveries:updater()
	local inputOff = false;
	if Input.isKeyPressed(Input.KEY_lshift) then
		if Input.isKeyPressed(Input.KEY_lalt) then	
			local cam = getCamera();
			local sRing = g_currentMission.storeDeliveries.selectionRing;
			--local x,y,z = getWorldTranslation(g_currentMission.player.rootNode);
			local x,y,z = localToWorld(cam,0,0,-10);
			y = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x,y,z);
			setWorldTranslation(sRing, x,y+0.15,z);
			StoreDeliveries:alignMarkerToGround(sRing);
			if not getVisibility(sRing) then setVisibility(sRing, true); end;
			if Input.isKeyPressed(Input.KEY_s) and not StoreDeliveries.btnDown then
				local storePlace = g_currentMission.storeSpawnPlaces[1];
				--local x2,_,z2 = localToWorld(g_currentMission.player.rootNode,-10,0,0);
				--local x3,_,z3 = localToWorld(g_currentMission.player.rootNode,10,0,0);
				local dx,_,dz = localDirectionToWorld(cam,0,0,1);-- y is always 0?
				--local dx2,dy2,dz2 = localDirectionToWorld(cam,0,1,0); -- use as Perp to 180 the location
				local rx,ry,rz = getWorldRotation(cam);
				storePlace.startX, storePlace.startY, storePlace.startZ = x,y,z;
				storePlace.rotX, storePlace.rotY, storePlace.rotZ = rx,ry,rz;
				storePlace.dirX, storePlace.dirY, storePlace.dirZ = dz,0,-dx;--x&z are mirrored
				storePlace.dirPerpX, storePlace.dirPerpY, storePlace.dirPerpZ = dx,0,dz;--dx2,dy2,dz2;
				--storePlace = g_currentMission.storeSpawnPlaces[2];
				--storePlace.startX, storePlace.startY, storePlace.startZ = x2,y,z2;
				--storePlace = g_currentMission.storeSpawnPlaces[3];
				--storePlace.startX, storePlace.startY, storePlace.startZ = x3,y,z3;
				StoreDeliveries.btnDown = true;			
				setVisibility(sRing, false);
				StoreDeliveries.isLoaded = true;
				playSample(StoreDeliveries.setSpotSnd,1,0.6,0,0,0);
			elseif Input.isKeyPressed(Input.KEY_r) then		
				local storePlace = g_currentMission.storeSpawnPlaces[1];
				storePlace.startX, storePlace.startY, storePlace.startZ = unpack(StoreDeliveries.storedLocation);
				storePlace.rotX, storePlace.rotY, storePlace.rotZ = unpack(StoreDeliveries.storedRotation);
				storePlace.dirX, storePlace.dirY, storePlace.dirZ = unpack(StoreDeliveries.storedDirection);
				storePlace.dirPerpX, storePlace.dirPerpY, storePlace.dirPerpZ = unpack(StoreDeliveries.storedPerpDirection);
				--storePlace = g_currentMission.storeSpawnPlaces[2];
				--storePlace.startX, storePlace.startY, storePlace.startZ = unpack(StoreDeliveries.storedLocation);
				--storePlace = g_currentMission.storeSpawnPlaces[3];
				--storePlace.startX, storePlace.startY, storePlace.startZ = unpack(StoreDeliveries.storedLocation);
				StoreDeliveries.btnDown = true;
				setVisibility(sRing, false);				
				StoreDeliveries.isLoaded = false;
			end;
		else
			inputOff = true;
		end;
	else
		inputOff = true;
	end;

	if inputOff then
		if getVisibility(g_currentMission.storeDeliveries.selectionRing) then
			setVisibility(g_currentMission.storeDeliveries.selectionRing, false);
			setWorldTranslation(g_currentMission.storeDeliveries.selectionRing, 0,0,0);
		end;
		if StoreDeliveries.btnDown then			
			StoreDeliveries.btnDown = false;
		end;
	end;

end;

function StoreDeliveries:changeFinanceStats(amount, statType)
	if StoreDeliveries.isLoaded and g_gui:getIsGuiVisible() then 
		local itemPurchase = false;
		local other = false;
		if statType ~= nil then
			local SD_Money = StoreDeliveries.money.delivery;
			--[[if statType ~= "playTime" or statType ~= "sownTime" or statType ~= "workTime" or statType ~= "distanceTraveled" then 
				print(statType..": "..amount);
			end;]]			
			for _, statTypeName in pairs({"other","purchaseSeeds","purchaseFertilizer","purchaseSaplings"}) do
				if statTypeName == statType then 
					itemPurchase = true;
					if statType == "other" then
						other = true;
					end;
					break;
				end;
			end;
			if not StoreDeliveries.chargeForAnimals then
				if itemPurchase and other then
					if string.upper(tostring(FocusManager.currentGui)) == "ANIMALSCREEN" then
						itemPurchase = false;
					end;
				end;
			end;
			if (amount*-1.0) > 25.0 then
				if statType == "newVehiclesCost" or itemPurchase then
					local netCost = (amount*-1.0)*SD_Money.rate;
					if netCost > SD_Money.maxCharge then netCost = SD_Money.maxCharge; end;
					SD_Money.charge = netCost;
					SD_Money.totalCharges = SD_Money.totalCharges + SD_Money.charge;
					SD_Money.wasCharged = true;
				end;
			end;
		end;
	end;
end;

function StoreDeliveries:draw()
	if StoreDeliveries.isLoaded then
		if StoreDeliveries.money.render then
			local uiScale = g_gameSettings:getValue("uiScale");
			local textSize = 0.02*uiScale;
			local bgW = textSize*8;
			local rateString = StoreDeliveries.money.rateString;
			renderOverlay(StoreDeliveries.textBG, 0.986-(bgW-(textSize/2)), 0.875-(textSize/1.8), bgW, textSize*2);
			setTextBold(false);
			setTextAlignment(RenderText.ALIGN_RIGHT);
			-----------------------Start Shadow-------------------------------------------
			local offset = textSize * HUDTextDisplay.SHADOW_OFFSET_FACTOR;
			setTextColor(0,0,0,1);
			renderText(0.986 + offset, 0.875 - offset, textSize, "Delivery Costs ("..rateString.."%) : $"..StoreDeliveries.money.text);
			------------------------------------------------------------------------------
			setTextColor(1,0.25,0,1);
			renderText(0.986, 0.875, textSize, "Delivery Costs ("..rateString.."%) : $"..StoreDeliveries.money.text);
		end;
		--[[if StoreDeliveries.money.renderStore then	
			local uiScale = g_gameSettings:getValue("uiScale");
			local iconW = 0.093*uiScale;
			local iconH = iconW*g_screenAspectRatio;
			renderOverlay(StoreDeliveries.iconBG, 0.75-iconW, 0.985-iconH, iconW, iconH);
		end;]]
	end;
end;

function StoreDeliveries:update(dt)
	StoreDeliveries:updater();
	StoreDeliveries:moneyListener();
end;

function StoreDeliveries:deleteMap(savegame)
	StoreDeliveries.storedLocation = {};
	StoreDeliveries.storedRotation = {};
	StoreDeliveries.storedDirection = {};
	StoreDeliveries.storedPerpDirection = {};
	StoreDeliveries.money.text = "";
	StoreDeliveries.money.delivery.charge = 0;
	StoreDeliveries.money.delivery.totalCharges = 0;
	StoreDeliveries.money.renderTime = 0;
	StoreDeliveries.money.render = false;
	StoreDeliveries.isLoaded = false;
	StoreDeliveries.btnDown = false;	
	StoreDeliveries.money.delivery.wasCharged = false;

end;

function StoreDeliveries:saveSettings()

	local savegameFolderPath = g_currentMission.missionInfo.savegameDirectory.."/";
	if savegameFolderPath == nil then
		savegameFolderPath = ('%ssavegame%d'):format(getUserProfileAppPath(), g_currentMission.missionInfo.savegameIndex.."/");
	end;
	local key = "storeDeliveries";
	local storePlace = g_currentMission.storeSpawnPlaces[1];
	local xmlFile = createXMLFile(key, savegameFolderPath.."storeDeliveries.xml", key);
	setXMLBool(xmlFile, key.."#isLoaded", StoreDeliveries.isLoaded);
	setXMLFloat(xmlFile, key..".storeLocation#x", storePlace.startX);
	setXMLFloat(xmlFile, key..".storeLocation#y", storePlace.startY);
	setXMLFloat(xmlFile, key..".storeLocation#z", storePlace.startZ);
	setXMLFloat(xmlFile, key..".storeRotation#x", storePlace.rotX);
	setXMLFloat(xmlFile, key..".storeRotation#y", storePlace.rotY);
	setXMLFloat(xmlFile, key..".storeRotation#z", storePlace.rotZ);
	setXMLFloat(xmlFile, key..".storeDirection#x", storePlace.dirX);
	setXMLFloat(xmlFile, key..".storeDirection#y", storePlace.dirY);
	setXMLFloat(xmlFile, key..".storeDirection#z", storePlace.dirZ);
	setXMLFloat(xmlFile, key..".storePerpDirection#x", storePlace.dirPerpX);
	setXMLFloat(xmlFile, key..".storePerpDirection#y", storePlace.dirPerpY);
	setXMLFloat(xmlFile, key..".storePerpDirection#z", storePlace.dirPerpZ);
	saveXMLFile(xmlFile);

	delete(xmlFile);

end;

function StoreDeliveries:loadSettings()

	local savegameFolderPath = g_currentMission.missionInfo.savegameDirectory;
	if savegameFolderPath == nil then
		savegameFolderPath = ('%ssavegame%d'):format(getUserProfileAppPath(), g_currentMission.missionInfo.savegameIndex);
	end;
	savegameFolderPath = savegameFolderPath.."/"
	local key = "storeDeliveries";

	if fileExists(savegameFolderPath.."storeDeliveries.xml") then
		local xmlFile = loadXMLFile(key, savegameFolderPath.."storeDeliveries.xml");
		StoreDeliveries.isLoaded = getXMLBool(xmlFile, key.."#isLoaded");
		if StoreDeliveries.isLoaded then
			local storePlace = g_currentMission.storeSpawnPlaces[1];
			storePlace.startX = getXMLFloat(xmlFile, key..".storeLocation#x");
			storePlace.startY = getXMLFloat(xmlFile, key..".storeLocation#y");
			storePlace.startZ = getXMLFloat(xmlFile, key..".storeLocation#z");
			storePlace.rotX = getXMLFloat(xmlFile, key..".storeRotation#x");
			storePlace.rotY = getXMLFloat(xmlFile, key..".storeRotation#y");
			storePlace.rotZ = getXMLFloat(xmlFile, key..".storeRotation#z");
			storePlace.dirX = getXMLFloat(xmlFile, key..".storeDirection#x");
			storePlace.dirY = getXMLFloat(xmlFile, key..".storeDirection#y");
			storePlace.dirZ = getXMLFloat(xmlFile, key..".storeDirection#z");
			storePlace.dirPerpX = getXMLFloat(xmlFile, key..".storePerpDirection#x");
			storePlace.dirPerpY = getXMLFloat(xmlFile, key..".storePerpDirection#y");
			storePlace.dirPerpZ = getXMLFloat(xmlFile, key..".storePerpDirection#z");		
		end;
		delete(xmlFile);
	end;

	return StoreDeliveries.isLoaded;

end;