/*
 * Decompiled with CFR 0.152.
 */
package xyz.diabolicatrixlab.showcasemod.blocks;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xyz.diabolicatrixlab.showcasemod.mod.ShowcaseMod;
import xyz.diabolicatrixlab.showcasemod.proxies.CommonProxy;
import xyz.diabolicatrixlab.showcasemod.tileentities.BlockShowcaseTileEntity;

public class BlockShowcase
extends BlockContainer {
    public static final PropertyEnum MATERIAL = PropertyEnum.func_177709_a((String)"material", Material.class);

    public BlockShowcase(net.minecraft.block.material.Material material) {
        super(material);
        this.func_149752_b(-1.0f);
        this.func_149711_c(2.0f);
        this.func_149647_a(CommonProxy.showcaseModTab);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)MATERIAL, (Comparable)((Object)Material.QUARTZ)));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149686_d(IBlockState state) {
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new BlockShowcaseTileEntity();
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof BlockShowcaseTileEntity) {
            BlockShowcaseTileEntity inv = (BlockShowcaseTileEntity)tileentity;
            for (int i1 = 0; i1 < inv.func_70302_i_(); ++i1) {
                ItemStack itemstack = inv.func_70301_a(i1);
                if (itemstack == null) continue;
                float f = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f1 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int j1 = world.field_73012_v.nextInt(21) + 10;
                    if (j1 > itemstack.field_77994_a) {
                        j1 = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= j1;
                    EntityItem entityitem = new EntityItem(world, (double)((float)pos.func_177958_n() + f), (double)((float)pos.func_177956_o() + f1), (double)((float)pos.func_177952_p() + f2), new ItemStack(itemstack.func_77973_b(), j1, itemstack.func_77952_i()));
                    float f3 = 0.05f;
                    entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 0.2f;
                    entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d(itemstack.func_77978_p().func_74737_b());
                    }
                    world.func_72838_d((Entity)entityitem);
                }
            }
            world.func_175685_c(pos, state.func_177230_c());
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        playerIn.openGui((Object)ShowcaseMod.instance, 0, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!(placer instanceof EntityPlayer)) {
            return;
        }
        if (!(world.func_175625_s(pos) instanceof BlockShowcaseTileEntity)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)placer;
        BlockShowcaseTileEntity te = (BlockShowcaseTileEntity)world.func_175625_s(pos);
        te.owner = player.func_110124_au().toString();
        te.func_70296_d();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MATERIAL});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)MATERIAL, (Comparable)((Object)Material.getStateFromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((Material)((Object)state.func_177229_b((IProperty)MATERIAL))).getMetadata();
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < Material.values().length; ++i) {
            list.add(new ItemStack((Block)this, 1, Material.values()[i].getMetadata()));
        }
    }

    public static enum Material implements IStringSerializable
    {
        QUARTZ(0, "quartz", Item.func_150898_a((Block)Blocks.field_150371_ca)),
        COBBLESTONE(1, "cobblestone", Item.func_150898_a((Block)Blocks.field_150347_e)),
        GOLD(2, "gold", Item.func_150898_a((Block)Blocks.field_150340_R)),
        GRANITE(3, "granite", Item.func_150898_a((Block)Blocks.field_150348_b), 2),
        DIORITE(4, "diorite", Item.func_150898_a((Block)Blocks.field_150348_b), 4),
        ANDESITE(5, "andesite", Item.func_150898_a((Block)Blocks.field_150348_b), 6),
        OAK(6, "oak", Item.func_150898_a((Block)Blocks.field_150344_f)),
        SPRUCE(7, "spruce", Item.func_150898_a((Block)Blocks.field_150344_f), 1),
        BIRCH(8, "birch", Item.func_150898_a((Block)Blocks.field_150344_f), 2),
        JUNGLE(9, "jungle", Item.func_150898_a((Block)Blocks.field_150344_f), 3),
        ACACIA(10, "acacia", Item.func_150898_a((Block)Blocks.field_150344_f), 4),
        DARKOAK(11, "darkoak", Item.func_150898_a((Block)Blocks.field_150344_f), 5);

        private static final Material[] METADATA;
        private final String name;
        private final int metadata;
        private final Item item;
        private final int itemMetadata;

        private Material(int metadata, String name, Item item, int itemMetadata) {
            this.metadata = metadata;
            this.name = name;
            this.item = item;
            this.itemMetadata = itemMetadata;
        }

        private Material(int metadata, String name, Item item) {
            this.metadata = metadata;
            this.name = name;
            this.item = item;
            this.itemMetadata = 0;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getMetadata() {
            return this.metadata;
        }

        public int getItemMetadata() {
            return this.itemMetadata;
        }

        public Item getItem() {
            return this.item;
        }

        public String toString() {
            return this.name;
        }

        public static Material getStateFromMeta(int metadata) {
            if (metadata < 0 || metadata >= METADATA.length) {
                metadata = 0;
            }
            return METADATA[metadata];
        }

        static {
            METADATA = new Material[Material.values().length];
            Material[] var0 = Material.values();
            int var1 = var0.length;
            for (int var2 = 0; var2 < var1; ++var2) {
                Material var3;
                Material.METADATA[var3.getMetadata()] = var3 = var0[var2];
            }
        }
    }
}

