/*
 * Decompiled with CFR 0.152.
 */
package xyz.diabolicatrixlab.showcasemod.packets;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import xyz.diabolicatrixlab.showcasemod.mod.CoinUtils;
import xyz.diabolicatrixlab.showcasemod.tileentities.BlockShowcaseTileEntity;

public class PacketBuy
implements IMessage {
    private BlockPos pos;
    private int amount;

    public PacketBuy() {
    }

    public PacketBuy(int amount, BlockPos pos) {
        this.amount = amount;
        this.pos = pos;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.amount = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.amount);
    }

    public static class Handler
    implements IMessageHandler<PacketBuy, IMessage> {
        public IMessage onMessage(PacketBuy message, MessageContext ctx) {
            TileEntity te = ctx.getServerHandler().field_147369_b.field_70170_p.func_175625_s(message.pos);
            if (te instanceof BlockShowcaseTileEntity) {
                int currencyMultiplier;
                BlockShowcaseTileEntity tile = (BlockShowcaseTileEntity)te;
                int n = tile.currency == 0 ? 1 : (currencyMultiplier = tile.currency == 1 ? 4 : 16);
                if (tile.adminshop) {
                    if (tile.item == null) {
                        return null;
                    }
                    if (CoinUtils.buy((EntityPlayer)ctx.getServerHandler().field_147369_b, tile.unitPrice * currencyMultiplier * message.amount, tile.getContent()[0].func_77946_l())) {
                        TextComponentTranslation s = new TextComponentTranslation("showcasemod.success", new Object[]{"" + message.amount + tile.item.func_92059_d().func_82833_r()});
                        s.func_150256_b().func_150238_a(TextFormatting.GREEN);
                        ctx.getServerHandler().field_147369_b.func_146105_b((ITextComponent)s);
                    } else {
                        TextComponentTranslation s = new TextComponentTranslation("showcasemod.nem", new Object[0]);
                        s.func_150256_b().func_150238_a(TextFormatting.RED);
                        ctx.getServerHandler().field_147369_b.func_146105_b((ITextComponent)s);
                    }
                } else {
                    if (tile.item == null) {
                        return null;
                    }
                    Item item = tile.item.func_92059_d().func_77973_b();
                    int itemCount = 0;
                    for (int i = 1; i < tile.func_70302_i_(); ++i) {
                        if (tile.func_70301_a(i) == null || tile.func_70301_a(i).func_77973_b() != item) continue;
                        itemCount += tile.func_70301_a((int)i).field_77994_a;
                    }
                    if (itemCount >= message.amount) {
                        if (CoinUtils.buy((EntityPlayer)ctx.getServerHandler().field_147369_b, tile.unitPrice * currencyMultiplier * message.amount, tile.getContent()[0].func_77946_l())) {
                            TextComponentTranslation s = new TextComponentTranslation("showcasemod.success", new Object[]{"" + message.amount + " " + tile.item.func_92059_d().func_82833_r()});
                            s.func_150256_b().func_150238_a(TextFormatting.GREEN);
                            ctx.getServerHandler().field_147369_b.func_146105_b((ITextComponent)s);
                            this.removeItem(tile, message.amount, item);
                            CoinUtils.addCoin(tile, tile.unitPrice * currencyMultiplier * message.amount);
                        } else {
                            TextComponentTranslation s = new TextComponentTranslation("showcasemod.nem", new Object[0]);
                            s.func_150256_b().func_150238_a(TextFormatting.RED);
                            ctx.getServerHandler().field_147369_b.func_146105_b((ITextComponent)s);
                        }
                    } else {
                        TextComponentTranslation s = new TextComponentTranslation("showcasemod.error", new Object[0]);
                        s.func_150256_b().func_150238_a(TextFormatting.RED);
                        ctx.getServerHandler().field_147369_b.func_146105_b((ITextComponent)s);
                    }
                }
            }
            return null;
        }

        public void removeItem(BlockShowcaseTileEntity te, int amount, Item item) {
            int amountToRemove = amount;
            for (int i = 1; i < te.func_70302_i_(); ++i) {
                if (te.func_70301_a(i) == null || te.func_70301_a(i).func_77973_b() != item || amountToRemove == 0) continue;
                if (te.func_70301_a((int)i).field_77994_a > amountToRemove) {
                    te.func_70298_a(i, amountToRemove);
                    amountToRemove = 0;
                    continue;
                }
                amountToRemove -= te.func_70301_a((int)i).field_77994_a;
                te.func_70298_a(i, te.func_70301_a((int)i).field_77994_a);
            }
        }
    }
}

