Scriptname VIGOR_MCM_MENU extends SKI_ConfigBase
{SkyUI MCM for Vigor!}

; SCRIPT VERSION ----------------------------------------------------------------------------------

int function GetVersion()
	return 7
endFunction

event OnVersionUpdate(int a_version)
    if (a_version >1)
        OnConfigInit()
    endIf
endEvent

; VARIABLES ---------------------------------------------------------------------------------------

; OIDs
int Toggle_OID_ModEnabled
int Toggle_OID_NPCSupport
int Toggle_OID_NPCBandages
int Toggle_OID_Fatigue
int Toggle_OID_CritDamage
int Toggle_OID_Movements
int Toggle_OID_Armor
int Toggle_OID_Disarm
int Toggle_OID_StaminaDrain
int Toggle_OID_StaminaDrainAbom
int Toggle_OID_Injury
int Toggle_OID_DisableHealthRegen
int Toggle_OID_StaminaBonus
int Toggle_OID_StaminaRegenBonus
int Toggle_OID_DisableFriendlyFire
int Toggle_OID_StaminaDrainRunning
int Toggle_OID_Bandage
int Toggle_OID_SpellScaling
int Toggle_OID_DisableStartMagicka
int Toggle_OID_Stagger
int Toggle_OID_TimedBlock
int Toggle_OID_AttackSpeedFix
int Toggle_OID_Potions
int Toggle_OID_Combat
int Slider_OID_StaminaDrainScale
int Slider_OID_Injury1
int Slider_OID_Injury2
int Slider_OID_Injury3
int Slider_OID_PotionFortifyHealth
int Slider_OID_PotionFortifyArmor
int Slider_OID_PotionFortifyDamage
int Slider_OID_PotionResistMagic
int Slider_OID_PotionResistElement
int Slider_OID_PotionHealth
int Slider_OID_PotionStamina
int Slider_OID_PotionInvisibility
int Slider_OID_Stagger

; States
bool _Toggle_ModEnabled = false
bool _Toggle_NPCSupport = true
bool _Toggle_NPCBandages = true
bool _Toggle_Fatigue = true
bool _Toggle_CritDamage = true
bool _Toggle_Movements = true
bool _Toggle_Armor = true
bool _Toggle_Disarm = true
bool _Toggle_StaminaDrain = true
bool _Toggle_StaminaDrainAbom = true
bool _Toggle_Injury = true
bool _Toggle_DisableHealthRegen = true
bool _Toggle_StaminaBonus = true
bool _Toggle_StaminaRegenBonus = true
bool _Toggle_DisableFriendlyFire = true
bool _Toggle_StaminaDrainRunning = true
bool _Toggle_Bandage = true
bool _Toggle_SpellScaling = false
bool _Toggle_DisableStartMagicka = false
bool _Toggle_Stagger = True
bool _Toggle_TimedBlock = True
bool _Toggle_AttackSpeedFix = False
bool _Toggle_Potions = True
bool _Toggle_Combat = True
float _Slider_StaminaDrainScale = 100.0
float _Slider_Injury1 = 0.75
float _Slider_Injury2 = 0.50
float _Slider_Injury3 = 0.25
float _Slider_PotionFortifyHealth = 25.0
float _Slider_PotionFortifyArmor = 25.0
float _Slider_PotionFortifyDamage = 25.0
float _Slider_PotionResistMagic = 25.0
float _Slider_PotionResistElement = 33.0
float _Slider_PotionHealth = 50.0
float _Slider_PotionStamina = 50.0
float _Slider_PotionInvisibility = 5.0
float _Slider_Stagger = 100.0


; Global
GlobalVariable property Vigor_Enable auto
GlobalVariable property Vigor_NPC auto
GlobalVariable property Vigor_BandageNPC auto
GlobalVariable property Vigor_Fatigue auto
GlobalVariable property Vigor_StaminaDrain auto
GlobalVariable property Vigor_StaminaDrainScale auto
GlobalVariable property Vigor_StaminaBonus auto
GlobalVariable property Vigor_StaminaRegenBonus auto
GlobalVariable property Vigor_StaminaDrainRunning auto
GlobalVariable property Vigor_Bandage auto
GlobalVariable property Vigor_InjuryNPC auto
GlobalVariable property Vigor_StaggerNPC auto
GlobalVariable property Vigor_AttackSpeedFix auto
GlobalVariable property Vigor_Potions auto
GlobalVariable property Vigor_ChanceInjury1 auto
GlobalVariable property Vigor_ChanceInjury2 auto
GlobalVariable property Vigor_ChanceInjury3 auto
GlobalVariable property Vigor_ChancePotionFortifyArmor auto
GlobalVariable property Vigor_ChancePotionFortifyDamage auto
GlobalVariable property Vigor_ChancePotionFortifyHealth auto
GlobalVariable property Vigor_ChancePotionElementalResistance auto
GlobalVariable property Vigor_ChancePotionHealth auto
GlobalVariable property Vigor_ChancePotionMagicResistance auto
GlobalVariable property Vigor_ChancePotionStamina auto
GlobalVariable property Vigor_ChancePotionInvisibility auto
GlobalVariable property Vigor_ChanceStagger auto

; Spells
Spell Property ale_DisableHealthRegen  Auto 
Spell Property ale_Fatigue  Auto 
Spell Property ale_Injury  Auto 
Spell Property ale_StaminaBonus  Auto 
Spell Property ale_StaminaDrainMaster  Auto 
Spell Property ale_StaminaRegenBonus  Auto 
Spell Property ale_DisableStartMagicka  Auto 
Spell Property ale_Stagger  Auto 
Spell Property ale_TimedBlock  Auto 
Spell Property ale_AttackSpeedFixVig  Auto 

;Perks
Perk Property alePerkDisableFriendlyFire  Auto  
Perk Property aleStaminaDrainScaling  Auto  
Perk Property aleStaminaDrainSupernatural  Auto  
Perk Property alePerkArmor  Auto  
Perk Property alePerkDisarmBow  Auto  
Perk Property alePerkWeaponCrit  Auto  
Perk Property alePerkSpellScaling  Auto  
Perk Property alePerkCombat  Auto  


; EVENTS ------------------------------------------------------------------------------------------

event OnPageReset(string a_page)
	{Called when a new page is selected, including the initial empty page}
	
	; Building Pages...
	SetCursorFillMode(TOP_TO_BOTTOM)

	SetCursorPosition(0)

	Toggle_OID_ModEnabled = AddToggleOption("Start Vigor", _Toggle_ModEnabled)
	AddEmptyOption()
	
	AddHeaderOption("Fatigue")
	Toggle_OID_Fatigue = AddToggleOption("Fatigue", _Toggle_Fatigue)
	Toggle_OID_StaminaBonus = AddToggleOption("Stamina Bonus", _Toggle_StaminaBonus)
	Toggle_OID_StaminaRegenBonus = AddToggleOption("Stamina Regeneration Bonus", _Toggle_StaminaRegenBonus)
	AddEmptyOption()

	AddHeaderOption("Stamina Actions")
	Toggle_OID_StaminaDrain = AddToggleOption("Stamina Actions", _Toggle_StaminaDrain)
	Slider_OID_StaminaDrainScale = AddSliderOption("Stamina Drain Scaling", _Slider_StaminaDrainScale, "{0}%")
	Toggle_OID_StaminaDrainRunning = AddToggleOption("Stamina Drain when Running", _Toggle_StaminaDrainRunning)	
	Toggle_OID_StaminaDrainAbom = AddToggleOption("Tireless Supernatural Creatures", _Toggle_StaminaDrainAbom)
	AddEmptyOption()

	AddHeaderOption("Injuries")
	Toggle_OID_Injury = AddToggleOption("Injuries", _Toggle_Injury)
	Toggle_OID_DisableHealthRegen = AddToggleOption("Disable Passive Health Regeneration", _Toggle_DisableHealthRegen)
	Toggle_OID_Bandage = AddToggleOption("Bandage Recipes", _Toggle_Bandage)
	Slider_OID_Injury1 = AddSliderOption("First Injury health percentage", _Slider_Injury1, "{2}")
	Slider_OID_Injury2 = AddSliderOption("Second Injury health percentage", _Slider_Injury2, "{2}")
	Slider_OID_Injury3 = AddSliderOption("Third Injury health percentage", _Slider_Injury3, "{2}")
	AddEmptyOption()

	AddHeaderOption("Combat")
	Toggle_OID_Combat = AddToggleOption("Movement and Damage", _Toggle_Combat)
	Toggle_OID_CritDamage = AddToggleOption("Critical Damage", _Toggle_CritDamage)
	Toggle_OID_TimedBlock = AddToggleOption("Timed Block", _Toggle_TimedBlock)
	Toggle_OID_Armor = AddToggleOption("More protective Heavy Armor", _Toggle_Armor)
	Toggle_OID_Disarm = AddToggleOption("Disarm", _Toggle_Disarm)
	Toggle_OID_DisableFriendlyFire= AddToggleOption("Disable Friendly Fire", _Toggle_DisableFriendlyFire)
	Toggle_OID_Stagger = AddToggleOption("Stagger", _Toggle_Stagger)
	Slider_OID_Stagger = AddSliderOption("Stagger Chance", _Slider_Stagger, "{0}%")

	SetCursorPosition(1)

	AddEmptyOption()

	AddEmptyOption()

	AddHeaderOption("Magic")
	Toggle_OID_SpellScaling = AddToggleOption("Spell Scaling", _Toggle_SpellScaling)
	Toggle_OID_DisableStartMagicka = AddToggleOption("Disable Start Magicka", _Toggle_DisableStartMagicka)
	AddEmptyOption()

	AddHeaderOption("NPC Support")
	Toggle_OID_NPCSupport  = AddToggleOption("Enable NPC Support", _Toggle_NPCSupport)
	Toggle_OID_NPCBandages = AddToggleOption("Enable Bandages for NPCs", _Toggle_NPCBandages)
	Toggle_OID_Potions = AddToggleOption("NPCs use Potions", _Toggle_Potions)
	Slider_OID_PotionFortifyHealth = AddSliderOption("Fortify Health Potions Chance", _Slider_PotionFortifyHealth, "{0}")
	Slider_OID_PotionFortifyArmor = AddSliderOption("Fortify Armor Potions Chance", _Slider_PotionFortifyArmor, "{0}")
	Slider_OID_PotionFortifyDamage = AddSliderOption("Fortify Damage Potions Chance", _Slider_PotionFortifyDamage, "{0}")
	Slider_OID_PotionResistMagic = AddSliderOption("Resist Magic Potions Chance", _Slider_PotionResistMagic, "{0}")
	Slider_OID_PotionResistElement = AddSliderOption("Resist Element Potions Chance", _Slider_PotionResistElement, "{0}")
	Slider_OID_PotionHealth = AddSliderOption("Healing Potions Chance", _Slider_PotionHealth, "{0}")
	Slider_OID_PotionStamina = AddSliderOption("Stamina Potions Chance", _Slider_PotionStamina, "{0}")
	Slider_OID_PotionInvisibility = AddSliderOption("Invisibility Potions Chance", _Slider_PotionInvisibility, "{0}")
	AddEmptyOption()

	AddEmptyOption()

	AddEmptyOption()

	AddEmptyOption()

	AddEmptyOption()

	AddEmptyOption()

	AddEmptyOption()

	AddEmptyOption()

	AddEmptyOption()

	AddEmptyOption()

	AddHeaderOption("Extra")
	Toggle_OID_AttackSpeedFix = AddToggleOption("Attack Speed Fix", _Toggle_AttackSpeedFix)


endEvent

Event OnOptionHighlight(int option)
	{Called when highlighting an option}

	if (option == Toggle_OID_ModEnabled )
		SetInfoText("Start Vigor - Combat and Injuries. Uncheck this before unistalling!")
	elseIf (option == Toggle_OID_NPCSupport  )
		SetInfoText("Enable NPC Support. (Default = On)")
	elseIf (option == Toggle_OID_NPCBandages )
		SetInfoText("Determines whether or not NPCs will use Bandages when injured. (Default = On)")
	elseIf (option == Toggle_OID_Fatigue )
		SetInfoText("Fatigue apply debuffs whenever stamina is low and buffs when high. (Default = On)")
	elseIf (option == Slider_OID_StaminaDrainScale )
		SetInfoText("Set the strength of the stamina drain when performing actions. Reequip your armor for this to take effect. (Default = 100)")
	elseIf (option == Toggle_OID_CritDamage )
		SetInfoText("Allows any weapon to apply critical hits and increase it`s damage. Critical Hit chance depends on the weapon type. (Default = On)")
	elseIf (option == Toggle_OID_TimedBlock )
		SetInfoText("You are rewarded when blocking just before the hit is struck. (Default = On)")
	elseIf (option == Toggle_OID_Armor )
		SetInfoText("Makes heavy armor more protective against certain weapons types and animals. (Default = On)")
	elseIf (option == Toggle_OID_Disarm )
		SetInfoText("Bows can be disarmed when struck by melee weapons. (Default = On)")
	elseIf (option == Toggle_OID_StaminaDrain )
		SetInfoText("Many actions will drain stamina from the player and humanoid NPCs. (Default = On)")
	elseIf (option == Toggle_OID_StaminaDrainAbom )
		SetInfoText("Werewolfs and Vampires get tired slower and are less affected by fatigue. (Default = On)")
	elseIf (option == Toggle_OID_Injury )
		SetInfoText("Player and NPCs have a chance to get injured when hit. The penalty depends on the injured limb. (Default = On)")
	elseIf (option == Toggle_OID_DisableHealthRegen )
		SetInfoText("Disable passive health regeneration for the player when bellow 75% health. Enchantments, potions and healing spells still works normally. (Default = On)")
	elseIf (option == Toggle_OID_StaminaBonus )
		SetInfoText("Add 100 stamina bonus for the player and humanoid NPCs. (Default = On)")
	elseIf (option == Toggle_OID_StaminaRegenBonus )
		SetInfoText("Add stamina regeneration bonus for the player NPCs above 50% of the total stamina pool. (Default = On)")
	elseIf (option == Toggle_OID_DisableFriendlyFire )
		SetInfoText("While in combat you won`t harm allies with weapons or spells. (Default = On)")
	elseIf (option == Toggle_OID_StaminaDrainRunning )
		SetInfoText("Allow stamina drain when running or swimming. (Default = On)")
	elseIf (option == Toggle_OID_Bandage )
		SetInfoText("Show recipes for bandages in the crafting menu. (Default = On)")
	elseIf (option == Toggle_OID_SpellScaling )
		SetInfoText("Enable spell scaling. Spell magnitude or duration will scale with the corresponding skill. (Default = Off)")
	elseIf (option == Toggle_OID_DisableStartMagicka )
		SetInfoText("Maybe you don`t think you were born a mage? (Default = Off)")
	elseIf (option == Toggle_OID_Stagger)
		SetInfoText("Player and NPCs can be staggered when loosing a certain amount of health. (Default = On)")
	elseIf (option == Toggle_OID_AttackSpeedFix)
		SetInfoText("Fix vanilla attack speed base value to allow stacking. IMPORTANT: You should only have one fix such as this at a time, other mods might also have this fix.  (Default = Off)")
	elseIf (option == Toggle_OID_Potions)
		SetInfoText("NPCs have the ability to use several types of potions under certain circumstances. (Default = On)")
	elseIf (option == Toggle_OID_Combat)
		SetInfoText("Dealt and Incoming damage depends on the movement and power attacks makes the attacker more vulnerable. (Default = On)")
	elseIf (option == Slider_OID_Injury1)
		SetInfoText("Set at what health health percentage you and NPCs can get the first injury. 1 = 100% while 0.1 = 1% (Default = 0.75)")
	elseIf (option == Slider_OID_Injury2)
		SetInfoText("Set at what health health percentage you and NPCs can get the second  injury. 1 = 100% while 0.1 = 1% (Default = 0.5)")
	elseIf (option == Slider_OID_Injury3)
		SetInfoText("Set at what health health percentage you and NPCs can get the third injury. 1 = 100% while 0.1 = 1% (Default = 0.25)")
	elseIf (option == Slider_OID_PotionFortifyHealth)
		SetInfoText("Set the chance for NPCs to use Fortify Health potions when entering in combat. (Default = 25%)")
	elseIf (option == Slider_OID_PotionFortifyArmor)
		SetInfoText("Set the chance for NPCs to use Fortify Armor potions when entering in combat. (Default = 25%)")
	elseIf (option == Slider_OID_PotionFortifyDamage)
		SetInfoText("Set the chance for NPCs to use Fortify Damage potions when entering in combat. (Default = 25%)")
	elseIf (option == Slider_OID_PotionResistMagic)
		SetInfoText("Set the chance for NPCs to use Resist Magic potions when entering in combat. (Default = 25%)")
	elseIf (option == Slider_OID_PotionResistElement)
		SetInfoText("Set the chance for NPCs to have Resist Fire, Frost or Shock potions. These potions can be used when the NPC is hit by the corresponding element. (Default = 33%)")
	elseIf (option == Slider_OID_PotionHealth)
		SetInfoText("Set the chance for NPCs to have Healing potions. This chance will be checked twice, first to enable NPCs to use potions when health is bellow 50% and again to enable their use when health is bellow 25%. (Default = 50%)")
	elseIf (option == Slider_OID_PotionStamina)
		SetInfoText("Set the chance for NPCs to have Stamina potions. This chance will be checked twice, first to enable NPCs to use potions when stamina is bellow 50% and again to enable their use when stamina is bellow 25%. (Default = 50%)")
	elseIf (option == Slider_OID_PotionInvisibility)
		SetInfoText("Set the chance for NPCs to have Invisibility potions. These potions can be used when entering combat or in bleed-out state. (Default = 5%)")
	elseIf (option == Slider_OID_Stagger)
		SetInfoText("How often you and NPCs can stagger. Lower values means less stagger. (Default = 100%)")


	endIf

EndEvent

event OnOptionSelect(int option)
    if (option == Toggle_OID_ModEnabled)
        _Toggle_ModEnabled = !_Toggle_ModEnabled
        SetToggleOptionValue(Toggle_OID_ModEnabled, _Toggle_ModEnabled)
		if _Toggle_ModEnabled
			Game.GetPlayer().AddPerk(alePerkArmor)
			Game.GetPlayer().AddPerk(alePerkWeaponCrit)
			Game.GetPlayer().AddPerk(alePerkDisarmBow)
			Game.GetPlayer().AddPerk(alePerkDisableFriendlyFire)
			Game.GetPlayer().AddPerk(aleStaminaDrainScaling)
			Game.GetPlayer().AddPerk(aleStaminaDrainSupernatural)
			Game.GetPlayer().AddPerk(alePerkCombat)
			Game.GetPlayer().AddSpell(ale_DisableHealthRegen)
			Game.GetPlayer().AddSpell(ale_Fatigue)
			Game.GetPlayer().AddSpell(ale_Injury)
			Game.GetPlayer().AddSpell(ale_StaminaBonus)
			Game.GetPlayer().AddSpell(ale_StaminaDrainMaster)
			Game.GetPlayer().AddSpell(ale_StaminaRegenBonus)
			Game.GetPlayer().AddSpell(ale_Stagger)
			Game.GetPlayer().AddSpell(ale_TimedBlock)
			Vigor_NPC.SetValueInt(1)			
		Else
			Game.GetPlayer().RemovePerk(alePerkArmor)
			Game.GetPlayer().RemovePerk(alePerkWeaponCrit)
			Game.GetPlayer().RemovePerk(alePerkDisarmBow)
			Game.GetPlayer().RemovePerk(alePerkDisableFriendlyFire)
			Game.GetPlayer().RemovePerk(aleStaminaDrainScaling)
			Game.GetPlayer().RemovePerk(aleStaminaDrainSupernatural)
			Game.GetPlayer().RemovePerk(alePerkCombat)
			Game.GetPlayer().RemoveSpell(ale_DisableHealthRegen)
			Game.GetPlayer().RemoveSpell(ale_Fatigue)
			Game.GetPlayer().RemoveSpell(ale_Injury)
			Game.GetPlayer().RemoveSpell(ale_StaminaBonus)
			Game.GetPlayer().RemoveSpell(ale_StaminaDrainMaster)
			Game.GetPlayer().RemoveSpell(ale_StaminaRegenBonus)
			Game.GetPlayer().RemoveSpell(ale_Stagger)
			Game.GetPlayer().RemoveSpell(ale_TimedBlock)
			Game.GetPlayer().RemoveSpell(ale_AttackSpeedFixVig)
			Vigor_NPC.SetValueInt(0)

		endIf
		UpdateCurrentInstanceGlobal(Vigor_NPC)
				
	elseIf (option == Toggle_OID_NPCSupport )
		_Toggle_NPCSupport = !_Toggle_NPCSupport
		SetToggleOptionValue(Toggle_OID_NPCSupport, _Toggle_NPCSupport)
		if _Toggle_NPCSupport
			Vigor_NPC.SetValueInt(1)
		Else
			Vigor_NPC.SetValueInt(0)
		endIf
		UpdateCurrentInstanceGlobal(Vigor_NPC)
		
	elseIf (option == Toggle_OID_NPCBandages)	
		_Toggle_NPCBandages = !_Toggle_NPCBandages
		SetToggleOptionValue(Toggle_OID_NPCBandages, _Toggle_NPCBandages)
		if _Toggle_NPCBandages
			Vigor_BandageNPC.SetValueInt(1)
		Else
			Vigor_BandageNPC.SetValueInt(0)
		endIf
		UpdateCurrentInstanceGlobal(Vigor_BandageNPC)
		
	elseIf (option == Toggle_OID_Fatigue)
		_Toggle_Fatigue = !_Toggle_Fatigue
		SetToggleOptionValue(Toggle_OID_Fatigue, _Toggle_Fatigue)
		if _Toggle_Fatigue
			Game.GetPlayer().AddSpell(ale_Fatigue)
			Vigor_Fatigue.SetValueInt(1)
		Else
			Game.GetPlayer().RemoveSpell(ale_Fatigue)
			Vigor_Fatigue.SetValueInt(0)
		endIf
		UpdateCurrentInstanceGlobal(Vigor_Fatigue)
		
	elseIf (option == Toggle_OID_CritDamage)
		_Toggle_CritDamage = !_Toggle_CritDamage
		SetToggleOptionValue(Toggle_OID_CritDamage, _Toggle_CritDamage)
		if _Toggle_CritDamage
			Game.GetPlayer().AddPerk(alePerkWeaponCrit)
		Else
			Game.GetPlayer().RemovePerk(alePerkWeaponCrit)
		endIf
				
				
	elseIf (option == Toggle_OID_Armor)
		_Toggle_Armor = !_Toggle_Armor
		SetToggleOptionValue(Toggle_OID_Armor, _Toggle_Armor)
		if _Toggle_Armor
			Game.GetPlayer().AddPerk(alePerkArmor)
		Else
			Game.GetPlayer().RemovePerk(alePerkArmor)
		endIf
	
	elseIf (option == Toggle_OID_Disarm)
		_Toggle_Disarm = !_Toggle_Disarm
		SetToggleOptionValue(Toggle_OID_Disarm, _Toggle_Disarm)
		if _Toggle_Disarm
			Game.GetPlayer().AddPerk(alePerkDisarmBow)
		Else
			Game.GetPlayer().RemovePerk(alePerkDisarmBow)
		endIf

	elseIf (option == Toggle_OID_StaminaDrain)
		_Toggle_StaminaDrain = !_Toggle_StaminaDrain
		SetToggleOptionValue(Toggle_OID_StaminaDrain, _Toggle_StaminaDrain)
		if _Toggle_StaminaDrain
			Game.GetPlayer().AddSpell(ale_StaminaDrainMaster)
			Vigor_StaminaDrain.SetValueInt(1)
		Else
			Game.GetPlayer().RemoveSpell(ale_StaminaDrainMaster)
			Vigor_StaminaDrain.SetValueInt(0)
		endIf
		UpdateCurrentInstanceGlobal(Vigor_StaminaDrain)

	elseIf (option == Toggle_OID_StaminaDrainAbom)
		_Toggle_StaminaDrainAbom = !_Toggle_StaminaDrainAbom
		SetToggleOptionValue(Toggle_OID_StaminaDrainAbom, _Toggle_StaminaDrainAbom)
		if _Toggle_StaminaDrainAbom
			Game.GetPlayer().AddPerk(aleStaminaDrainSupernatural)
		Else
			Game.GetPlayer().RemovePerk(aleStaminaDrainSupernatural)
		endIf
		
	elseIf (option == Toggle_OID_Injury)
		_Toggle_Injury = !_Toggle_Injury
		SetToggleOptionValue(Toggle_OID_Injury, _Toggle_Injury)
		if _Toggle_Injury
			Game.GetPlayer().AddSpell(ale_Injury)	
			Vigor_InjuryNPC.SetValueInt(1)		
		Else
			Game.GetPlayer().RemoveSpell(ale_Injury)	
			Vigor_InjuryNPC.SetValueInt(0)		
		endIf
		UpdateCurrentInstanceGlobal(Vigor_InjuryNPC)

	elseIf (option == Toggle_OID_DisableHealthRegen)
		_Toggle_DisableHealthRegen = !_Toggle_DisableHealthRegen
		SetToggleOptionValue(Toggle_OID_DisableHealthRegen, _Toggle_DisableHealthRegen)
		if _Toggle_DisableHealthRegen
			Game.GetPlayer().AddSpell(ale_DisableHealthRegen)
		Else
			Game.GetPlayer().RemoveSpell(ale_DisableHealthRegen)
		endIf

	elseIf (option == Toggle_OID_StaminaBonus)
		_Toggle_StaminaBonus = !_Toggle_StaminaBonus
		SetToggleOptionValue(Toggle_OID_StaminaBonus, _Toggle_StaminaBonus)
		if _Toggle_StaminaBonus
			Game.GetPlayer().AddSpell(ale_StaminaBonus)
			Vigor_StaminaBonus.SetValueInt(1)
		Else
			Game.GetPlayer().RemoveSpell(ale_StaminaBonus)
			Vigor_StaminaBonus.SetValueInt(0)
		endIf
		UpdateCurrentInstanceGlobal(Vigor_StaminaBonus)

	elseIf (option == Toggle_OID_StaminaRegenBonus)
		_Toggle_StaminaRegenBonus = !_Toggle_StaminaRegenBonus
		SetToggleOptionValue(Toggle_OID_StaminaRegenBonus, _Toggle_StaminaRegenBonus)
		if _Toggle_StaminaRegenBonus
			Game.GetPlayer().AddSpell(ale_StaminaRegenBonus)
			Vigor_StaminaRegenBonus.SetValueInt(1)
		Else
			Game.GetPlayer().RemoveSpell(ale_StaminaRegenBonus)
			Vigor_StaminaRegenBonus.SetValueInt(0)
		endIf
		UpdateCurrentInstanceGlobal(Vigor_StaminaRegenBonus)

	elseIf (option == Toggle_OID_DisableFriendlyFire)
		_Toggle_DisableFriendlyFire = !_Toggle_DisableFriendlyFire
		SetToggleOptionValue(Toggle_OID_DisableFriendlyFire, _Toggle_DisableFriendlyFire)
		if _Toggle_DisableFriendlyFire
			Game.GetPlayer().AddPerk(alePerkDisableFriendlyFire)
		Else
			Game.GetPlayer().RemovePerk(alePerkDisableFriendlyFire)
		endIf

	elseIf (option == Toggle_OID_StaminaDrainRunning)
		_Toggle_StaminaDrainRunning = !_Toggle_StaminaDrainRunning
		SetToggleOptionValue(Toggle_OID_StaminaDrainRunning, _Toggle_StaminaDrainRunning)
		if _Toggle_StaminaDrainRunning
			Vigor_StaminaDrainRunning.SetValueInt(1)
		Else
			Vigor_StaminaDrainRunning.SetValueInt(0)
		endIf
		UpdateCurrentInstanceGlobal(Vigor_StaminaDrainRunning)

	elseIf (option == Toggle_OID_Bandage)
		_Toggle_Bandage = !_Toggle_Bandage
		SetToggleOptionValue(Toggle_OID_Bandage, _Toggle_Bandage)
		if _Toggle_Bandage
			Vigor_Bandage.SetValueInt(1)
		Else
			Vigor_Bandage.SetValueInt(0)
		endIf
		UpdateCurrentInstanceGlobal(Vigor_Bandage)


	elseIf (option == Toggle_OID_SpellScaling)
		_Toggle_SpellScaling = !_Toggle_SpellScaling
		SetToggleOptionValue(Toggle_OID_SpellScaling, _Toggle_SpellScaling)
		if _Toggle_SpellScaling
			Game.GetPlayer().AddPerk(alePerkSpellScaling)
		Else
			Game.GetPlayer().RemovePerk(alePerkSpellScaling)
		endIf

	elseIf (option == Toggle_OID_DisableStartMagicka)
		_Toggle_DisableStartMagicka = !_Toggle_DisableStartMagicka
		SetToggleOptionValue(Toggle_OID_DisableStartMagicka, _Toggle_DisableStartMagicka)
		if _Toggle_DisableStartMagicka
			Game.GetPlayer().AddSpell(ale_DisableStartMagicka)
		Else
			Game.GetPlayer().RemoveSpell(ale_DisableStartMagicka)
		endIf

	elseIf (option == Toggle_OID_Stagger)
		_Toggle_Stagger = !_Toggle_Stagger
		SetToggleOptionValue(Toggle_OID_Stagger, _Toggle_Stagger)
		if _Toggle_Stagger
			Game.GetPlayer().AddSpell(ale_Stagger)
			Vigor_StaggerNPC.SetValueInt(1)
		Else
			Game.GetPlayer().RemoveSpell(ale_Stagger)
			Vigor_StaggerNPC.SetValueInt(0)
		endIf
		UpdateCurrentInstanceGlobal(Vigor_StaggerNPC)

	elseIf (option == Toggle_OID_TimedBlock)
		_Toggle_TimedBlock = !_Toggle_TimedBlock
		SetToggleOptionValue(Toggle_OID_TimedBlock, _Toggle_TimedBlock)
		if _Toggle_TimedBlock
			Game.GetPlayer().AddSpell(ale_TimedBlock)
		Else
			Game.GetPlayer().RemoveSpell(ale_TimedBlock)
		endIf

	elseIf (option == Toggle_OID_AttackSpeedFix)
		_Toggle_AttackSpeedFix = !_Toggle_AttackSpeedFix
		SetToggleOptionValue(Toggle_OID_AttackSpeedFix, _Toggle_AttackSpeedFix)
		if _Toggle_AttackSpeedFix
			Game.GetPlayer().AddSpell(ale_AttackSpeedFixVig)
			Vigor_AttackSpeedFix.SetValueInt(1)
		Else
			Game.GetPlayer().RemoveSpell(ale_AttackSpeedFixVig)
			Vigor_AttackSpeedFix.SetValueInt(0)
		endIf
		UpdateCurrentInstanceGlobal(Vigor_AttackSpeedFix)

	elseIf (option == Toggle_OID_Potions)
		_Toggle_Potions = !_Toggle_Potions
		SetToggleOptionValue(Toggle_OID_Potions, _Toggle_Potions)
		if _Toggle_Potions
			Vigor_Potions.SetValueInt(1)
		Else
			Vigor_Potions.SetValueInt(0)
		endIf
		UpdateCurrentInstanceGlobal(Vigor_Potions)

	elseIf (option == Toggle_OID_Combat)
		_Toggle_Combat = !_Toggle_Combat
		SetToggleOptionValue(Toggle_OID_Combat, _Toggle_Combat)
		if _Toggle_Combat
			Game.GetPlayer().AddPerk(alePerkCombat)
		Else
			Game.GetPlayer().RemovePerk(alePerkCombat)
		endIf

    endIf
endEvent

Event OnOptionSliderOpen(int option)
	{Called when a slider option has been selected}

	if ( option == Slider_OID_StaminaDrainScale )
		SetSliderDialogStartValue(_Slider_StaminaDrainScale )
		SetSliderDialogDefaultValue(100)
		SetSliderDialogRange(50, 200)
		SetSliderDialogInterval(25)

	elseIf ( option == Slider_OID_Injury1 )
		SetSliderDialogStartValue(_Slider_Injury1 )
		SetSliderDialogDefaultValue(0.75)
		SetSliderDialogRange(0, 1)
		SetSliderDialogInterval(0.01)

	elseIf ( option == Slider_OID_Injury2 )
		SetSliderDialogStartValue(_Slider_Injury2 )
		SetSliderDialogDefaultValue(0.50)
		SetSliderDialogRange(0, 1)
		SetSliderDialogInterval(0.01)

	elseIf ( option == Slider_OID_Injury3 )
		SetSliderDialogStartValue(_Slider_Injury3 )
		SetSliderDialogDefaultValue(0.25)
		SetSliderDialogRange(0, 1)
		SetSliderDialogInterval(0.01)

	elseIf ( option == Slider_OID_PotionFortifyHealth )
		SetSliderDialogStartValue(_Slider_PotionFortifyHealth )
		SetSliderDialogDefaultValue(25)
		SetSliderDialogRange(0, 100)
		SetSliderDialogInterval(1)

	elseIf ( option == Slider_OID_PotionFortifyArmor )
		SetSliderDialogStartValue(_Slider_PotionFortifyArmor )
		SetSliderDialogDefaultValue(25)
		SetSliderDialogRange(0, 100)
		SetSliderDialogInterval(1)

	elseIf ( option == Slider_OID_PotionFortifyDamage )
		SetSliderDialogStartValue(_Slider_PotionFortifyDamage )
		SetSliderDialogDefaultValue(25)
		SetSliderDialogRange(0, 100)
		SetSliderDialogInterval(1)

	elseIf ( option == Slider_OID_PotionResistMagic )
		SetSliderDialogStartValue(_Slider_PotionResistMagic )
		SetSliderDialogDefaultValue(25)
		SetSliderDialogRange(0, 100)
		SetSliderDialogInterval(1)

	elseIf ( option == Slider_OID_PotionResistElement )
		SetSliderDialogStartValue(_Slider_PotionResistElement )
		SetSliderDialogDefaultValue(33)
		SetSliderDialogRange(0, 100)
		SetSliderDialogInterval(1)

	elseIf ( option == Slider_OID_PotionHealth )
		SetSliderDialogStartValue(_Slider_PotionFortifyHealth )
		SetSliderDialogDefaultValue(50)
		SetSliderDialogRange(0, 100)
		SetSliderDialogInterval(1)

	elseIf ( option == Slider_OID_PotionStamina )
		SetSliderDialogStartValue(_Slider_PotionStamina )
		SetSliderDialogDefaultValue(50)
		SetSliderDialogRange(0, 100)
		SetSliderDialogInterval(1)

	elseIf ( option == Slider_OID_PotionInvisibility )
		SetSliderDialogStartValue(_Slider_PotionInvisibility )
		SetSliderDialogDefaultValue(5)
		SetSliderDialogRange(0, 100)
		SetSliderDialogInterval(1)

	elseIf ( option == Slider_OID_Stagger )
		SetSliderDialogStartValue(_Slider_Stagger )
		SetSliderDialogDefaultValue(100)
		SetSliderDialogRange(0, 100)
		SetSliderDialogInterval(1)

	endIf


EndEvent

Event OnOptionSliderAccept(int option, float value)
	{Called when a new slider value has been accepted}

	if ( option == Slider_OID_StaminaDrainScale )
		_Slider_StaminaDrainScale = value
		Vigor_StaminaDrainScale.SetValue(_Slider_StaminaDrainScale)
		UpdateCurrentInstanceGlobal(Vigor_StaminaDrainScale)
		SetSliderOptionValue(Slider_OID_StaminaDrainScale, _Slider_StaminaDrainScale, "{0}%")

	elseIf ( option == Slider_OID_Injury1 )
		_Slider_Injury1 = value
		Vigor_ChanceInjury1.SetValue(_Slider_Injury1)
		UpdateCurrentInstanceGlobal(Vigor_ChanceInjury1)
		SetSliderOptionValue(Slider_OID_Injury1, _Slider_Injury1, "{2}")

	elseIf ( option == Slider_OID_Injury2 )
		_Slider_Injury2 = value
		Vigor_ChanceInjury2.SetValue(_Slider_Injury2)
		UpdateCurrentInstanceGlobal(Vigor_ChanceInjury2)
		SetSliderOptionValue(Slider_OID_Injury2, _Slider_Injury2, "{2}")

	elseIf ( option == Slider_OID_Injury3 )
		_Slider_Injury3 = value
		Vigor_ChanceInjury3.SetValue(_Slider_Injury3)
		UpdateCurrentInstanceGlobal(Vigor_ChanceInjury3)
		SetSliderOptionValue(Slider_OID_Injury3, _Slider_Injury3, "{2}")

	elseIf ( option == Slider_OID_PotionFortifyHealth )
		_Slider_PotionFortifyHealth = value
		Vigor_ChancePotionFortifyHealth.SetValue(_Slider_PotionFortifyHealth)
		UpdateCurrentInstanceGlobal(Vigor_ChancePotionFortifyHealth)
		SetSliderOptionValue(Slider_OID_PotionFortifyHealth, _Slider_PotionFortifyHealth, "{0}")

	elseIf ( option == Slider_OID_PotionFortifyArmor )
		_Slider_PotionFortifyArmor = value
		Vigor_ChancePotionFortifyArmor.SetValue(_Slider_PotionFortifyArmor)
		UpdateCurrentInstanceGlobal(Vigor_ChancePotionFortifyArmor)
		SetSliderOptionValue(Slider_OID_PotionFortifyArmor, _Slider_PotionFortifyArmor, "{0}")

	elseIf ( option == Slider_OID_PotionFortifyDamage )
		_Slider_PotionFortifyDamage = value
		Vigor_ChancePotionFortifyDamage.SetValue(_Slider_PotionFortifyDamage)
		UpdateCurrentInstanceGlobal(Vigor_ChancePotionFortifyDamage)
		SetSliderOptionValue(Slider_OID_PotionFortifyDamage, _Slider_PotionFortifyDamage, "{0}")

	elseIf ( option == Slider_OID_PotionResistMagic )
		_Slider_PotionResistMagic = value
		Vigor_ChancePotionMagicResistance.SetValue(_Slider_PotionResistMagic)
		UpdateCurrentInstanceGlobal(Vigor_ChancePotionMagicResistance)
		SetSliderOptionValue(Slider_OID_PotionResistMagic , _Slider_PotionResistMagic, "{0}")

	elseIf ( option == Slider_OID_PotionResistElement )
		_Slider_PotionResistElement = value
		Vigor_ChancePotionElementalResistance.SetValue(_Slider_PotionResistElement)
		UpdateCurrentInstanceGlobal(Vigor_ChancePotionElementalResistance)
		SetSliderOptionValue(Slider_OID_PotionResistElement, _Slider_PotionResistElement, "{0}")

	elseIf ( option == Slider_OID_PotionHealth )
		_Slider_PotionHealth = value
		Vigor_ChancePotionHealth.SetValue(_Slider_PotionHealth)
		UpdateCurrentInstanceGlobal(Vigor_ChancePotionHealth)
		SetSliderOptionValue(Slider_OID_PotionHealth, _Slider_PotionHealth, "{0}")

	elseIf ( option == Slider_OID_PotionStamina )
		_Slider_PotionStamina = value
		Vigor_ChancePotionStamina.SetValue(_Slider_PotionStamina)
		UpdateCurrentInstanceGlobal(Vigor_ChancePotionStamina)
		SetSliderOptionValue(Slider_OID_PotionStamina, _Slider_PotionStamina, "{0}")

	elseIf ( option == Slider_OID_PotionInvisibility )
		_Slider_PotionInvisibility = value
		Vigor_ChancePotionInvisibility.SetValue(_Slider_PotionInvisibility)
		UpdateCurrentInstanceGlobal(Vigor_ChancePotionInvisibility)
		SetSliderOptionValue(Slider_OID_PotionInvisibility, _Slider_PotionInvisibility, "{0}")

	elseIf ( option == Slider_OID_Stagger )
		_Slider_Stagger = value
		Vigor_ChanceStagger.SetValue(_Slider_Stagger)
		UpdateCurrentInstanceGlobal(Vigor_ChanceStagger)
		SetSliderOptionValue(Slider_OID_Stagger, _Slider_Stagger, "{0}")

	endIf

EndEvent