#include "Hooks_NetImmerse.h"
#include "skse64_common/SafeWrite.h"
#include "skse64_common/Utilities.h"
#include "skse64_common/BranchTrampoline.h"

#include "skse64/GameReferences.h"
#include "skse64/GameFormComponents.h"
#include "skse64/PapyrusEvents.h"

#include "common/ICriticalSection.h"

UInt32 g_tintTextureResolution = 256;

RelocAddr<_ClipTextureDimensions> ClipTextureDimensions(0x00000000);


void * __stdcall ClipTextureDimensions_Hook(NiRenderer * renderer, UInt32 type, UInt32 * height, UInt32 * width, UInt32 * a5, UInt32 * a6, UInt32 * a7, UInt32 * a8, UInt32 * a9, UInt32 * a10)
{
	void * result = ClipTextureDimensions(renderer, type, height, width, a5, a6, a7, a8, a9, a10);
	switch(type) {
		case 32: // Not sure what all the types are yet
			{
				*height = g_tintTextureResolution;
				*width = g_tintTextureResolution;
			}
			break;
	}
	return result;
}

void ActorProcessManager::UpdateEquipment_Hooked(Actor * actor)
{
	CALL_MEMBER_FN(this, UpdateEquipment)(actor);

	SKSENiNodeUpdateEvent evn(actor);
	g_ninodeUpdateEventDispatcher.SendEvent(&evn);
}

void Hooks_NetImmerse_Init(void)
{
	UInt32	tintTextureResolution = 0;
	if(GetConfigOption_UInt32("Display", "iTintTextureResolution", &tintTextureResolution))
	{
		g_tintTextureResolution = tintTextureResolution;
	}
}

RelocAddr <uintptr_t> UpdateEquipment_Enter(0x00691A70 + 0x189);

void Hooks_NetImmerse_Commit(void)
{
#ifdef FIXME
	WriteRelCall(0x00C91800 + 0x3C, (UInt32)ClipTextureDimensions_Hook);
	WriteRelCall(0x00C92330 + 0x4C, (UInt32)ClipTextureDimensions_Hook);
#endif

	g_branchTrampoline.Write5Call(UpdateEquipment_Enter, GetFnAddr(&ActorProcessManager::UpdateEquipment_Hooked));
}
