Scriptname _Anton_WolverineClaws_Dummy extends ObjectReference  
{When equip Claws: play sound, animation, damage health, add perks, add spell with Claws}

Quest Property _Anton_WolverineClaws_Quest 			Auto
Spell Property _Anton_WolverineClaws_Spell_Claws 	Auto
Armor Property _Anton_WolverineClaws_DummyArmor 	Auto

Perk Property _Anton_WolverineClaws_Perk_FistsOfSteel 		Auto
Perk Property _Anton_WolverineClaws_Perk_DeftMovement 		Auto
Perk Property _Anton_WolverineClaws_Perk_MQ101ReduceDamage 	Auto

Float	akHealth
Int		SoundREF

Sound Property _Anton_WolverineClaws_SayAI_fem Auto
Sound Property _Anton_WolverineClaws_SayAI_man Auto


Auto State NothingEquipped
	
	Event OnEquipped( Actor akActor )
		GoToState("ClawsEquipped")
		
		;     ,         
		_Anton_WolverineClaws_Quest.Start()
		_Anton_WolverineClaws_Quest.SetStage(0)
		
		;    
		akActor.AddPerk(_Anton_WolverineClaws_Perk_FistsOfSteel)
		akActor.AddPerk(_Anton_WolverineClaws_Perk_DeftMovement)
		akActor.AddPerk(_Anton_WolverineClaws_Perk_MQ101ReduceDamage)
		
		;  ,    ,   
		akActor.AddSpell(_Anton_WolverineClaws_Spell_Claws, False)
		
		;    
		akHealth = akActor.GetActorValue("Health")
		akHealth = akHealth / 1.25
		If akHealth < 190.0
			akHealth = 190.0
		EndIf
		akActor.DamageActorValue("Health", akHealth)
		
		;  ""
		ActorBase PlayerBase = akActor.GetBaseObject() as ActorBase
		if PlayerBase.GetSex() == 1
			SoundREF = _Anton_WolverineClaws_SayAI_fem.Play(akActor)
			Sound.SetInstanceVolume(SoundREF, 1.0)
		Else
			SoundREF = _Anton_WolverineClaws_SayAI_man.Play(akActor)
			Sound.SetInstanceVolume(SoundREF, 1.0)
		EndIf
		
		;       3- ,    
		If akActor == Game.GetPlayer()
			Game.ForceThirdPerson()
		EndIf
		
		;   
		Debug.SendAnimationEvent(akActor, "bleedOutStart")
		Utility.Wait(5.0)
		Debug.SendAnimationEvent(akActor, "bleedOutStop")

	EndEvent

	Event OnUnequipped( Actor akActor )
	EndEvent

EndState

State ClawsEquipped
	
	Event OnEquipped( Actor akActor )
	EndEvent

	Event OnUnequipped( Actor akActor )
		;     ,       
		_Anton_WolverineClaws_Quest.SetStage(10)
		_Anton_WolverineClaws_Quest.Stop()
		
		;      ,   ,       OnEquipped()
		If akActor.GetItemCount(_Anton_WolverineClaws_DummyArmor) > 1
			akActor.RemoveItem(_Anton_WolverineClaws_DummyArmor, 1)
		EndIf
		
		;  ,    ,   
		akActor.RemoveSpell(_Anton_WolverineClaws_Spell_Claws)
		
		;     
		akActor.RemovePerk(_Anton_WolverineClaws_Perk_FistsOfSteel)
		akActor.RemovePerk(_Anton_WolverineClaws_Perk_DeftMovement)
		akActor.RemovePerk(_Anton_WolverineClaws_Perk_MQ101ReduceDamage)
	
		;    
		akHealth = akActor.GetActorValue("Health")
		akHealth = akHealth / 1.25
		If akHealth < 190.0
			akHealth = 190.0
		EndIf
		akActor.DamageActorValue("Health", akHealth)
		
		;  ""
		ActorBase PlayerBase = akActor.GetBaseObject() as ActorBase
		if PlayerBase.GetSex() == 1
			SoundREF = _Anton_WolverineClaws_SayAI_fem.Play(akActor)
			Sound.SetInstanceVolume(SoundREF, 1.0)
		Else
			SoundREF = _Anton_WolverineClaws_SayAI_man.Play(akActor)
			Sound.SetInstanceVolume(SoundREF, 1.0)
		EndIf
		
		;       3- ,    
		If akActor == Game.GetPlayer()
			Game.ForceThirdPerson()
		EndIf
		
		;   
		Debug.SendAnimationEvent(akActor, "bleedOutStart")
		Utility.Wait(5.0)
		Debug.SendAnimationEvent(akActor, "bleedOutStop")
		
		GoToState("NothingEquipped")
	EndEvent

EndState
