Scriptname RegisterCustomRaceScript extends Quest

Race Property CustomRace Auto
Race Property CustomRaceVampire Auto
Race Property ProxyRace Auto

Event OnInit()
	self.Register(CustomRace, CustomRaceVampire, ProxyRace)
EndEvent


Function Register(Race standardRace, Race vampireRace, Race prxRace)
	int i
	int last
	
	;===================================================
	; find prxRace in PlayableRaceList
	;===================================================
	FormList PlayableRaceList = Game.GetFormFromFile(0x000D62, "RaceCompatibility.esm") as FormList
	FormList PlayableVampireList = Game.GetFormFromFile(0x000D63, "RaceCompatibility.esm") as FormList
	
	Race prxRaceVampire = prxRace
	i = 0
	last = PlayableRaceList.GetSize()
	while (i < last)
		if (prxRace == PlayableRaceList.GetAt(i) as Race)
			prxRaceVampire = PlayableVampireList.GetAt(i) as Race
			last = 0
		elseif (prxRace == PlayableVampireList.GetAt(i) as Race)
			prxRaceVampire = prxRace
			prxRace = PlayableRaceList.GetAt(i) as Race
			last = 0
		endif
		i += 1
	endwhile
	
	;===================================================
	; register CustomRace as a playable race.
	;===================================================
	Quest InitQuest = Game.GetFormFromFile(0x002859, "RaceCompatibility.esm") as Quest
	if (InitQuest != None)
		int element = 6 ; // default value - "6" means Nord
		i = 0
		last = 10
		while (i < last)
			Race akRace = Game.GetForm(0x013740 + i) as Race
			; 0x013740 - Argonian
			; 0x013741 - Breton
			; 0x013742 - DarkElf
			; 0x013743 - HighElf
			; 0x013744 - Imperial
			; 0x013745 - Khajiit
			; 0x013746 - Nord
			; 0x013747 - Orc
			; 0x013748 - Redguard
			; 0x013749 - WoodElf
			if (prxRace == akRace)
				element = i
				last = 0
			endif
			i += 1
		endwhile
		(InitQuest as YARC_InitQuestScript).RegisterRace(standardRace, vampireRace, element)
	else
		if (!PlayableRaceList.HasForm(standardRace) && !PlayableVampireList.HasForm(vampireRace))
			PlayableRaceList.AddForm(standardRace)
			PlayableVampireList.AddForm(vampireRace)
		endif
	endif
	
	;===================================================
	; append to head parts lists.
	;===================================================
	FormList[] HeadPartsList = new FormList[35]
	; Races
	HeadPartsList[ 0] = Game.GetForm(0x0D3E9E) as FormList; RacesHuman
	HeadPartsList[ 1] = Game.GetForm(0x0D3E9D) as FormList; RacesElf
	HeadPartsList[ 2] = Game.GetForm(0x06B305) as FormList; RacesBeast
	
	; Multi-Race Parts
	HeadPartsList[ 3] = Game.GetForm(0x0A803F) as FormList; HeadPartsAllRacesMinusBeast
	HeadPartsList[ 4] = Game.GetForm(0x107B9A) as FormList; HeadPartsAllRacesMinusBeastVampires
	
	; Human-Race Parts
	HeadPartsList[ 5] = Game.GetForm(0x0A8026) as FormList; HeadPartsHuman
	HeadPartsList[ 6] = Game.GetForm(0x0A8022) as FormList; HeadPartsHumanVampires
	HeadPartsList[ 7] = Game.GetForm(0x0A8023) as FormList; HeadPartsHumansandVampires
	HeadPartsList[ 8] = Game.GetForm(0x0F5BDF) as FormList; HeadPartsHumansOrcsandVampires
	HeadPartsList[ 9] = Game.GetForm(0x107B99) as FormList; HeadPartsHumanoidVampire
	HeadPartsList[10] = Game.GetForm(0x0F203B) as FormList; HeadPartsBretsNordsImpsandVampires
	
	; Elves Parts
	HeadPartsList[11] = Game.GetForm(0x0A8025) as FormList; HeadPartsElves
	HeadPartsList[12] = Game.GetForm(0x0A8024) as FormList; HeadPartsElvesandVampires
	
	; Single-Race Parts
	HeadPartsList[13] = Game.GetForm(0x0A8021) as FormList; HeadPartsArgonian
	HeadPartsList[14] = Game.GetForm(0x0A802F) as FormList; HeadPartsBreton
	HeadPartsList[15] = Game.GetForm(0x0A802B) as FormList; HeadPartsDarkElf
	HeadPartsList[16] = Game.GetForm(0x0A802D) as FormList; HeadPartsHighElf
	HeadPartsList[17] = Game.GetForm(0x0A803E) as FormList; HeadPartsImperial
	HeadPartsList[18] = Game.GetForm(0x0A8030) as FormList; HeadPartsKhajiit
	HeadPartsList[19] = Game.GetForm(0x0A802C) as FormList; HeadPartsNord
	HeadPartsList[20] = Game.GetForm(0x0A8028) as FormList; HeadPartsOrc
	HeadPartsList[21] = Game.GetForm(0x0A803A) as FormList; HeadPartsRedguard
	HeadPartsList[22] = Game.GetForm(0x0A802A) as FormList; HeadPartsWoodElf
	
	; Single-Race Parts and Vampire
	HeadPartsList[23] = Game.GetForm(0x0A8039) as FormList; HeadPartsArgonianandVampire
	HeadPartsList[24] = Game.GetForm(0x0A8037) as FormList; HeadPartsBretonandVampire
	HeadPartsList[25] = Game.GetForm(0x0A8038) as FormList; HeadPartsDarkElfandVampire
	HeadPartsList[26] = Game.GetForm(0x0A8035) as FormList; HeadPartsHighElfandVampire
	HeadPartsList[27] = Game.GetForm(0x0A8034) as FormList; HeadPartsImperialandVampire
	HeadPartsList[28] = Game.GetForm(0x0A8036) as FormList; HeadPartsKhajiitandVampire
	HeadPartsList[29] = Game.GetForm(0x0A8033) as FormList; HeadPartsNordandVampire
	HeadPartsList[30] = Game.GetForm(0x0A8032) as FormList; HeadPartsOrcandVampire
	HeadPartsList[31] = Game.GetForm(0x0A803B) as FormList; HeadPartsRedguardandVampire
	HeadPartsList[32] = Game.GetForm(0x0A8031) as FormList; HeadPartsWoodElfandVampire
	
	; Beast-Vampire Parts
	HeadPartsList[33] = Game.GetForm(0x0D82FA) as FormList; HeadPartsArgonianVampire
	HeadPartsList[34] = Game.GetForm(0x0D82FB) as FormList; HeadPartsKhajiitVampire
	
	i = 0
	while (i < HeadPartsList.Length)
		FormList HPLi = HeadPartsList[i]
		if (HPLi.HasForm(prxRace) && !HPLi.HasForm(standardRace))
			HPLi.AddForm(standardRace)
		endif
		if (HPLi.HasForm(prxRaceVampire) && !HPLi.HasForm(vampireRace))
			HPLi.AddForm(vampireRace)
		endif
		i += 1
	endwhile
EndFunction
