Scriptname YARC_InitQuestScript extends Quest Conditional

FormList Property PlayableRaceList Auto
FormList Property PlayableVampireList Auto
Keyword[] Property ActorProxyKeywords Auto
int[] Property VTFormIDs Auto
PlayerVampireQuestScript Property VampireQuest Auto
CompanionsHousekeepingScript Property CompanionsQuest Auto
Race Property ArgonianRace Auto
Race Property ArgonianRaceVampire Auto
Message Property ConflictVampireMessage Auto
Message Property ConflictCompanionsMessage Auto

bool SkipConflictVampireMessage = false
bool SkipConflictCompanionsMessage = false

Event OnInit()
	InitializeLater(1.0)
EndEvent


Event OnUpdate()
	Initialize()
EndEvent


Function Initialize()
	WaitState()
	Initialize()
EndFunction


Function InitializeLater(float time)
	RegisterForSingleUpdate(time)
EndFunction


Function SwitchRace()
	WaitState()
	SwitchRace()
EndFunction


Function RegisterRace(Race StandardRace, Race VampireRace, int ProxyIndex = 6) ; 6 ... NordRace
	WaitState()
	RegisterRace(StandardRace, VampireRace, ProxyIndex)
EndFunction



Function WaitState(string strState = "Ready", float waitcycle = 0.5)
	if (GetState() == "")
		GotoState("Ready")
	endif
	
	while (GetState() != strState)
		Utility.Wait(waitcycle)
	endwhile
EndFunction



int Function GetRaceIndex(Race akRace)
	FormList RaceList = None
	
	if (PlayableRaceList.HasForm(akRace))
		RaceList = PlayableRaceList
	elseif (PlayableVampireList.HasForm(akRace))
		RaceList = PlayableVampireList
	else
		return -1
	endif
	
	return RaceList.Find(akRace)
EndFunction


Race Function GetStandardRace(Race akRace)
	int Index = GetRaceIndex(akRace)
	if (Index == -1)
		return None
	endif
	return PlayableRaceList.GetAt(Index) as Race
EndFunction


Race Function GetVampireRace(Race akRace)
	int Index = GetRaceIndex(akRace)
	if (Index == -1)
		return None
	endif
	return PlayableVampireList.GetAt(Index) as Race
EndFunction


bool Function IsVanillaRace(Race akRace)
	int id = akRace.GetFormID() 
	return (Math.Floor(id / 0x01000000) == 0)
EndFunction



Function MergeRaceList(FormList StandardRaceList, FormList VampireRaceList)
	int Index = 0
	int Last = PlayableRaceList.GetSize()
	while (Index < Last)
		Race StandardRace = PlayableRaceList.GetAt(Index) as Race
		Race VampireRace = PlayableVampireList.GetAt(Index) as Race
		
		if (StandardRace != None && VampireRace != None)
			if ( (!StandardRaceList.HasForm(StandardRace)) && (!VampireRaceList.HasForm(VampireRace)) )
				StandardRaceList.AddForm(StandardRace)
				VampireRaceList.AddForm(VampireRace)
			endif
		endif
		
		Index += 1
	endwhile
EndFunction

;================================================================
auto state Ready
;================================================================

;Event OnBeginState()
;	Debug.Trace("YARC: state Ready")
;EndEvent


Function Initialize()
	GotoState("Initializing")
EndFunction


Function SwitchRace()
	GotoState("SwitchRace")
EndFunction


Function RegisterRace(Race StandardRace, Race VampireRace, int ProxyIndex = 6) ; 6 ... NordRace
	GotoState("RegisterRace")

;	Debug.Trace("YARC: RegisterRace( "+StandardRace+" , "+VampireRace+" , "+ProxyIndex+" )")
	
	if ( !PlayableRaceList.HasForm(StandardRace) && !PlayableVampireList.HasForm(VampireRace) )
		PlayableRaceList.AddForm(StandardRace)
		PlayableVampireList.AddForm(VampireRace)
	endif
	
	FormList mslVTRacesFL = Game.GetFormFromFile(0x00008EF8, "mslVampiricThirst.esp") as FormList
	if (mslVTRacesFL != None)
		FormList mslVTRacesVampiresFL = Game.GetFormFromFile(0x0000A9F0, "mslVampiricThirst.esp") as FormList
		if ( (!mslVTRacesFL.HasForm(StandardRace)) && (!mslVTRacesVampiresFL.HasForm(VampireRace)) )
			mslVTRacesFL.AddForm(StandardRace)
			mslVTRacesVampiresFL.AddForm(VampireRace)
		endif
		
		if (ProxyIndex < 0 || ProxyIndex > 9)
			ProxyIndex = 6
		endif
		
		FormList QualityRaceFL = Game.GetFormFromFile(VTFormIDs[ProxyIndex], "mslVampiricThirst.esp") as FormList
		if (!QualityRaceFL.HasForm(StandardRace))
			QualityRaceFL.AddForm(StandardRace)
		endif
		if (!QualityRaceFL.HasForm(VampireRace))
			QualityRaceFL.AddForm(VampireRace)
		endif
	endif
	
	GotoState("Ready")
EndFunction

endState

;================================================================
state Initializing
;================================================================

Event OnBeginState()
;	Debug.Trace("YARC: Initialize()")
	FormList mslVTRacesFL = Game.GetFormFromFile(0x008EF8, "mslVampiricThirst.esp") as FormList
	FormList zzExCharGenRaceList = Game.GetFormFromFile(0x009ED1, "CharacterMakingExtender.esp") as FormList
	bool bVampireConflict = false
	bool bCompanionsConflict = false
	
	;==============================
	; initialize & detect conflict
	;==============================
	if (zzExCharGenRaceList != None)
;		Debug.Trace("YARC: ===Detect MOD=== Character Making Extender")
		FormList zzExCharGenVampireList = Game.GetFormFromFile(0x009ED2, "CharacterMakingExtender.esp") as FormList
		
		MergeRaceList(zzExCharGenRaceList, zzExCharGenVampireList)
	endif
	
	if (mslVTRacesFL != None)
;		Debug.Trace("YARC: ===Detect MOD=== Vampiric Thirst")
		FormList mslVTRacesVampiresFL = Game.GetFormFromFile(0x0000A9F0, "mslVampiricThirst.esp") as FormList
		
		MergeRaceList(mslVTRacesFL, mslVTRacesVampiresFL)
		
		if (VampireQuest.mslVTFeedAction == None)
			bVampireConflict = true
		endif
	else
		if (VampireQuest.WoodElfRace == None)
			bVampireConflict = true
		endif
	endif
	
	if (CompanionsQuest.WoodElfRace == None)
		bCompanionsConflict = true
	endif
	
	
	;=================
	; conflict alert
	;=================
	if (bVampireConflict)
		if (!SkipConflictVampireMessage && ConflictVampireMessage.Show() != 0)
			SkipConflictVampireMessage = true
		endif
	else
		SkipConflictVampireMessage = false
	endif
	
	if (bCompanionsConflict)
		if (!SkipConflictCompanionsMessage && ConflictCompanionsMessage.Show() != 0)
			SkipConflictCompanionsMessage = true
		endif
	else
		SkipConflictCompanionsMessage = false
	endif
	
	GotoState("SwitchRace")
EndEvent

endState

;================================================================
state SwitchRace
;================================================================

Event OnBeginState()
;	Debug.Trace("YARC: SwitchRace()")
	Actor Player = Game.GetPlayer()
	
	Int RaceIndex = GetRaceIndex(Player.GetRace())
	Race StandardRace = PlayableRaceList.GetAt(RaceIndex) as Race
	Race VampireRace = PlayableVampireList.GetAt(RaceIndex) as Race
	
;	Debug.Trace("YARC: StandardRace = " + StandardRace)
;	Debug.Trace("YARC: VampireRace = " + VampireRace)
	
	if (RaceIndex != -1)
		CompanionsQuest.PlayerOriginalRace = StandardRace
		VampireQuest.CureRace = StandardRace
		
		if (IsVanillaRace(StandardRace))
			StandardRace = ArgonianRace
			VampireRace = ArgonianRaceVampire
		endif
		
		;==============================================================
		; applying a patch to the PlayableVampireQuestScript.pex
		;==============================================================
		if (VampireQuest.WoodElfRace != None)
			; Vanilla, Dawnguard, Better Vampires, etc
			VampireQuest.ArgonianRace = StandardRace
			VampireQuest.ArgonianRaceVampire = VampireRace
			
			Quest VampireTurnQuest = Game.GetFormFromFile(0x0000588c, "Dawnguard.esm") as Quest
			if (VampireTurnQuest != None)
				; Dawnguard
;				Debug.Trace("YARC: ===Detect MOD=== DLC1 Dawnguard")
				(VampireTurnQuest as DLC1VampireTurnScript).ArgonianRace = StandardRace
				(VampireTurnQuest as DLC1VampireTurnScript).ArgonianRaceVampire = VampireRace
			endif
		else
			if (Game.GetFormFromFile(0x00008EF8, "mslVampiricThirst.esp") != None)
				; Vampiric Thirst
;				Debug.Trace("YARC: ===Detect MOD=== Vampiric Thirst")
			else
				; unknown
				; Old Racial Compatibility's script? I will rewrite vars and check it just to be safe.
				VampireQuest.RaceList = PlayableRaceList
				if (VampireQuest.RaceList != None)
					Debug.Trace("YARC: (WARNING) You'll probably forget to delete PlayerVampireQuestScript.pex.")
					VampireQuest.VampireList = PlayableVampireList
				else
					Debug.Trace("YARC: (ERROR) CONFLICT!! The PlayerVampireQuestScript.pex has been rewritten by unknown mod.")
				endif
			endif
		endif
		
		;==============================================================
		; applying a patch to the CompanionsHousekeepingScript.pex
		;==============================================================
		if (CompanionsQuest.WoodElfRace != None)
			; Vanilla, Dawnguard, Better Vampires, Vampiric Thirst, etc
			CompanionsQuest.ArgonianRace = StandardRace
			CompanionsQuest.ArgonianRaceVampire = VampireRace
		else
			; unknown
			; Old Racial Compatibility's script? I will rewrite vars and check it just to be safe.
			CompanionsQuest.PlayableRaceList = PlayableRaceList
			if (CompanionsQuest.PlayableRaceList != None)
				Debug.Trace("YARC: (WARNING) You'll probably forget to delete CompanionsHousekeepingScript.pex.")
				CompanionsQuest.PlayableVampireList = PlayableVampireList
			else
				Debug.Trace("YARC: (ERROR) CONFLICT!! The CompanionsHousekeepingScript.pex has been rewritten by unknown mod.")
			endif
		endif
	endif
	
	GotoState("Ready")
EndEvent

endState

;================================================================
state RegisterRace
;================================================================

endState
