Scriptname YARC_PlayerAliasScript extends ReferenceAlias conditional

FormList Property PlayableRaceList Auto
FormList Property PlayableVampireList Auto
Race Property WerewolfBeastRace Auto
Keyword Property Vampire Auto

bool bIsInRaceMenu = false
Race OriginalRace = None
int  iRaceType = 0
;  0 ... human
;  1 ... vampire
;  2 ... werewolf
;  3 ... vampire lord
; -1 ... unknown race

Event OnInit()
	OnGameReload()
EndEvent


Event OnPlayerLoadGame()
	OnGameReload()
	YARC_InitQuestScript kmyQuest = self.GetOwningQuest() as YARC_InitQuestScript
	kmyQuest.InitializeLater(1.0)
EndEvent


Function OnGameReload()
	UnregisterForMenu("RaceSex Menu")
	RegisterForMenu("RaceSex Menu")
EndFunction


Event OnRaceSwitchComplete()
	if (!bIsInRaceMenu)
		YARC_InitQuestScript kmyQuest = self.GetOwningQuest() as YARC_InitQuestScript
		kmyQuest.SwitchRace()
	endif
EndEvent


Event OnMenuOpen(string menuName)
	if (menuName == "RaceSex menu")
		Actor player = Game.GetPlayer()
		Race playerRace = player.GetRace()
		
		bIsInRaceMenu = true
		OriginalRace  = playerRace
		iRaceType     = GetRaceType()
		
;		Debug.Trace("YARC: (OnMenuOpen) iRaceType=" + iRaceType)
;		Debug.Trace("YARC: (OnMenuOpen) OriginalRace=" + OriginalRace)
	endif
EndEvent


Event OnMenuClose(string menuName)
	if (menuName == "RaceSex menu")
		Actor player = Game.GetPlayer()
		Race playerRace = player.GetRace()
		YARC_InitQuestScript kmyQuest = self.GetOwningQuest() as YARC_InitQuestScript
		
		if (Game.GetFormFromFile(0x009ED1, "CharacterMakingExtender.esp") != None)
			; detects Character Making Extender
			if (OriginalRace && OriginalRace != playerRace)
				kmyQuest.SwitchRace()
			endif
		else
			if (OriginalRace && OriginalRace != playerRace)
				; do only when player race has been changed in ShowRaceMenu
				Race standardRace = kmyQuest.GetStandardRace(playerRace)
				Race vampireRace  = kmyQuest.GetVampireRace(playerRace)
				Race switchRace   = None
				
;				Debug.Trace("YARC: (OnMenuClose) playerRace=" + playerRace)
;				Debug.Trace("YARC: (OnMenuClose) standardRace=" + standardRace)
;				Debug.Trace("YARC: (OnMenuClose) vampireRace=" + vampireRace)
				
				if (standardRace != None && vampireRace != None)
					if (iRaceType == 0 || iRaceType == 2)
						; humans and werewolf
						switchRace = standardRace
					elseif (iRaceType == 1 || iRaceType == 3)
						; vampires and vampire load
						switchRace = vampireRace
					endif
					
					if (switchRace && switchRace != playerRace)
						player.SetRace(switchRace)
					endif
;					Debug.Trace("YARC: (OnMenuClose) switchRace=" + switchRace)
					kmyQuest.SwitchRace()
					
					if (iRaceType == 2)
						; werewolf
						player.SetRace(WerewolfBeastRace)
					elseif (iRaceType == 3)
						; vampire lord
						Race VampireBeastRace = Game.GetFormFromFile(0x00283A, "Dawnguard.esm") as Race;
						player.SetRace(VampireBeastRace)
					endif
				endif
			endif
		endif
		
		bIsInRaceMenu = false
		OriginalRace  = None
		iRaceType     = 0
	endif
EndEvent


int Function GetRaceType()
	Actor player = Game.GetPlayer()
	Race playerRace = player.GetRace()
	int type = -1
	
	YARC_InitQuestScript kmyQuest = self.GetOwningQuest() as YARC_InitQuestScript
	PlayableRaceList = kmyQuest.PlayableRaceList
	PlayableVampireList = kmyQuest.PlayableVampireList
	
	if (PlayableRaceList.HasForm(playerRace))
		; human race
		type = 0
	elseif (PlayableVampireList.HasForm(playerRace))
		; vampire race
		type = 1
	elseif (playerRace == WerewolfBeastRace)
		; werewolf
		type = 2
	elseif (player.HasKeyword(Vampire))
		Race VampireBeastRace = Game.GetFormFromFile(0x00283A, "Dawnguard.esm") as Race;
		if (VampireBeastRace && playerRace == VampireBeastRace)
			; vampire lord
			type = 3
		else
			; unknown vampire
			type = 1
		endif
	else
		; unknown race
		type = -1
	endif
	
	return type
EndFunction
