/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.tukaani.xz.LZMAInputStream;

class LZMADecDemo {
    LZMADecDemo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        byte[] buf = new byte[8192];
        String name = null;
        try {
            if (args.length == 0) {
                int size;
                name = "standard input";
                LZMAInputStream in = new LZMAInputStream(System.in);
                while ((size = in.read(buf)) != -1) {
                    System.out.write(buf, 0, size);
                }
            } else {
                for (int i = 0; i < args.length; ++i) {
                    name = args[i];
                    try (InputStream in = new FileInputStream(name);){
                        int size;
                        in = new BufferedInputStream(in);
                        in = new LZMAInputStream(in);
                        while ((size = in.read(buf)) != -1) {
                            System.out.write(buf, 0, size);
                        }
                        continue;
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("LZMADecDemo: Cannot open " + name + ": " + e.getMessage());
            System.exit(1);
        }
        catch (EOFException e) {
            System.err.println("LZMADecDemo: Unexpected end of input on " + name);
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("LZMADecDemo: Error decompressing from " + name + ": " + e.getMessage());
            System.exit(1);
        }
    }
}

