/*
 * Decompiled with CFR 0.152.
 */
import org.tukaani.xz.SeekableFileInputStream;
import org.tukaani.xz.SeekableXZInputStream;

class XZSeekDecDemo {
    XZSeekDecDemo() {
    }

    public static void main(String[] args) throws Exception {
        SeekableFileInputStream file = new SeekableFileInputStream(args[0]);
        SeekableXZInputStream in = new SeekableXZInputStream(file);
        System.err.println("Number of XZ Streams: " + in.getStreamCount());
        System.err.println("Number of XZ Blocks: " + in.getBlockCount());
        System.err.println("Uncompressed size: " + in.length() + " B");
        System.err.println("Largest XZ Block size: " + in.getLargestBlockSize() + " B");
        System.err.print("List of Check IDs:");
        int checkTypes = in.getCheckTypes();
        for (int i = 0; i < 16; ++i) {
            if ((checkTypes & 1 << i) == 0) continue;
            System.err.print(" " + i);
        }
        System.err.println();
        System.err.println("Index memory usage: " + in.getIndexMemoryUsage() + " KiB");
        byte[] buf = new byte[8192];
        if (args.length == 1) {
            int size;
            while ((size = in.read(buf)) != -1) {
                System.out.write(buf, 0, size);
            }
        } else {
            for (int i = 1; i < args.length; i += 2) {
                int size;
                int pos = Integer.parseInt(args[i]);
                in.seek(pos);
                for (int len = Integer.parseInt(args[i + 1]); len > 0; len -= size) {
                    size = Math.min(len, buf.length);
                    if ((size = in.read(buf, 0, size)) == -1) {
                        System.err.println("Error: End of file reached");
                        System.exit(1);
                    }
                    System.out.write(buf, 0, size);
                }
            }
        }
    }
}

