/*
 * Decompiled with CFR 0.152.
 */
import java.io.OutputStream;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.XZOutputStream;

class XZSeekEncDemo {
    XZSeekEncDemo() {
    }

    public static void main(String[] args) throws Exception {
        int size;
        LZMA2Options options = new LZMA2Options();
        if (args.length >= 1) {
            options.setPreset(Integer.parseInt(args[0]));
        }
        int blockSize = 0x100000;
        if (args.length >= 2) {
            blockSize = Integer.parseInt(args[1]);
        }
        options.setDictSize(Math.min(options.getDictSize(), Math.max(4096, blockSize)));
        System.err.println("Encoder memory usage: " + options.getEncoderMemoryUsage() + " KiB");
        System.err.println("Decoder memory usage: " + options.getDecoderMemoryUsage() + " KiB");
        System.err.println("Block size:           " + blockSize + " B");
        XZOutputStream out = new XZOutputStream((OutputStream)System.out, options);
        byte[] buf = new byte[8192];
        int left = blockSize;
        while ((size = System.in.read(buf, 0, Math.min(buf.length, left))) != -1) {
            out.write(buf, 0, size);
            if ((left -= size) != 0) continue;
            out.endBlock();
            left = blockSize;
        }
        out.finish();
    }
}

