/*
 * Decompiled with CFR 0.152.
 */
package restringer;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import restringer.ess.Element;

public class LittleEndianDataOutput
extends OutputStream
implements DataOutput,
Closeable {
    private final OutputStream BIGEND;
    private final byte[] BUFFER;
    private int position;

    public static LittleEndianDataOutput open(File file) throws FileNotFoundException {
        return new LittleEndianDataOutput(new BufferedOutputStream(new FileOutputStream(file)));
    }

    public static LittleEndianDataOutput wrap(OutputStream orig) {
        Objects.requireNonNull(orig);
        return new LittleEndianDataOutput(orig);
    }

    public static LittleEndianDataOutput test(File file) throws FileNotFoundException {
        return new LittleEndianDataOutput(new BufferedOutputStream(new FileOutputStream(file)));
    }

    public LittleEndianDataOutput(OutputStream bigEnd) {
        if (null == bigEnd) {
            throw new NullPointerException();
        }
        this.BIGEND = bigEnd;
        this.BUFFER = new byte[8];
    }

    @Override
    public void close() throws IOException {
        this.BIGEND.close();
    }

    @Override
    public void write(int b) throws IOException {
        this.BIGEND.write(b);
        ++this.position;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.BIGEND.write(b);
        this.position += b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.BIGEND.write(b, off, len);
        this.position += len;
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.BUFFER[0] = (byte)v;
        this.BUFFER[1] = (byte)(v >> 8);
        this.write(this.BUFFER, 0, 2);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.BUFFER[0] = (byte)v;
        this.BUFFER[1] = (byte)(v >> 8);
        this.BUFFER[2] = (byte)(v >> 16);
        this.BUFFER[3] = (byte)(v >> 24);
        this.write(this.BUFFER, 0, 4);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.BUFFER[0] = (byte)v;
        this.BUFFER[1] = (byte)(v >> 8);
        this.BUFFER[2] = (byte)(v >> 16);
        this.BUFFER[3] = (byte)(v >> 24);
        this.BUFFER[4] = (byte)(v >> 32);
        this.BUFFER[5] = (byte)(v >> 40);
        this.BUFFER[6] = (byte)(v >> 48);
        this.BUFFER[7] = (byte)(v >> 56);
        this.write(this.BUFFER, 0, 8);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.writeShort((short)v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeUTF(String s) throws IOException {
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        this.writeShort(bytes.length);
        this.write(bytes);
    }

    public void writeWString(String s) throws IOException {
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        this.writeShort(bytes.length);
        this.write(bytes);
    }

    public void writeLString(String s) throws IOException {
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        this.writeInt(bytes.length);
        this.write(bytes);
    }

    public void writeZString(String s) throws IOException {
        this.write(s.getBytes(StandardCharsets.UTF_8));
        this.writeByte(0);
    }

    public void writeESSElement(Element e) throws IOException {
        e.write(this);
    }

    public String toString() {
        return String.format("%s (pos=%d)", super.toString(), this.position);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeChars(String s) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected OutputStream getBigEndian() {
        return this.BIGEND;
    }

    public int getPosition() {
        return this.position;
    }
}

