/*
 * Decompiled with CFR 0.152.
 */
package restringer;

import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import java.io.Closeable;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public abstract class LittleEndianInput
extends InputStream
implements DataInput,
Closeable {
    private final byte[] BUFFER = new byte[8];

    @Override
    public abstract int available() throws IOException;

    @Override
    public abstract int read() throws IOException;

    @Override
    public abstract int read(byte[] var1) throws IOException;

    @Override
    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public void readFully(byte[] b) throws IOException {
        int bytesRead = this.read(b);
        if (bytesRead != b.length) {
            throw new IOException(String.format("Incorrect length; read %d bytes, expected %d.", bytesRead, b.length));
        }
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        int bytesRead = this.read(b, off, len);
        if (bytesRead != len) {
            throw new IOException(String.format("Incorrect length; read %d bytes, expected %d.", bytesRead, len));
        }
    }

    @Override
    public byte readByte() throws IOException {
        int val = this.read();
        byte val2 = (byte)val;
        return val2;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return 0xFF & this.read();
    }

    @Override
    public short readShort() throws IOException {
        this.readFully(this.BUFFER, 0, 2);
        return (short)(this.BUFFER[0] & 0xFF | (this.BUFFER[1] & 0xFF) << 8);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        this.readFully(this.BUFFER, 0, 2);
        return this.BUFFER[0] & 0xFF | (this.BUFFER[1] & 0xFF) << 8;
    }

    @Override
    public int readInt() throws IOException {
        this.readFully(this.BUFFER, 0, 4);
        return this.BUFFER[0] & 0xFF | (this.BUFFER[1] & 0xFF) << 8 | (this.BUFFER[2] & 0xFF) << 16 | (this.BUFFER[3] & 0xFF) << 24;
    }

    @Override
    public long readLong() throws IOException {
        this.readFully(this.BUFFER, 0, 8);
        long val = (long)(this.BUFFER[0] & 0xFF) | ((long)this.BUFFER[1] & 0xFFL) << 8 | ((long)this.BUFFER[2] & 0xFFL) << 16 | ((long)this.BUFFER[3] & 0xFFL) << 24 | ((long)this.BUFFER[4] & 0xFFL) << 32 | ((long)this.BUFFER[5] & 0xFFL) << 40 | ((long)this.BUFFER[6] & 0xFFL) << 48 | ((long)this.BUFFER[7] & 0xFFL) << 56;
        return val;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.read() != 0;
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.readShort();
    }

    @Override
    public float readFloat() throws IOException {
        int val = this.readInt();
        return Float.intBitsToFloat(val);
    }

    @Override
    public double readDouble() throws IOException {
        long val = this.readLong();
        return Double.longBitsToDouble(val);
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String readUTF() throws IOException {
        short length = this.readShort();
        byte[] bytes = new byte[length];
        int bytesRead = this.read(bytes);
        assert (bytesRead == length);
        String str = new String(bytes, "UTF-8");
        return str;
    }

    public String readBString() throws IOException {
        int length = this.readUnsignedByte();
        byte[] bytes = new byte[length];
        int bytesRead = this.read(bytes);
        assert (bytesRead == length);
        String str = new String(bytes, StandardCharsets.UTF_8);
        return str;
    }

    public String readWString() throws IOException {
        int length = this.readUnsignedShort();
        byte[] bytes = new byte[length];
        int bytesRead = this.read(bytes);
        assert (bytesRead == length) : String.format("bytes read %d, expected length %d", bytesRead, length);
        String str = new String(bytes, StandardCharsets.UTF_8);
        return str;
    }

    public String readLString() throws IOException {
        int length = this.readInt();
        byte[] bytes = new byte[length];
        int bytesRead = this.read(bytes);
        assert (bytesRead == length);
        String str = new String(bytes, StandardCharsets.UTF_8);
        return str;
    }

    public String readZString() throws IOException {
        byte[] buffer = this.readZStringRecursive(0);
        String str = new String(buffer, StandardCharsets.UTF_8);
        return str;
    }

    public String readZString(int size) throws IOException {
        StringBuilder BUF = new StringBuilder(size);
        byte b = (byte)this.read();
        while (b != 0) {
            BUF.append((char)b);
            b = (byte)this.read();
        }
        return BUF.toString();
    }

    public String readBZString() throws IOException {
        int length = this.readUnsignedByte();
        byte[] buffer = this.readZStringRecursive(0);
        assert (buffer.length + 1 == length);
        String str = new String(buffer, StandardCharsets.UTF_8);
        return str;
    }

    public String readLZString() throws IOException {
        int length = this.readInt();
        String s = this.readZString(length);
        assert (s.length() + 1 == length);
        return s;
    }

    private byte[] readZStringRecursive(int len) throws IOException {
        if (len > 256) {
            ByteArrayList tail = new ByteArrayList(256);
            byte b = (byte)this.read();
            while (b != 0) {
                tail.add(b);
                b = (byte)this.read();
            }
            byte[] result = new byte[len + tail.size()];
            for (int i = 0; i < tail.size(); ++i) {
                result[i + len] = (Byte)tail.get(i);
            }
            return result;
        }
        byte b = (byte)this.read();
        if (0 == b) {
            return new byte[len];
        }
        byte[] buffer = this.readZStringRecursive(len + 1);
        buffer[len] = b;
        return buffer;
    }
}

