/*
 * Decompiled with CFR 0.152.
 */
package restringer;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import restringer.LittleEndianInput;

public class LittleEndianInputStream
extends LittleEndianInput {
    private static final int CONTEXT_SIZE = 256;
    private final InputStream BIGEND;
    private final LinkedList<Integer> CTX_NEXT;
    private final LinkedList<Integer> CTX_PREV;
    private int position;
    final Pattern PATTERN = Pattern.compile("[ -~]");
    final Predicate<String> PRED = this.PATTERN.asPredicate();

    public static LittleEndianInputStream wrap(byte[] buf) {
        Objects.requireNonNull(buf);
        ByteArrayInputStream BIS = new ByteArrayInputStream(buf);
        return new LittleEndianInputStream(BIS, false, false);
    }

    public static LittleEndianInputStream wrap(InputStream orig) {
        Objects.requireNonNull(orig);
        return new LittleEndianInputStream(orig, false, false);
    }

    public static LittleEndianInputStream open(File file) throws FileNotFoundException {
        Objects.requireNonNull(file);
        assert (file.isFile());
        assert (file.canRead());
        assert (file.exists());
        BufferedInputStream BIS = new BufferedInputStream(new FileInputStream(file));
        return new LittleEndianInputStream(BIS, false, false);
    }

    public static LittleEndianInputStream debug(byte[] buf) {
        Objects.requireNonNull(buf);
        ByteArrayInputStream BIS = new ByteArrayInputStream(buf);
        return new LittleEndianInputStream(BIS, true, false);
    }

    public static LittleEndianInputStream debug(InputStream orig) {
        Objects.requireNonNull(orig);
        return new LittleEndianInputStream(orig, true, false);
    }

    public static LittleEndianInputStream wrapD(InputStream orig) {
        Objects.requireNonNull(orig);
        return new LittleEndianInputStream(orig, false, true);
    }

    public static LittleEndianInputStream openD(File file) throws FileNotFoundException {
        Objects.requireNonNull(file);
        assert (file.isFile());
        assert (file.canRead());
        assert (file.exists());
        BufferedInputStream BIS = new BufferedInputStream(new FileInputStream(file));
        return new LittleEndianInputStream(BIS, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LittleEndianInputStream(InputStream bigEnd, boolean context, boolean digest) {
        Objects.requireNonNull(bigEnd);
        if (digest) {
            InputStream i = bigEnd;
            try {
                MessageDigest DIGEST = MessageDigest.getInstance("MD5");
                DigestInputStream DIGESTER = new DigestInputStream(bigEnd, DIGEST);
                i = DIGESTER;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            finally {
                this.BIGEND = i;
            }
        } else {
            this.BIGEND = bigEnd;
        }
        this.CTX_NEXT = context ? new LinkedList() : null;
        this.CTX_PREV = context ? new LinkedList() : null;
        this.position = 0;
    }

    public InputStream getBigEndian() {
        return this.BIGEND;
    }

    @Override
    public int available() throws IOException {
        if (this.hasContext()) {
            return this.BIGEND.available() + this.CTX_NEXT.size();
        }
        return this.BIGEND.available();
    }

    @Override
    public void close() throws IOException {
        this.BIGEND.close();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        if (this.hasContext()) {
            for (int i = 0; i < n; ++i) {
                int b = this.read();
                if (b != -1) continue;
                return b - i;
            }
            return n;
        }
        return (int)this.BIGEND.skip(n);
    }

    @Override
    public int read() throws IOException {
        int val;
        int n = val = this.hasContext() ? this.contextRead() : this.BIGEND.read();
        if (val != -1) {
            ++this.position;
        } else assert (false);
        return val;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead;
        Objects.requireNonNull(b);
        assert (off >= 0);
        assert (off <= b.length);
        assert (len >= 0);
        assert (len <= b.length);
        assert (off + len <= b.length);
        int n = bytesRead = this.hasContext() ? this.contextRead(b, off, len) : this.BIGEND.read(b, off, len);
        if (bytesRead < 0) {
            return 0;
        }
        this.position += bytesRead;
        return bytesRead;
    }

    public String toString() {
        long available = -1L;
        try {
            available = this.available();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String s = String.format("%s (pos=%d/%d)", super.toString(), this.getPosition(), available);
        if (this.hasContext()) {
            return s + '\n' + this.contextString();
        }
        return s;
    }

    private boolean hasContext() {
        return null != this.CTX_NEXT;
    }

    private int contextRead() throws IOException {
        this.fillContext();
        if (this.CTX_NEXT.isEmpty()) {
            return -1;
        }
        int val = this.CTX_NEXT.pop();
        this.CTX_PREV.push(val);
        this.trimContext();
        assert (val != -1);
        return val;
    }

    private int contextRead(byte[] b, int off, int len) throws IOException {
        this.fillContext();
        int ctxSize = this.CTX_NEXT.size();
        if (len > ctxSize) {
            for (int i = 0; i < ctxSize; ++i) {
                b[off + i] = this.CTX_NEXT.pop().byteValue();
            }
            int r = this.BIGEND.read(b, off + ctxSize, len - ctxSize);
            this.CTX_PREV.clear();
            this.fillContext();
            return r += ctxSize;
        }
        for (int i = 0; i < len; ++i) {
            Integer val = this.CTX_NEXT.pop();
            this.CTX_PREV.push(val);
            b[off + i] = val.byteValue();
        }
        this.fillContext();
        this.trimContext();
        return len;
    }

    private void fillContext() throws IOException {
        int b;
        assert (null != this.CTX_NEXT);
        while (this.CTX_NEXT.size() < 256 && (b = this.BIGEND.read()) != -1) {
            this.CTX_NEXT.addLast(b);
        }
    }

    private void trimContext() throws IOException {
        assert (null != this.CTX_PREV);
        while (this.CTX_PREV.size() > 256) {
            this.CTX_PREV.removeLast();
        }
    }

    private String contextString() {
        int val;
        StringWriter writer = new StringWriter();
        int[] STUFF = new int[this.CTX_PREV.size() + this.CTX_NEXT.size()];
        int pos = this.CTX_PREV.size();
        int p = 0;
        int n1 = this.CTX_PREV.size();
        Iterator iterator = this.CTX_PREV.iterator();
        while (iterator.hasNext()) {
            STUFF[n1 - p - 1] = val = ((Integer)iterator.next()).intValue();
            ++p;
        }
        iterator = this.CTX_NEXT.iterator();
        while (iterator.hasNext()) {
            STUFF[p] = val = ((Integer)iterator.next()).intValue();
            ++p;
        }
        for (int k = 0; k < STUFF.length; k += 32) {
            for (int i = 0; i < 32 && i + k < STUFF.length; ++i) {
                p = k + i;
                if (p == pos) {
                    writer.append('[');
                } else if (i % 32 == 0) {
                    writer.append(' ');
                }
                writer.append(String.format("%02x", STUFF[k + i]));
                if (p == pos) {
                    writer.append(']');
                    continue;
                }
                writer.append(' ');
            }
            writer.append('\n');
        }
        return writer.toString();
    }

    public Long getDigest() {
        if (this.BIGEND instanceof DigestInputStream) {
            DigestInputStream DIS = (DigestInputStream)this.getBigEndian();
            try {
                MessageDigest DIGEST = (MessageDigest)DIS.getMessageDigest().clone();
                byte[] buf = DIGEST.digest();
                CRC32 CRC322 = new CRC32();
                CRC322.update(buf);
                long digest = CRC322.getValue();
                return digest;
            }
            catch (CloneNotSupportedException ex) {
                return null;
            }
        }
        return null;
    }

    public int getPosition() {
        return this.position;
    }
}

