/*
 * Decompiled with CFR 0.152.
 */
package restringer;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import restringer.ReAssembler;
import restringer.ReSaver;
import restringer.ReStringer;
import restringer.ess.Game;

public class Main {
    public static void main(String[] args) {
        CommandLine LINE;
        Options OPTIONS = new Options();
        OPTIONS.addOption("h", false, "Display these instructions.");
        OPTIONS.addOption("r", "resaver", false, "Launch ReSaver.");
        OPTIONS.addOption("t", "restringer", false, "Launch ReStringer.");
        OPTIONS.addOption("b", "bytecode", false, "Disassemble a PEX file to bytecode.");
        OPTIONS.addOption("s", "stripped", false, "Disassemble a PEX file to bytecode, and strip ::temps.");
        OPTIONS.addOption("c", "console", false, "Disassemble a PEX file to the screen instead of to a file.");
        DefaultParser PARSER = new DefaultParser();
        try {
            LINE = PARSER.parse(OPTIONS, args);
        }
        catch (ParseException ex) {
            System.err.println("Unexpected argument: " + ex.getMessage());
            HelpFormatter HELP = new HelpFormatter();
            HELP.printHelp("ReAssembler [OPTIONS] [FILE1] [FILE2] [FILE3] ...", OPTIONS);
            return;
        }
        if (LINE.hasOption('h')) {
            HelpFormatter HELP = new HelpFormatter();
            HELP.printHelp("ReAssembler [OPTIONS] [FILE1] [FILE2] [FILE3] ...", OPTIONS);
        } else if (LINE.hasOption('r')) {
            ReSaver.execute(LINE);
        } else if (LINE.hasOption('t')) {
            ReStringer.execute(LINE);
        } else if (LINE.getArgList().stream().anyMatch(ReAssembler.FILENAMEPATTERN.asPredicate())) {
            ReAssembler.execute(LINE);
        } else if (LINE.getArgList().size() == 1) {
            String ARG = LINE.getArgList().get(0);
            Game GAME = Game.matchFilename(ARG);
            if (GAME != null) {
                ReSaver.execute(LINE);
            }
        } else {
            System.out.println("No scriptfiles!");
            HelpFormatter HELP = new HelpFormatter();
            HELP.printHelp("ReAssembler [OPTIONS] [FILE1] [FILE2] [FILE3] ...", OPTIONS);
        }
    }
}

