/*
 * Decompiled with CFR 0.152.
 */
package restringer;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.apache.commons.cli.CommandLine;
import restringer.pex.AssemblyLevel;
import restringer.pex.Pex;

public class ReAssembler {
    static final Logger LOG = Logger.getLogger(ReAssembler.class.getCanonicalName());
    static final Pattern FILENAMEPATTERN = Pattern.compile("^.*\\.(pex)$", 2);

    public static void execute(CommandLine line) {
        try {
            LOG.getParent().addHandler(new FileHandler("ReAssembler.%g.log.xml", 0x100000, 1));
        }
        catch (IOException ex) {
            LOG.warning("Couldn't create log file.");
            LOG.warning(ex.toString());
        }
        LOG.getParent().getHandlers()[0].setFormatter(new Formatter(){

            @Override
            public String format(LogRecord record) {
                Level LEVEL = record.getLevel();
                String MSG = record.getMessage();
                String SRC = record.getSourceClassName() + "." + record.getSourceMethodName();
                return String.format("%s: %s (in %s)\n", LEVEL, MSG, SRC);
            }
        });
        LOG.setLevel(Level.FINE);
        LOG.getParent().getHandlers()[0].setLevel(Level.FINE);
        AssemblyLevel LEVEL = line.hasOption('s') ? AssemblyLevel.STRIPPED : (line.hasOption('b') ? AssemblyLevel.BYTECODE : AssemblyLevel.FULL);
        boolean CONSOLE = line.hasOption('c');
        List<String> FILES = line.getArgList();
        if (null == System.console() && !GraphicsEnvironment.isHeadless()) {
            if (FILES.isEmpty()) {
                JOptionPane.showMessageDialog(null, "No script files!", "Error", 0);
                return;
            }
            StringWriter BUF = new StringWriter(20480);
            PrintWriter OUT = new PrintWriter(BUF);
            OUT.println("<html>");
            for (String filename : FILES) {
                Pex SCRIPT;
                Matcher REGEX = FILENAMEPATTERN.matcher(filename);
                if (!REGEX.matches()) {
                    OUT.printf("<p>Skipped invalid filename: %s\n</p>", filename);
                    continue;
                }
                File SCRIPTFILE = new File(filename);
                try {
                    SCRIPT = Pex.readScript(SCRIPTFILE);
                }
                catch (IOException ex) {
                    OUT.printf("<p>Error reading script: %s\n</p>", filename);
                    continue;
                }
                try (StringWriter BUF2 = new StringWriter(2048);){
                    SCRIPT.disassemble(BUF2, LEVEL);
                    OUT.println("<code><pre>");
                    OUT.append(BUF2.toString());
                    OUT.println("</pre></code>");
                }
                catch (Error | Exception ex) {
                    OUT.printf("<p>Error disassembling script: %s\n</p>", filename);
                    continue;
                }
                OUT.println("<hr/>");
            }
            OUT.println("</html>");
            JTextPane pane = new JTextPane();
            pane.setFont(pane.getFont().deriveFont(12.0f));
            pane.setEditable(true);
            pane.setContentType("text/html");
            pane.setPreferredSize(new Dimension(850, 700));
            pane.setText(BUF.toString().replace("<", "%lt;"));
            JScrollPane scroller = new JScrollPane(pane);
            JOptionPane.showMessageDialog(null, scroller, "Disassembly", 1);
        } else {
            for (String filename : FILES) {
                File OUTFILE;
                block46: {
                    Pex SCRIPT;
                    Matcher REGEX = FILENAMEPATTERN.matcher(filename);
                    if (!REGEX.matches()) {
                        System.err.println("Skipping invalid filename: " + filename);
                        continue;
                    }
                    File SCRIPTFILE = new File(filename);
                    OUTFILE = LEVEL != AssemblyLevel.FULL ? new File(filename.replaceFirst("\\.pex$", ".txt")) : new File(filename.replaceFirst("\\.pex$", ".psc"));
                    try {
                        SCRIPT = Pex.readScript(SCRIPTFILE);
                    }
                    catch (IOException ex) {
                        System.err.println("Error reading script: " + ex.getMessage());
                        continue;
                    }
                    if (CONSOLE) {
                        try {
                            SCRIPT.disassemble(new PrintWriter(System.out), LEVEL);
                            break block46;
                        }
                        catch (RuntimeException ex) {
                            System.err.println("Error disassembling script: " + ex.getMessage());
                            continue;
                        }
                    }
                    try (BufferedWriter OUT = new BufferedWriter(new FileWriter(OUTFILE));){
                        SCRIPT.disassemble(OUT, LEVEL);
                    }
                    catch (IOException ex) {
                        System.err.println("Error disassembling script: " + ex.getMessage());
                        continue;
                    }
                }
                if (!CONSOLE && LEVEL != AssemblyLevel.FULL) {
                    System.out.println("Wrote disassembled script for " + filename + " to " + OUTFILE);
                    continue;
                }
                System.out.println("Wrote partially disassembled script for " + filename + " to " + OUTFILE);
            }
        }
    }
}

