/*
 * Decompiled with CFR 0.152.
 */
package restringer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import restringer.Mod;
import restringer.Pair;
import restringer.Profile;

public class Settings {
    public List<Profile> profiles = new ArrayList<Profile>();
    public int selectedProfile = -1;
    private static final File SETTINGS_FILE = new File("settings.json");
    private static final Gson GSON;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Settings readSettings() throws IOException {
        Throwable throwable;
        block29: {
            try {
                if (SETTINGS_FILE.exists()) break block29;
                throwable = null;
                try (FileWriter output = new FileWriter(SETTINGS_FILE);){
                    Settings settings2 = new Settings();
                    output.write(GSON.toJson(settings2));
                }
                catch (Throwable settings2) {
                    throwable = settings2;
                    throw settings2;
                }
            }
            catch (IOException ex) {
                throw new IOException("Can't create the settings file.", ex);
            }
        }
        if (!SETTINGS_FILE.canRead()) {
            throw new IOException("The settings file isn't readable.");
        }
        try {
            throwable = null;
            try (FileReader input = new FileReader(SETTINGS_FILE);){
                Settings settings;
                Settings settings3 = settings = GSON.fromJson((Reader)input, Settings.class);
                return settings3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException ex) {
            throw new IOException("Can't read the settings file.", ex);
        }
    }

    public static void writeSettings(Settings settings) throws IOException {
        Logger.getLogger(Settings.class.getCanonicalName()).info("Writing Settings");
        if (SETTINGS_FILE.exists() && !SETTINGS_FILE.canWrite()) {
            throw new IOException("The settings file isn't writable.");
        }
        try (FileWriter output = new FileWriter(SETTINGS_FILE);){
            output.write(GSON.toJson(settings));
        }
        catch (IOException ex) {
            throw new IOException("Can't write the settings file.", ex);
        }
    }

    public Profile getSelectedProfile() {
        if (this.profiles.isEmpty()) {
            this.profiles.add(new Profile("Default"));
            this.selectedProfile = 0;
        } else if (this.selectedProfile < 0 || this.selectedProfile >= this.profiles.size()) {
            this.selectedProfile = 0;
        }
        return this.profiles.get(this.selectedProfile);
    }

    static {
        GsonBuilder BUILDER = new GsonBuilder();
        BUILDER.setPrettyPrinting();
        BUILDER.registerTypeAdapter((Type)((Object)Mod.class), new ModSerializer());
        BUILDER.registerTypeAdapter((Type)((Object)File.class), new FileSerializer());
        GSON = BUILDER.create();
    }

    private static class FileSerializer
    implements JsonDeserializer<File>,
    JsonSerializer<File> {
        private FileSerializer() {
        }

        @Override
        public File deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Objects.requireNonNull(json);
            String path = json.getAsJsonPrimitive().getAsString();
            File file = new File(path);
            return file;
        }

        @Override
        public JsonElement serialize(File file, Type typeOfSrc, JsonSerializationContext context) {
            Objects.requireNonNull(file);
            String path = file.getPath();
            return new JsonPrimitive(path);
        }
    }

    private static class ModSerializer
    implements JsonDeserializer<Mod>,
    JsonSerializer<Mod> {
        private ModSerializer() {
        }

        @Override
        public Mod deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Objects.requireNonNull(json);
            assert (json.isJsonObject());
            Pair p = GSON.fromJson(json, Pair.class);
            Mod.Status status = Mod.Status.valueOf((String)p.A);
            String path = (String)p.B;
            File directory = new File(path);
            Mod mod = new Mod(directory);
            mod.setStatus(status);
            return mod;
        }

        @Override
        public JsonElement serialize(Mod mod, Type typeOfSrc, JsonSerializationContext context) {
            Objects.requireNonNull(mod);
            Mod.Status status = mod.getStatus();
            File directory = mod.getDirectory();
            String path = directory.getPath();
            Pair<Mod.Status, String> pair = new Pair<Mod.Status, String>(status, path);
            return GSON.toJsonTree(pair);
        }
    }
}

