/*
 * Decompiled with CFR 0.152.
 */
package restringer.bsa;

import java.io.IOException;
import restringer.LittleEndianRAF;

final class BSAHeader {
    public final byte[] FILEID = new byte[4];
    public final int VERSION;
    public final int FOLDER_OFFSET;
    public final int ARCHIVE_FLAGS;
    public final int FOLDER_COUNT;
    public final int FILE_COUNT;
    public final int TOTAL_FOLDERNAME_LENGTH;
    public final int TOTAL_FILENAME_LENGTH;
    public final int FILE_FLAGS;

    public BSAHeader(LittleEndianRAF input) throws IOException {
        input.readFully(this.FILEID);
        this.VERSION = input.readInt();
        this.FOLDER_OFFSET = input.readInt();
        this.ARCHIVE_FLAGS = input.readInt();
        this.FOLDER_COUNT = input.readInt();
        this.FILE_COUNT = input.readInt();
        this.TOTAL_FOLDERNAME_LENGTH = input.readInt();
        this.TOTAL_FILENAME_LENGTH = input.readInt();
        this.FILE_FLAGS = input.readInt();
    }

    public boolean isIncludeDirectoryName() {
        return (this.ARCHIVE_FLAGS & 1) != 0;
    }

    public boolean isIncludeFilenames() {
        return (this.ARCHIVE_FLAGS & 2) != 0;
    }

    public boolean isCompressedArchive() {
        return (this.ARCHIVE_FLAGS & 4) != 0;
    }

    public boolean isEmbedFilename() {
        return (this.ARCHIVE_FLAGS & 0x100) != 0;
    }

    public boolean containsMiscellaneous() {
        return (this.FILE_FLAGS & 0x100) != 0;
    }
}

