/*
 * Decompiled with CFR 0.152.
 */
package restringer.esp;

import java.io.IOException;
import restringer.IString;
import restringer.LittleEndianInput;
import restringer.esp.FieldBasic;
import restringer.esp.RecordTes4;

public class FieldFull
extends FieldBasic {
    private final String STR;
    private final int IDX;

    public FieldFull(IString code, LittleEndianInput input, int size, boolean big, RecordTes4 tes4) throws IOException {
        super(code, input, size, big);
        if (tes4.getHeader().isLocalized()) {
            assert (super.getData().length == 4);
            this.IDX = tes4.INDEX << 24 | super.getDecoder().readInt();
            this.STR = null;
        } else if (super.getData().length == 0) {
            this.STR = null;
            this.IDX = -1;
        } else {
            assert (super.getData()[super.getData().length - 1] == 0);
            this.STR = super.getDecoder().readZString(size);
            this.IDX = -1;
        }
    }

    public boolean hasString() {
        return null != this.STR;
    }

    public boolean hasIndex() {
        return this.IDX != -1;
    }

    public String getString() {
        assert (this.hasString());
        return this.STR;
    }

    public int getIndex() {
        assert (this.hasIndex());
        return this.IDX;
    }

    @Override
    public String toString() {
        StringBuilder BUF = new StringBuilder();
        if (this.hasIndex()) {
            BUF.append(this.getCode()).append("=").append(String.format("%08x", this.IDX));
        } else if (this.hasString()) {
            BUF.append(this.getCode()).append("=").append(this.STR);
        } else {
            BUF.append(this.getCode()).append("=");
        }
        return BUF.toString();
    }
}

