/*
 * Decompiled with CFR 0.152.
 */
package restringer.esp;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import restringer.IString;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.esp.Field;
import restringer.esp.FragmentBase;
import restringer.esp.FragmentInfoPack;
import restringer.esp.FragmentPerk;
import restringer.esp.FragmentQust;
import restringer.esp.FragmentScen;
import restringer.esp.RecordCode;
import restringer.esp.Script;

public class FieldVMAD
implements Field {
    private final RecordCode RECORDCODE;
    private final IString CODE;
    private final short VERSION;
    private final short OBJFORMAT;
    private final List<Script> SCRIPTS;
    private final List<FragmentBase> FRAGMENTS;
    final boolean BIG;

    public FieldVMAD(RecordCode recordCode, IString fieldCode, LittleEndianInput input, boolean big) throws IOException {
        assert (input.available() > 0);
        assert (fieldCode.equals(IString.get("VMAD")));
        this.RECORDCODE = recordCode;
        this.CODE = fieldCode;
        this.VERSION = input.readShort();
        this.OBJFORMAT = input.readShort();
        this.SCRIPTS = new LinkedList<Script>();
        this.FRAGMENTS = new LinkedList<FragmentBase>();
        this.BIG = big;
        int scriptCount = input.readUnsignedShort();
        for (int i = 0; i < scriptCount; ++i) {
            Script script = new Script(input);
            this.SCRIPTS.add(script);
        }
        block7: while (input.available() > 0) {
            switch (recordCode) {
                case INFO: 
                case PACK: {
                    this.FRAGMENTS.add(new FragmentInfoPack(input));
                    continue block7;
                }
                case PERK: {
                    this.FRAGMENTS.add(new FragmentPerk(input));
                    continue block7;
                }
                case QUST: {
                    this.FRAGMENTS.add(new FragmentQust(input));
                    continue block7;
                }
                case SCEN: {
                    this.FRAGMENTS.add(new FragmentScen(input));
                    continue block7;
                }
            }
            throw new IOException("Unexpected fragment type: " + (Object)((Object)recordCode));
        }
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        output.write(this.CODE.getBytes());
        if (this.BIG) {
            output.writeShort(0);
        } else {
            output.writeShort(this.calculateSize() - 6);
        }
        output.writeShort(this.VERSION);
        output.writeShort(this.OBJFORMAT);
        output.writeShort(this.SCRIPTS.size());
        for (Script script : this.SCRIPTS) {
            script.write(output);
        }
        for (FragmentBase fragment : this.FRAGMENTS) {
            fragment.write(output);
        }
    }

    @Override
    public int calculateSize() {
        int sum = 12;
        sum += this.SCRIPTS.stream().mapToInt(v -> v.calculateSize()).sum();
        return sum += this.FRAGMENTS.stream().mapToInt(v -> v.calculateSize()).sum();
    }

    @Override
    public IString getCode() {
        return this.CODE;
    }

    public String toString() {
        return this.getCode().toString();
    }
}

