/*
 * Decompiled with CFR 0.152.
 */
package restringer.esp;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import restringer.IString;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.esp.Entry;
import restringer.esp.FragmentBase;

public class FragmentPerk
extends FragmentBase {
    private final byte UNKNOWN;
    private final IString FILENAME;
    private final List<Fragment> FRAGMENTS;

    public FragmentPerk(LittleEndianInput input) throws IOException {
        this.UNKNOWN = input.readByte();
        this.FILENAME = IString.get(input.readUTF());
        this.FRAGMENTS = new LinkedList<Fragment>();
        int fragmentCount = input.readUnsignedShort();
        for (int i = 0; i < fragmentCount; ++i) {
            Fragment fragment = new Fragment(input);
            this.FRAGMENTS.add(fragment);
        }
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        output.writeByte(this.UNKNOWN);
        output.writeUTF(this.FILENAME.toString());
        output.writeShort(this.FRAGMENTS.size());
        for (Fragment fragment : this.FRAGMENTS) {
            fragment.write(output);
        }
    }

    @Override
    public int calculateSize() {
        int sum = 5 + this.FILENAME.length();
        return sum += this.FRAGMENTS.stream().mapToInt(v -> v.calculateSize()).sum();
    }

    public class Fragment
    implements Entry {
        private final int INDEX;
        private final short UNKNOWN1;
        private final byte UNKNOWN2;
        private final IString SCRIPTNAME;
        private final IString FRAGMENTNAME;

        public Fragment(LittleEndianInput input) throws IOException {
            this.INDEX = input.readUnsignedShort();
            this.UNKNOWN1 = input.readShort();
            this.UNKNOWN2 = input.readByte();
            this.SCRIPTNAME = IString.get(input.readUTF());
            this.FRAGMENTNAME = IString.get(input.readUTF());
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeShort(this.INDEX);
            output.writeShort(this.UNKNOWN1);
            output.writeByte(this.UNKNOWN2);
            output.writeUTF(this.SCRIPTNAME.toString());
            output.writeUTF(this.FRAGMENTNAME.toString());
        }

        @Override
        public int calculateSize() {
            return 9 + this.SCRIPTNAME.length() + this.FRAGMENTNAME.length();
        }
    }
}

