/*
 * Decompiled with CFR 0.152.
 */
package restringer.esp;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import restringer.IString;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.esp.Entry;
import restringer.esp.FragmentBase;
import restringer.esp.Script;

public class FragmentQust
extends FragmentBase {
    private final byte UNKNOWN;
    private final String FILENAME;
    private final List<Fragment> FRAGMENTS;
    private final List<Alias> ALIASES;

    public FragmentQust(LittleEndianInput input) throws IOException {
        this.UNKNOWN = input.readByte();
        int fragmentCount = input.readUnsignedShort();
        this.FILENAME = input.readUTF();
        this.FRAGMENTS = new LinkedList<Fragment>();
        this.ALIASES = new LinkedList<Alias>();
        for (int i = 0; i < fragmentCount; ++i) {
            Fragment fragment = new Fragment(input);
            this.FRAGMENTS.add(fragment);
        }
        int aliasCount = input.readUnsignedShort();
        for (int i = 0; i < aliasCount; ++i) {
            Alias alias = new Alias(input);
            this.ALIASES.add(alias);
        }
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        output.writeByte(this.UNKNOWN);
        output.writeShort(this.FRAGMENTS.size());
        output.writeUTF(this.FILENAME);
        for (Fragment fragment : this.FRAGMENTS) {
            fragment.write(output);
        }
        output.writeShort(this.ALIASES.size());
        for (Alias alias : this.ALIASES) {
            alias.write(output);
        }
    }

    @Override
    public int calculateSize() {
        int sum = 7 + this.FILENAME.length();
        sum += this.FRAGMENTS.stream().mapToInt(v -> v.calculateSize()).sum();
        return sum += this.ALIASES.stream().mapToInt(v -> v.calculateSize()).sum();
    }

    public class Alias
    implements Entry {
        private final long OBJECT;
        private final short VERSION;
        private final short OBJFORMAT;
        private final List<Script> SCRIPTS;

        public Alias(LittleEndianInput input) throws IOException {
            this.OBJECT = input.readLong();
            this.VERSION = input.readShort();
            this.OBJFORMAT = input.readShort();
            this.SCRIPTS = new LinkedList<Script>();
            int scriptCount = input.readUnsignedShort();
            for (int i = 0; i < scriptCount; ++i) {
                Script script = new Script(input);
                this.SCRIPTS.add(script);
            }
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeLong(this.OBJECT);
            output.writeShort(this.VERSION);
            output.writeShort(this.OBJFORMAT);
            output.writeShort(this.SCRIPTS.size());
            for (Script script : this.SCRIPTS) {
                script.write(output);
            }
        }

        @Override
        public int calculateSize() {
            int sum = 14;
            return sum += this.SCRIPTS.stream().mapToInt(v -> v.calculateSize()).sum();
        }
    }

    public class Fragment
    implements Entry {
        private final int INDEX;
        private final short UNKNOWN1;
        private final int LOGENTRY;
        private final byte UNKNOWN2;
        private final IString SCRIPTNAME;
        private final IString FRAGMENTNAME;

        public Fragment(LittleEndianInput input) throws IOException {
            this.INDEX = input.readUnsignedShort();
            this.UNKNOWN1 = input.readShort();
            this.LOGENTRY = input.readInt();
            this.UNKNOWN2 = input.readByte();
            this.SCRIPTNAME = IString.get(input.readUTF());
            this.FRAGMENTNAME = IString.get(input.readUTF());
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeShort(this.INDEX);
            output.writeShort(this.UNKNOWN1);
            output.writeInt(this.LOGENTRY);
            output.writeByte(this.UNKNOWN2);
            output.writeUTF(this.SCRIPTNAME.toString());
            output.writeUTF(this.FRAGMENTNAME.toString());
        }

        @Override
        public int calculateSize() {
            return 13 + this.SCRIPTNAME.length() + this.FRAGMENTNAME.length();
        }
    }
}

