/*
 * Decompiled with CFR 0.152.
 */
package restringer.esp;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import restringer.IString;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.esp.Entry;
import restringer.esp.FragmentBase;

public class FragmentScen
extends FragmentBase {
    private final byte UNKNOWN;
    private final byte FLAGS;
    private final String FILENAME;
    private final List<Fragment> FRAGMENTS;
    private final List<Phase> PHASES;

    public FragmentScen(LittleEndianInput input) throws IOException {
        this.UNKNOWN = input.readByte();
        this.FLAGS = input.readByte();
        this.FILENAME = input.readUTF();
        this.FRAGMENTS = new LinkedList<Fragment>();
        this.PHASES = new LinkedList<Phase>();
        int flagCount = FragmentBase.NumberOfSetBits(this.FLAGS);
        for (int i = 0; i < flagCount; ++i) {
            Fragment fragment = new Fragment(input);
            this.FRAGMENTS.add(fragment);
        }
        int phaseCount = input.readUnsignedShort();
        for (int i = 0; i < phaseCount; ++i) {
            Phase phase = new Phase(input);
            this.PHASES.add(phase);
        }
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        output.writeByte(this.UNKNOWN);
        output.writeByte(this.FLAGS);
        output.writeUTF(this.FILENAME);
        for (Fragment fragment : this.FRAGMENTS) {
            fragment.write(output);
        }
        output.writeShort(this.PHASES.size());
        for (Phase phase : this.PHASES) {
            phase.write(output);
        }
    }

    @Override
    public int calculateSize() {
        int sum = 6;
        sum += this.FRAGMENTS.stream().mapToInt(v -> v.calculateSize()).sum();
        return sum += this.PHASES.stream().mapToInt(v -> v.calculateSize()).sum();
    }

    public class Phase
    implements Entry {
        private final byte UNKNOWN1;
        private final int PHASE;
        private final byte UNKNOWN2;
        private final IString SCRIPTNAME;
        private final IString FRAGMENTNAME;

        public Phase(LittleEndianInput input) throws IOException {
            this.UNKNOWN1 = input.readByte();
            this.PHASE = input.readInt();
            this.UNKNOWN2 = input.readByte();
            this.SCRIPTNAME = IString.get(input.readUTF());
            this.FRAGMENTNAME = IString.get(input.readUTF());
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeByte(this.UNKNOWN1);
            output.writeInt(this.PHASE);
            output.writeByte(this.UNKNOWN2);
            output.writeUTF(this.SCRIPTNAME.toString());
            output.writeUTF(this.FRAGMENTNAME.toString());
        }

        @Override
        public int calculateSize() {
            return 10 + this.SCRIPTNAME.length() + this.FRAGMENTNAME.length();
        }
    }

    public class Fragment
    implements Entry {
        private final byte UNKNOWN;
        private final IString SCRIPTNAME;
        private final IString FRAGMENTNAME;

        public Fragment(LittleEndianInput input) throws IOException {
            this.UNKNOWN = input.readByte();
            this.SCRIPTNAME = IString.get(input.readUTF());
            this.FRAGMENTNAME = IString.get(input.readUTF());
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeByte(this.UNKNOWN);
            output.writeUTF(this.SCRIPTNAME.toString());
            output.writeUTF(this.FRAGMENTNAME.toString());
        }

        @Override
        public int calculateSize() {
            return 5 + this.SCRIPTNAME.length() + this.FRAGMENTNAME.length();
        }
    }
}

